/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import ir.map.sdk_map.MapStrictMode;
import ir.map.sdk_map.ModuleProvider;
import ir.map.sdk_map.ModuleProviderImpl;
import ir.map.sdk_map.constants.MapirConstants;
import ir.map.sdk_map.exceptions.MapirConfigurationException;
import ir.map.sdk_map.log.Logger;
import ir.map.sdk_map.maps.TelemetryDefinition;
import ir.map.sdk_map.net.ConnectivityReceiver;
import ir.map.sdk_map.storage.FileSource;
import ir.map.sdk_map.utils.ThreadUtils;

@UiThread
@SuppressLint(value={"StaticFieldLeak"})
public final class Mapir {
    private static final String TAG = "Mbgl-Mapir";
    private static ModuleProvider moduleProvider;
    private static Mapir INSTANCE;
    private Context context;
    private String accessToken;
    private Boolean connected;
    private TelemetryDefinition telemetry;

    Mapir(@NonNull Context context, @Nullable String accessToken) {
        this.context = context;
        this.accessToken = accessToken;
    }

    @UiThread
    public static synchronized Mapir getInstance(@NonNull Context context, @NonNull String accessToken) {
        ThreadUtils.checkThread("Mapir");
        if (INSTANCE == null) {
            Context appContext = context.getApplicationContext();
            FileSource.initializeFileDirsPaths(appContext);
            INSTANCE = new Mapir(appContext, accessToken);
            if (Mapir.isAccessTokenValid(accessToken)) {
                Mapir.initializeTelemetry();
            }
            ConnectivityReceiver.instance(appContext);
        }
        return INSTANCE;
    }

    @Nullable
    public static String getAccessToken() {
        Mapir.validateMapir();
        return Mapir.INSTANCE.accessToken;
    }

    public static void setAccessToken(String accessToken) {
        Mapir.validateMapir();
        Mapir.INSTANCE.accessToken = accessToken;
        FileSource.getInstance(Mapir.getApplicationContext()).setAccessToken(accessToken);
    }

    @NonNull
    public static Context getApplicationContext() {
        Mapir.validateMapir();
        return Mapir.INSTANCE.context;
    }

    public static synchronized void setConnected(Boolean connected) {
        Mapir.validateMapir();
        Mapir.INSTANCE.connected = connected;
    }

    public static synchronized Boolean isConnected() {
        Mapir.validateMapir();
        if (Mapir.INSTANCE.connected != null) {
            return Mapir.INSTANCE.connected;
        }
        ConnectivityManager cm = (ConnectivityManager)Mapir.INSTANCE.context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }

    private static void initializeTelemetry() {
        try {
            Mapir.INSTANCE.telemetry = Mapir.getModuleProvider().obtainTelemetry();
        }
        catch (Exception exception) {
            String message = "Error occurred while initializing telemetry";
            Logger.e(TAG, message, exception);
            MapStrictMode.strictModeViolation(message, exception);
        }
    }

    @Nullable
    public static TelemetryDefinition getTelemetry() {
        return Mapir.INSTANCE.telemetry;
    }

    @NonNull
    public static ModuleProvider getModuleProvider() {
        if (moduleProvider == null) {
            moduleProvider = new ModuleProviderImpl();
        }
        return moduleProvider;
    }

    private static void validateMapir() {
        if (INSTANCE == null) {
            throw new MapirConfigurationException();
        }
    }

    static boolean isAccessTokenValid(String accessToken) {
        if (accessToken == null) {
            return false;
        }
        return (accessToken = accessToken.trim().toLowerCase(MapirConstants.MAPIR_LOCALE)).length() != 0 && (accessToken.startsWith("pk.") || accessToken.startsWith("sk."));
    }
}

