// This file is generated. Edit android/platform/scripts/generate-style-code.js, then run `make android-style-code`.

package ir.map.sdk_map.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;

import com.google.gson.JsonArray;

import ir.map.sdk_map.style.expressions.Expression;

import static ir.map.sdk_map.utils.ColorUtils.rgbaToColor;

/**
 * A heatmap.
 *
 * @see <a href="https://www.mapbox.com/mapbox-gl-style-spec/#layers-heatmap">The online documentation</a>
 */
@UiThread
public class HeatmapLayer extends Layer {

  /**
   * Creates a HeatmapLayer.
   *
   * @param nativePtr pointer used by core
   */
  @Keep
  HeatmapLayer(long nativePtr) {
    super(nativePtr);
  }

  /**
   * Creates a HeatmapLayer.
   *
   * @param layerId  the id of the layer
   * @param sourceId the id of the source
   */
  public HeatmapLayer(String layerId, String sourceId) {
    super();
    initialize(layerId, sourceId);
  }

  @Keep
  protected native void initialize(String layerId, String sourceId);

  /**
   * Set the source Layer.
   *
   * @param sourceLayer the source layer to set
   * @return This
   */
  public HeatmapLayer withSourceLayer(String sourceLayer) {
    setSourceLayer(sourceLayer);
    return this;
  }

  /**
   * Get the source id.
   *
   * @return id of the source
   */
  public String getSourceId() {
    checkThread();
    return nativeGetSourceId();
  }

  /**
   * Get the source layer.
   *
   * @return sourceLayer the source layer to get
   */
  public String getSourceLayer() {
    checkThread();
    return nativeGetSourceLayer();
  }

  /**
   * Set the source layer.
   *
   * @param sourceLayer the source layer to set
   */
  public void setSourceLayer(String sourceLayer) {
    checkThread();
    nativeSetSourceLayer(sourceLayer);
  }

  /**
   * Set a single expression filter.
   *
   * @param filter the expression filter to set
   * @return This
   */
  public HeatmapLayer withFilter(Expression filter) {
    setFilter(filter);
    return this;
  }

  /**
   * Get a single expression filter.
   *
   * @return the expression filter to get
   */
  @Nullable
  public Expression getFilter() {
    checkThread();
    Expression expression = null;
    JsonArray array = (JsonArray) nativeGetFilter();
    if (array != null) {
      expression = Expression.Converter.convert(array);
    }
    return expression;
  }

  /**
   * Set a single expression filter.
   *
   * @param filter the expression filter to set
   */
  public void setFilter(Expression filter) {
    checkThread();
    nativeSetFilter(filter.toArray());
  }

  /**
   * Set a property or properties.
   *
   * @param properties the var-args properties
   * @return This
   */
  public HeatmapLayer withProperties(@NonNull PropertyValue<?>... properties) {
    setProperties(properties);
    return this;
  }

  // Property getters

  /**
   * Get the HeatmapRadius property
   *
   * @return property wrapper value around Float
   */
  @SuppressWarnings("unchecked")
  public PropertyValue<Float> getHeatmapRadius() {
    checkThread();
    return (PropertyValue<Float>) new PropertyValue("heatmap-radius", nativeGetHeatmapRadius());
  }

  /**
   * Get the HeatmapRadius property transition options
   *
   * @return transition options for Float
   */
  public TransitionOptions getHeatmapRadiusTransition() {
    checkThread();
    return nativeGetHeatmapRadiusTransition();
  }

  /**
   * Set the HeatmapRadius property transition options
   *
   * @param options transition options for Float
   */
  public void setHeatmapRadiusTransition(TransitionOptions options) {
    checkThread();
    nativeSetHeatmapRadiusTransition(options.getDuration(), options.getDelay());
  }

  /**
   * Get the HeatmapWeight property
   *
   * @return property wrapper value around Float
   */
  @SuppressWarnings("unchecked")
  public PropertyValue<Float> getHeatmapWeight() {
    checkThread();
    return (PropertyValue<Float>) new PropertyValue("heatmap-weight", nativeGetHeatmapWeight());
  }

  /**
   * Get the HeatmapIntensity property
   *
   * @return property wrapper value around Float
   */
  @SuppressWarnings("unchecked")
  public PropertyValue<Float> getHeatmapIntensity() {
    checkThread();
    return (PropertyValue<Float>) new PropertyValue("heatmap-intensity", nativeGetHeatmapIntensity());
  }

  /**
   * Get the HeatmapIntensity property transition options
   *
   * @return transition options for Float
   */
  public TransitionOptions getHeatmapIntensityTransition() {
    checkThread();
    return nativeGetHeatmapIntensityTransition();
  }

  /**
   * Set the HeatmapIntensity property transition options
   *
   * @param options transition options for Float
   */
  public void setHeatmapIntensityTransition(TransitionOptions options) {
    checkThread();
    nativeSetHeatmapIntensityTransition(options.getDuration(), options.getDelay());
  }

  /**
   * Get the HeatmapColor property
   *
   * @return property wrapper value around String
   */
  @SuppressWarnings("unchecked")
  public PropertyValue<String> getHeatmapColor() {
    checkThread();
    return (PropertyValue<String>) new PropertyValue("heatmap-color", nativeGetHeatmapColor());
  }

  /**
   * Defines the color of each pixel based on its density value in a heatmap.  Should be an expression that uses `["heatmap-density"]` as input.
   *
   * @return int representation of a rgba string color
   * @throws RuntimeException thrown if property isn't a value
   */
  @ColorInt
  public int getHeatmapColorAsInt() {
    checkThread();
    PropertyValue<String> value = getHeatmapColor();
    if (value.isValue()) {
      return rgbaToColor(value.getValue());
    } else {
      throw new RuntimeException("heatmap-color was set as a Function");
    }
  }

  /**
   * Get the HeatmapOpacity property
   *
   * @return property wrapper value around Float
   */
  @SuppressWarnings("unchecked")
  public PropertyValue<Float> getHeatmapOpacity() {
    checkThread();
    return (PropertyValue<Float>) new PropertyValue("heatmap-opacity", nativeGetHeatmapOpacity());
  }

  /**
   * Get the HeatmapOpacity property transition options
   *
   * @return transition options for Float
   */
  public TransitionOptions getHeatmapOpacityTransition() {
    checkThread();
    return nativeGetHeatmapOpacityTransition();
  }

  /**
   * Set the HeatmapOpacity property transition options
   *
   * @param options transition options for Float
   */
  public void setHeatmapOpacityTransition(TransitionOptions options) {
    checkThread();
    nativeSetHeatmapOpacityTransition(options.getDuration(), options.getDelay());
  }

  @Keep
  private native Object nativeGetHeatmapRadius();

  @Keep
  private native TransitionOptions nativeGetHeatmapRadiusTransition();

  @Keep
  private native void nativeSetHeatmapRadiusTransition(long duration, long delay);

  @Keep
  private native Object nativeGetHeatmapWeight();

  @Keep
  private native Object nativeGetHeatmapIntensity();

  @Keep
  private native TransitionOptions nativeGetHeatmapIntensityTransition();

  @Keep
  private native void nativeSetHeatmapIntensityTransition(long duration, long delay);

  @Keep
  private native Object nativeGetHeatmapColor();

  @Keep
  private native Object nativeGetHeatmapOpacity();

  @Keep
  private native TransitionOptions nativeGetHeatmapOpacityTransition();

  @Keep
  private native void nativeSetHeatmapOpacityTransition(long duration, long delay);

  @Override
  @Keep
  protected native void finalize() throws Throwable;

}
