package ir.map.sdk_map.maps;

import android.graphics.RectF;
import android.support.v4.util.LongSparseArray;

import java.util.ArrayList;
import java.util.List;

import ir.map.sdk_map.annotations.Annotation;

class ShapeAnnotationContainer implements ShapeAnnotations {

  private final NativeMapView nativeMapView;
  private final LongSparseArray<Annotation> annotations;

  ShapeAnnotationContainer(NativeMapView nativeMapView, LongSparseArray<Annotation> annotations) {
    this.nativeMapView = nativeMapView;
    this.annotations = annotations;
  }

  @Override
  public List<Annotation> obtainAllIn(RectF rectangle) {
    RectF rect = nativeMapView.getDensityDependantRectangle(rectangle);
    long[] annotationIds = nativeMapView.queryShapeAnnotations(rect);
    return getAnnotationsFromIds(annotationIds);
  }

  private List<Annotation> getAnnotationsFromIds(long[] annotationIds) {
    List<Annotation> shapeAnnotations = new ArrayList<>();
    for (long annotationId : annotationIds) {
      Annotation annotation = annotations.get(annotationId);
      if (annotation != null) {
        shapeAnnotations.add(annotation);
      }
    }
    return shapeAnnotations;
  }
}
