package ir.map.sdk_map.location;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;

import ir.map.sdk_map.R;

import static ir.map.sdk_map.location.Utils.generateShadow;
import static ir.map.sdk_map.location.Utils.getBitmapFromDrawable;
import static ir.map.sdk_map.location.Utils.getDrawable;

class LayerBitmapProvider {

  private final Context context;

  LayerBitmapProvider(Context context) {
    this.context = context;
  }

  Bitmap generateBitmap(@DrawableRes int drawableRes, @ColorInt Integer tintColor) {
    Drawable drawable = getDrawable(context, drawableRes, tintColor);
    return getBitmapFromDrawable(drawable);
  }

  Bitmap generateShadowBitmap(LocationComponentOptions options) {
    Drawable shadowDrawable = ContextCompat.getDrawable(context, R.drawable.mapir_user_icon_shadow);
    return generateShadow(shadowDrawable, options.elevation());
  }
}
