package ir.map.sdk_map.constants;

import java.util.Locale;

/**
 * MapirConstants exposes Mapir related constants
 */
public class MapirConstants {

  /**
   * Default Locale for data processing (ex: String.toLowerCase(MAPIR_LOCALE, "foo"))
   */
  public static final Locale MAPIR_LOCALE = Locale.US;

  /**
   * Key used to switch storage to external in AndroidManifest.xml
   */
  public static final String KEY_META_DATA_SET_STORAGE_EXTERNAL = "ir.map.SetStorageExternal";

  /**
   * Default value for KEY_META_DATA_SET_STORAGE_EXTERNAL (default is internal storage)
   */
  public static final boolean DEFAULT_SET_STORAGE_EXTERNAL = false;

  /**
   * Unmeasured state
   */
  public static final float UNMEASURED = -1f;

  /**
   * Default animation time
   */
  public static final int ANIMATION_DURATION = 300;

  /**
   * Default short animation time
   */
  public static final int ANIMATION_DURATION_SHORT = 150;

  /**
   * Animation time of a fling gesture
   */
  public static final long ANIMATION_DURATION_FLING_BASE = ANIMATION_DURATION_SHORT;

  /**
   * Velocity threshold for a fling gesture
   */
  public static final long VELOCITY_THRESHOLD_IGNORE_FLING = 1000;

  /**
   * Value by which the default rotation threshold will be increased when scaling
   */
  public static final float ROTATION_THRESHOLD_INCREASE_WHEN_SCALING = 25f;

  /**
   * Time within which user needs to lift fingers for velocity animation to start.
   */
  public static final long SCHEDULED_ANIMATION_TIMEOUT = 150L;

  /**
   * Minimum angular velocity for rotation animation
   */
  public static final float MINIMUM_ANGULAR_VELOCITY = 1.5f;

  /**
   * Maximum angular velocity for rotation animation
   */
  public static final float MAXIMUM_ANGULAR_VELOCITY = 20f;

  /**
   * Factor to calculate tilt change based on pixel change during shove gesture.
   */
  public static final float SHOVE_PIXEL_CHANGE_FACTOR = 0.1f;

  /**
   * The currently supported minimum zoom level.
   */
  public static final float MINIMUM_ZOOM = 0.0f;

  /**
   * The currently supported maximum zoom level.
   */
  public static final float MAXIMUM_ZOOM = 25.5f;

  /**
   * The currently supported maximum tilt value.
   */
  public static final double MAXIMUM_TILT = 60;

  /**
   * The currently supported minimum tilt value.
   */
  public static final double MINIMUM_TILT = 0;

  /**
   * The currently supported maximum direction
   */
  public static final double MAXIMUM_DIRECTION = 360;

  /**
   * The currently supported minimum direction
   */
  public static final double MINIMUM_DIRECTION = 0;

  /**
   * The currently used minimum scale factor to clamp to when a quick zoom gesture occurs
   */
  public static final float MINIMUM_SCALE_FACTOR_CLAMP = 0.00f;

  /**
   * The currently used maximum scale factor to clamp to when a quick zoom gesture occurs
   */
  public static final float MAXIMUM_SCALE_FACTOR_CLAMP = 0.15f;

  /**
   * Fragment Argument Key for MapirMapOptions
   */
  public static final String FRAG_ARG_MAPIRMAPOPTIONS = "MapirMapOptions";

  // Save instance state keys
  public static final String STATE_HAS_SAVED_STATE = "mapir_savedState";
  public static final String STATE_CAMERA_POSITION = "mapir_cameraPosition";
  public static final String STATE_ZOOM_ENABLED = "mapir_zoomEnabled";
  public static final String STATE_SCROLL_ENABLED = "mapir_scrollEnabled";
  public static final String STATE_ROTATE_ENABLED = "mapir_rotateEnabled";
  public static final String STATE_TILT_ENABLED = "mapir_tiltEnabled";
  public static final String STATE_ZOOM_CONTROLS_ENABLED = "mapir_zoomControlsEnabled";
  public static final String STATE_DOUBLE_TAP_ENABLED = "mapir_doubleTapEnabled";
  public static final String STATE_DEBUG_ACTIVE = "mapir_debugActive";
  public static final String STATE_STYLE_URL = "mapir_styleUrl";
  public static final String STATE_COMPASS_ENABLED = "mapir_compassEnabled";
  public static final String STATE_COMPASS_GRAVITY = "mapir_compassGravity";
  public static final String STATE_COMPASS_MARGIN_LEFT = "mapir_compassMarginLeft";
  public static final String STATE_COMPASS_MARGIN_TOP = "mapir_compassMarginTop";
  public static final String STATE_COMPASS_MARGIN_RIGHT = "mapir_compassMarginRight";
  public static final String STATE_COMPASS_MARGIN_BOTTOM = "mapir_compassMarginBottom";
  public static final String STATE_COMPASS_FADE_WHEN_FACING_NORTH = "mapir_compassFade";
  public static final String STATE_COMPASS_IMAGE_BITMAP = "mapir_compassImage";
  public static final String STATE_LOGO_GRAVITY = "mapir_logoGravity";
  public static final String STATE_LOGO_MARGIN_LEFT = "mapir_logoMarginLeft";
  public static final String STATE_LOGO_MARGIN_TOP = "mapir_logoMarginTop";
  public static final String STATE_LOGO_MARGIN_RIGHT = "mapir_logoMarginRight";
  public static final String STATE_LOGO_MARGIN_BOTTOM = "mapir_logoMarginBottom";
  public static final String STATE_LOGO_ENABLED = "mapir_logoEnabled";
  public static final String STATE_ATTRIBUTION_GRAVITY = "mapir_attrGravity";
  public static final String STATE_ATTRIBUTION_MARGIN_LEFT = "mapir_attrMarginLeft";
  public static final String STATE_ATTRIBUTION_MARGIN_TOP = "mapir_attrMarginTop";
  public static final String STATE_ATTRIBUTION_MARGIN_RIGHT = "mapir_attrMarginRight";
  public static final String STATE_ATTRIBUTION_MARGIN_BOTTOM = "mapir_atrrMarginBottom";
  public static final String STATE_ATTRIBUTION_ENABLED = "mapir_atrrEnabled";
  public static final String STATE_DESELECT_MARKER_ON_TAP = "mapir_deselectMarkerOnTap";
  public static final String STATE_USER_FOCAL_POINT = "mapir_userFocalPoint";
  public static final String STATE_SCALE_ANIMATION_ENABLED = "mapir_scaleAnimationEnabled";
  public static final String STATE_ROTATE_ANIMATION_ENABLED = "mapir_rotateAnimationEnabled";
  public static final String STATE_FLING_ANIMATION_ENABLED = "mapir_flingAnimationEnabled";
  public static final String STATE_INCREASE_ROTATE_THRESHOLD = "mapir_increaseRotateThreshold";
  public static final String STATE_INCREASE_SCALE_THRESHOLD = "mapir_increaseScaleThreshold";

}
