/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.wrapper;

import android.graphics.Point;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_map.wrapper.MaptexCameraPosition;
import ir.map.sdk_map.wrapper.MaptexCameraUpdate;
import ir.map.sdk_map.wrapper.MaptexLatLngBounds;

public final class MaptexCameraUpdateFactory {
    private MaptexCameraUpdateFactory() {
    }

    public static MaptexCameraUpdate newCameraPosition(MaptexCameraPosition maptexCameraPosition) {
        return new MaptexCameraUpdate(CameraUpdateFactory.newCameraPosition((CameraPosition)maptexCameraPosition.mOriginal));
    }

    public static MaptexCameraUpdate newLatLng(MaptexLatLng maptexLatLng) {
        return new MaptexCameraUpdate(CameraUpdateFactory.newLatLng((LatLng)new LatLng(maptexLatLng.latitude, maptexLatLng.longitude)));
    }

    public static MaptexCameraUpdate newLatLngBounds(MaptexLatLngBounds maptexLatLngBounds, int n2) {
        return new MaptexCameraUpdate(CameraUpdateFactory.newLatLngBounds((LatLngBounds)maptexLatLngBounds.mOriginal, (int)n2));
    }

    public static MaptexCameraUpdate newLatLngBounds(MaptexLatLngBounds maptexLatLngBounds, int n2, int n3, int n4) {
        return new MaptexCameraUpdate(CameraUpdateFactory.newLatLngBounds((LatLngBounds)maptexLatLngBounds.mOriginal, (int)n2, (int)n3, (int)n4));
    }

    public static MaptexCameraUpdate newLatLngZoom(MaptexLatLng maptexLatLng, float f2) {
        return new MaptexCameraUpdate(CameraUpdateFactory.newLatLngZoom((LatLng)new LatLng(maptexLatLng.latitude, maptexLatLng.longitude), (float)f2));
    }

    public static MaptexCameraUpdate scrollBy(float f2, float f3) {
        return new MaptexCameraUpdate(CameraUpdateFactory.scrollBy((float)f2, (float)f3));
    }

    public static MaptexCameraUpdate zoomBy(float f2) {
        return new MaptexCameraUpdate(CameraUpdateFactory.zoomBy((float)f2));
    }

    public static MaptexCameraUpdate zoomBy(float f2, Point point) {
        return new MaptexCameraUpdate(CameraUpdateFactory.zoomBy((float)f2, (Point)point));
    }

    public static MaptexCameraUpdate zoomIn() {
        return new MaptexCameraUpdate(CameraUpdateFactory.zoomIn());
    }

    public static MaptexCameraUpdate zoomOut() {
        return new MaptexCameraUpdate(CameraUpdateFactory.zoomOut());
    }

    public static MaptexCameraUpdate zoomTo(float f2) {
        return new MaptexCameraUpdate(CameraUpdateFactory.zoomTo((float)f2));
    }
}

