/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.widget.FrameLayout;

public class RotationLayout
extends FrameLayout {
    private int mRotation;

    public RotationLayout(Context context) {
        super(context);
    }

    public RotationLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public RotationLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    protected void onMeasure(int n2, int n3) {
        int n4 = this.mRotation;
        if (n4 != 1 && n4 != 3) {
            super.onMeasure(n2, n3);
        } else {
            RotationLayout rotationLayout = this;
            super.onMeasure(n2, n3);
            rotationLayout.setMeasuredDimension(rotationLayout.getMeasuredHeight(), this.getMeasuredWidth());
        }
    }

    public void setViewRotation(int n2) {
        this.mRotation = (n2 + 360) % 360 / 90;
    }

    public void dispatchDraw(Canvas canvas) {
        int n2 = this.mRotation;
        if (n2 == 0) {
            super.dispatchDraw(canvas);
            return;
        }
        if (n2 == 1) {
            canvas.translate((float)this.getWidth(), 0.0f);
            canvas.rotate(90.0f, (float)(this.getWidth() / 2), 0.0f);
            canvas.translate((float)(this.getHeight() / 2), (float)(this.getWidth() / 2));
        } else if (n2 == 2) {
            RotationLayout rotationLayout = this;
            float f2 = rotationLayout.getWidth() / 2;
            float f3 = rotationLayout.getHeight() / 2;
            canvas.rotate(180.0f, f2, f3);
        } else {
            canvas.translate(0.0f, (float)this.getHeight());
            canvas.rotate(270.0f, (float)(this.getWidth() / 2), 0.0f);
            canvas.translate((float)(this.getHeight() / 2), (float)(-this.getWidth() / 2));
        }
        super.dispatchDraw(canvas);
    }
}

