/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import ir.map.sdk_map.R;
import ir.map.sdk_map.utils.BubbleDrawable;
import ir.map.sdk_map.utils.RotationLayout;

public class IconGenerator {
    public static final int STYLE_DEFAULT = 1;
    public static final int STYLE_WHITE = 2;
    public static final int STYLE_RED = 3;
    public static final int STYLE_BLUE = 4;
    public static final int STYLE_GREEN = 5;
    public static final int STYLE_PURPLE = 6;
    public static final int STYLE_ORANGE = 7;
    private final Context mContext;
    private ViewGroup mContainer;
    private RotationLayout mRotationLayout;
    private TextView mTextView;
    private View mContentView;
    private int mRotation;
    private float mAnchorU;
    private float mAnchorV;
    private BubbleDrawable mBackground;

    public IconGenerator(Context context) {
        IconGenerator iconGenerator = this;
        this.mAnchorU = 0.5f;
        this.mAnchorV = 1.0f;
        iconGenerator.mContext = context;
        iconGenerator.mBackground = new BubbleDrawable(this.mContext.getResources());
        iconGenerator.mContainer = (ViewGroup)LayoutInflater.from((Context)iconGenerator.mContext).inflate(R.layout.amu_text_bubble_sdk, null);
        iconGenerator.mRotationLayout = (RotationLayout)iconGenerator.mContainer.getChildAt(0);
        this.mTextView = (TextView)iconGenerator.mRotationLayout.findViewById(R.id.amu_text);
        iconGenerator.mContentView = this.mTextView;
        iconGenerator.setStyle(1);
    }

    private static int getStyleColor(int n2) {
        switch (n2) {
            default: {
                return -1;
            }
            case 7: {
                return -30720;
            }
            case 6: {
                return -6736948;
            }
            case 5: {
                return -10053376;
            }
            case 4: {
                return -16737844;
            }
            case 3: 
        }
        return -3407872;
    }

    private static int getTextStyle(int n2) {
        switch (n2) {
            default: {
                return R.style.amu_Bubble_TextAppearance_Dark;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
        }
        return R.style.amu_Bubble_TextAppearance_Light;
    }

    private float rotateAnchor(float f2, float f3) {
        switch (this.mRotation) {
            default: {
                throw new IllegalStateException();
            }
            case 3: {
                return f3;
            }
            case 2: {
                return 1.0f - f2;
            }
            case 1: {
                return 1.0f - f3;
            }
            case 0: 
        }
        return f2;
    }

    public Bitmap makeIcon(CharSequence charSequence) {
        TextView textView = this.mTextView;
        if (textView != null) {
            textView.setText(charSequence);
        }
        return this.makeIcon();
    }

    public Bitmap makeIcon() {
        Canvas canvas;
        int n2;
        IconGenerator iconGenerator = this;
        int n3 = n2 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        iconGenerator.mContainer.measure(n3, n3);
        n2 = iconGenerator.mContainer.getMeasuredWidth();
        int n4 = iconGenerator.mContainer.getMeasuredHeight();
        iconGenerator.mContainer.layout(0, 0, n2, n4);
        int n5 = iconGenerator.mRotation;
        if (n5 == 1 || n5 == 3) {
            IconGenerator iconGenerator2 = this;
            n4 = iconGenerator2.mContainer.getMeasuredWidth();
            n2 = iconGenerator2.mContainer.getMeasuredHeight();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.eraseColor(0);
        Canvas canvas2 = canvas;
        canvas = new Canvas(bitmap);
        switch (this.mRotation) {
            default: {
                break;
            }
            case 3: {
                Canvas canvas3 = canvas2;
                canvas3.translate(0.0f, (float)n4);
                canvas3.rotate(270.0f);
                break;
            }
            case 2: {
                float f2 = n2 / 2;
                float f3 = n4 / 2;
                canvas2.rotate(180.0f, f2, f3);
                break;
            }
            case 1: {
                Canvas canvas4 = canvas2;
                canvas4.translate((float)n2, 0.0f);
                canvas4.rotate(90.0f);
            }
            case 0: 
        }
        this.mContainer.draw(canvas2);
        return bitmap;
    }

    public void setContentView(View object) {
        IconGenerator iconGenerator = this;
        iconGenerator.mRotationLayout.removeAllViews();
        iconGenerator.mRotationLayout.addView((View)object);
        this.mContentView = object;
        object = this.mRotationLayout.findViewById(R.id.amu_text);
        object = object instanceof TextView ? (TextView)object : null;
        this.mTextView = object;
    }

    public void setContentRotation(int n2) {
        this.mRotationLayout.setViewRotation(n2);
    }

    public void setRotation(int n2) {
        this.mRotation = (n2 + 360) % 360 / 90;
    }

    public float getAnchorU() {
        IconGenerator iconGenerator = this;
        return iconGenerator.rotateAnchor(iconGenerator.mAnchorU, this.mAnchorV);
    }

    public float getAnchorV() {
        IconGenerator iconGenerator = this;
        return iconGenerator.rotateAnchor(iconGenerator.mAnchorV, this.mAnchorU);
    }

    public void setTextAppearance(Context context, int n2) {
        IconGenerator iconGenerator = iconGenerator.mTextView;
        if (iconGenerator != null) {
            iconGenerator.setTextAppearance(context, n2);
        }
    }

    public void setTextAppearance(int n2) {
        IconGenerator iconGenerator = this;
        iconGenerator.setTextAppearance(iconGenerator.mContext, n2);
    }

    public void setStyle(int n2) {
        IconGenerator iconGenerator = this;
        iconGenerator.setColor(IconGenerator.getStyleColor(n2));
        iconGenerator.setTextAppearance(iconGenerator.mContext, IconGenerator.getTextStyle(n2));
    }

    public void setColor(int n2) {
        IconGenerator iconGenerator = this;
        iconGenerator.mBackground.setColor(n2);
        iconGenerator.setBackground(iconGenerator.mBackground);
    }

    public void setBackground(Drawable drawable2) {
        iconGenerator2.mContainer.setBackgroundDrawable(drawable2);
        if (drawable2 != null) {
            Rect rect;
            IconGenerator iconGenerator = iconGenerator2;
            IconGenerator iconGenerator2 = rect;
            drawable2.getPadding(new Rect());
            iconGenerator.mContainer.setPadding(((Rect)iconGenerator2).left, ((Rect)iconGenerator2).top, ((Rect)iconGenerator2).right, ((Rect)iconGenerator2).bottom);
        } else {
            iconGenerator2.mContainer.setPadding(0, 0, 0, 0);
        }
    }

    public void setContentPadding(int n2, int n3, int n4, int n5) {
        this.mContentView.setPadding(n2, n3, n4, n5);
    }
}

