/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.utils;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.google.maps.android.R;

public class BubbleDrawable
extends Drawable {
    private final Drawable mShadow;
    private final Drawable mMask;
    private int mColor = -1;

    public BubbleDrawable(Resources resources) {
        this.mMask = resources.getDrawable(R.drawable.amu_bubble_mask);
        this.mShadow = resources.getDrawable(R.drawable.amu_bubble_shadow);
    }

    public void setColor(int n2) {
        this.mColor = n2;
    }

    public void draw(Canvas canvas) {
        BubbleDrawable bubbleDrawable = this;
        bubbleDrawable.mMask.draw(canvas);
        canvas.drawColor(bubbleDrawable.mColor, PorterDuff.Mode.SRC_IN);
        this.mShadow.draw(canvas);
    }

    public void setAlpha(int n2) {
        throw new UnsupportedOperationException();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        throw new UnsupportedOperationException();
    }

    public int getOpacity() {
        return -3;
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        BubbleDrawable bubbleDrawable = this;
        bubbleDrawable.mMask.setBounds(n2, n3, n4, n5);
        bubbleDrawable.mShadow.setBounds(n2, n3, n4, n5);
    }

    public void setBounds(Rect rect) {
        BubbleDrawable bubbleDrawable = this;
        bubbleDrawable.mMask.setBounds(rect);
        bubbleDrawable.mShadow.setBounds(rect);
    }

    public boolean getPadding(Rect rect) {
        return this.mMask.getPadding(rect);
    }
}

