/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_map.a;
import java.util.List;

public class MaptexSphericalUtil {
    private MaptexSphericalUtil() {
    }

    public static double computeHeading(MaptexLatLng maptexLatLng, MaptexLatLng maptexLatLng2) {
        MaptexLatLng maptexLatLng3 = maptexLatLng2;
        MaptexLatLng maptexLatLng4 = maptexLatLng;
        double d2 = Math.toRadians(maptexLatLng4.latitude);
        double d3 = Math.toRadians(maptexLatLng4.longitude);
        double d4 = Math.toRadians(maptexLatLng3.latitude);
        d3 = Math.toRadians(maptexLatLng3.longitude) - d3;
        return a.c(Math.toDegrees(Math.atan2(Math.sin(d3) * Math.cos(d4), Math.cos(d2) * Math.sin(d4) - Math.sin(d2) * Math.cos(d4) * Math.cos(d3))), -180.0, 180.0);
    }

    public static MaptexLatLng computeOffset(MaptexLatLng maptexLatLng, double d2, double d3) {
        double d4 = d2 / 6371009.0;
        MaptexLatLng maptexLatLng2 = maptexLatLng;
        double d5 = Math.toRadians(d3);
        double d6 = Math.toRadians(maptexLatLng2.latitude);
        double d7 = Math.toRadians(maptexLatLng2.longitude);
        double d8 = Math.cos(d4);
        double d9 = d6;
        d6 = Math.sin(d9);
        double d10 = d8 * d6;
        double d11 = Math.sin(d4) * Math.cos(d9);
        double d12 = d5;
        d5 = d10 + d11 * Math.cos(d5);
        d6 = Math.atan2(d11 * Math.sin(d12), d8 - d6 * d5);
        return new MaptexLatLng(Math.toDegrees(Math.asin(d5)), Math.toDegrees(d7 + d6));
    }

    public static MaptexLatLng computeOffsetOrigin(MaptexLatLng maptexLatLng, double d2, double d3) {
        double d4;
        double d5 = d2;
        d2 = Math.toRadians(d3);
        d3 = d5 / 6371009.0;
        double d6 = Math.cos(d3);
        double d7 = Math.sin(d3) * Math.cos(d2);
        double d8 = d6;
        d2 = Math.sin(d3) * Math.sin(d2);
        d3 = Math.sin(Math.toRadians(maptexLatLng.latitude));
        double d9 = d8 * d8;
        double d10 = d7 * d7;
        double d11 = d9;
        double d12 = d10 * d9 + d11 * d11 - d9 * d3 * d3;
        if (d4 < 0.0) {
            return null;
        }
        double d13 = d3;
        double d14 = d7;
        d3 = d14 * d3;
        d9 += d10;
        d10 = (d3 + Math.sqrt(d12)) / d9;
        double d15 = (d13 - d14 * d10) / d6;
        if ((d10 = Math.atan2(d15, d10)) < -1.5707963267948966 || d10 > 1.5707963267948966) {
            d10 = Math.atan2(d15, (d3 - Math.sqrt(d12)) / d9);
        }
        if (d10 >= -1.5707963267948966 && d10 <= 1.5707963267948966) {
            double d16 = Math.toRadians(maptexLatLng.longitude) - Math.atan2(d2, d6 * Math.cos(d10) - d7 * Math.sin(d10));
            return new MaptexLatLng(Math.toDegrees(d10), Math.toDegrees(d16));
        }
        return null;
    }

    public static MaptexLatLng interpolate(MaptexLatLng maptexLatLng, MaptexLatLng maptexLatLng2, double d2) {
        double d3;
        MaptexLatLng maptexLatLng3 = maptexLatLng2;
        MaptexLatLng maptexLatLng4 = maptexLatLng;
        double d4 = Math.toRadians(maptexLatLng4.latitude);
        double d5 = Math.toRadians(maptexLatLng4.longitude);
        double d6 = Math.toRadians(maptexLatLng3.latitude);
        double d7 = Math.toRadians(maptexLatLng2.longitude);
        double d8 = Math.cos(d4);
        double d9 = Math.cos(d6);
        double d10 = MaptexSphericalUtil.computeAngleBetween(maptexLatLng, maptexLatLng3);
        double d11 = Math.sin(d10);
        if (d3 < 1.0E-6) {
            return maptexLatLng;
        }
        double d12 = Math.sin((1.0 - d2) * d10) / d11;
        d2 = Math.sin(d2 * d10) / d11;
        double d13 = d12 * d8;
        d8 = d13;
        double d14 = d5;
        double d15 = d8 * Math.cos(d5);
        d5 = d2 * d9;
        d8 = d15 + d5 * Math.cos(d7);
        d5 = d13 * Math.sin(d14) + d5 * Math.sin(d7);
        double d16 = d8;
        double d17 = d5;
        d12 = Math.atan2(d12 * Math.sin(d4) + d2 * Math.sin(d6), Math.sqrt(d16 * d16 + d17 * d17));
        d2 = Math.atan2(d5, d8);
        return new MaptexLatLng(Math.toDegrees(d12), Math.toDegrees(d2));
    }

    private static double distanceRadians(double d2, double d3, double d4, double d5) {
        return a.a(a.b(d2, d4, d3 - d5));
    }

    static double computeAngleBetween(MaptexLatLng maptexLatLng, MaptexLatLng maptexLatLng2) {
        return MaptexSphericalUtil.distanceRadians(Math.toRadians(maptexLatLng.latitude), Math.toRadians(maptexLatLng.longitude), Math.toRadians(maptexLatLng2.latitude), Math.toRadians(maptexLatLng2.longitude));
    }

    public static double computeDistanceBetween(MaptexLatLng maptexLatLng, MaptexLatLng maptexLatLng2) {
        return MaptexSphericalUtil.computeAngleBetween(maptexLatLng, maptexLatLng2) * 6371009.0;
    }

    public static double computeLength(List<MaptexLatLng> object) {
        if (object.size() < 2) {
            return 0.0;
        }
        List<MaptexLatLng> list = object;
        double d2 = 0.0;
        MaptexLatLng maptexLatLng = list.get(0);
        double d3 = Math.toRadians(maptexLatLng.latitude);
        double d4 = Math.toRadians(maptexLatLng.longitude);
        object = list.iterator();
        while (object.hasNext()) {
            double d5 = d3;
            double d6 = d4;
            MaptexLatLng maptexLatLng2 = (MaptexLatLng)object.next();
            d3 = Math.toRadians(maptexLatLng2.latitude);
            d4 = Math.toRadians(maptexLatLng2.longitude);
            d2 += MaptexSphericalUtil.distanceRadians(d5, d6, d3, d4);
        }
        return d2 * 6371009.0;
    }

    public static double computeArea(List<MaptexLatLng> list) {
        return Math.abs(MaptexSphericalUtil.computeSignedArea(list));
    }

    public static double computeSignedArea(List<MaptexLatLng> list) {
        return MaptexSphericalUtil.computeSignedArea(list, 6371009.0);
    }

    static double computeSignedArea(List<MaptexLatLng> object, double d2) {
        int n2 = object.size();
        if (n2 < 3) {
            return 0.0;
        }
        List<MaptexLatLng> list = object;
        double d3 = 0.0;
        MaptexLatLng maptexLatLng = list.get(n2 - 1);
        double d4 = Math.toRadians(maptexLatLng.latitude);
        d4 = Math.tan((1.5707963267948966 - d4) / 2.0);
        double d5 = Math.toRadians(maptexLatLng.longitude);
        object = list.iterator();
        while (object.hasNext()) {
            double d6 = d3;
            MaptexLatLng maptexLatLng2 = (MaptexLatLng)object.next();
            double d7 = Math.toRadians(maptexLatLng2.latitude);
            d7 = Math.tan((1.5707963267948966 - d7) / 2.0);
            d3 = Math.toRadians(maptexLatLng2.longitude);
            double d8 = d4 = d6 + MaptexSphericalUtil.polarTriangleArea(d7, d3, d4, d5);
            d5 = d3;
            d4 = d7;
            d3 = d8;
        }
        return d3 * d2 * d2;
    }

    private static double polarTriangleArea(double d2, double d3, double d4, double d5) {
        double d6 = d2;
        d2 = d3 - d5;
        d3 = d6 * d4;
        return Math.atan2(d3 * Math.sin(d2), d3 * Math.cos(d2) + 1.0) * 2.0;
    }
}

