/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_map.MaptexSphericalUtil;
import ir.map.sdk_map.a;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class MaptexPolyUtil {
    private static final double DEFAULT_TOLERANCE = 0.1;

    private MaptexPolyUtil() {
    }

    private static double tanLatGC(double d2, double d3, double d4, double d5) {
        return (Math.tan(d2) * Math.sin(d4 - d5) + Math.tan(d3) * Math.sin(d5)) / Math.sin(d4);
    }

    private static double mercatorLatRhumb(double d2, double d3, double d4, double d5) {
        return (a.e(d2) * (d4 - d5) + a.e(d3) * d5) / d4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean intersects(double d2, double d3, double d4, double d5, double d6, boolean bl) {
        if (!(d6 < 0.0)) {
            if (!(d6 < d4)) return false;
        }
        if (!(d6 >= 0.0)) {
            if (!(d6 >= d4)) return false;
        }
        if (d5 <= -1.5707963267948966) {
            return false;
        }
        if (!(d2 > -1.5707963267948966)) return false;
        if (!(d3 > -1.5707963267948966)) return false;
        if (!(d2 < 1.5707963267948966)) return false;
        if (!(d3 < 1.5707963267948966)) return false;
        if (d4 <= -Math.PI) {
            return false;
        }
        double d7 = d2;
        double d8 = (d7 * (d4 - d6) + d3 * d6) / d4;
        if (d7 >= 0.0 && d3 >= 0.0 && d5 < d8) {
            return false;
        }
        if (d2 <= 0.0 && d3 <= 0.0 && d5 >= d8 || d5 >= 1.5707963267948966) {
            return true;
        }
        if (bl) {
            if (!(Math.tan(d5) >= MaptexPolyUtil.tanLatGC(d2, d3, d4, d6))) return false;
            return true;
        }
        if (!(a.e(d5) >= MaptexPolyUtil.mercatorLatRhumb(d2, d3, d4, d6))) return false;
        return true;
    }

    public static boolean isLocationOnEdge(MaptexLatLng maptexLatLng, List<MaptexLatLng> list, boolean bl, double d2) {
        return MaptexPolyUtil.isLocationOnEdgeOrPath(maptexLatLng, list, true, bl, d2);
    }

    public static boolean isLocationOnEdge(MaptexLatLng maptexLatLng, List<MaptexLatLng> list, boolean bl) {
        return MaptexPolyUtil.isLocationOnEdge(maptexLatLng, list, bl, 0.1);
    }

    public static boolean isLocationOnPath(MaptexLatLng maptexLatLng, List<MaptexLatLng> list, boolean bl, double d2) {
        return MaptexPolyUtil.isLocationOnEdgeOrPath(maptexLatLng, list, false, bl, d2);
    }

    public static boolean isLocationOnPath(MaptexLatLng maptexLatLng, List<MaptexLatLng> list, boolean bl) {
        return MaptexPolyUtil.isLocationOnPath(maptexLatLng, list, bl, 0.1);
    }

    private static boolean isLocationOnEdgeOrPath(MaptexLatLng maptexLatLng, List<MaptexLatLng> maptexLatLng22, boolean bl, boolean bl2, double d2) {
        int n2 = maptexLatLng22.size();
        if (n2 == 0) {
            return false;
        }
        MaptexLatLng maptexLatLng3 = maptexLatLng;
        double d3 = a.b(d2 /= 6371009.0);
        double d4 = Math.toRadians(maptexLatLng3.latitude);
        double d5 = Math.toRadians(maptexLatLng3.longitude);
        int n3 = bl ? n2 - 1 : 0;
        MaptexLatLng maptexLatLng4 = maptexLatLng22.get(n3);
        double d6 = Math.toRadians(maptexLatLng4.latitude);
        double d7 = Math.toRadians(maptexLatLng4.longitude);
        if (bl2) {
            for (MaptexLatLng maptexLatLng22 : maptexLatLng22) {
                if (!MaptexPolyUtil.isOnSegmentGC(d6, d7, d6 = Math.toRadians(maptexLatLng22.latitude), d7 = Math.toRadians(maptexLatLng22.longitude), d4, d5, d3)) continue;
                return true;
            }
        } else {
            double d8 = d4 - d2;
            d2 = a.e(d6);
            double d9 = a.e(d4);
            double[] dArray = new double[3];
            for (MaptexLatLng maptexLatLng5 : maptexLatLng22) {
                double d10;
                double d11 = Math.toRadians(maptexLatLng5.latitude);
                double d12 = a.e(d11);
                double d13 = Math.toRadians(maptexLatLng5.longitude);
                if (Math.max(d6, d10) >= d8 && Math.min(d6, d11) <= d11) {
                    d6 = a.c(d13 - d7, -Math.PI, Math.PI);
                    double d14 = a.c(d5 - d7, -Math.PI, Math.PI);
                    dArray[0] = d7 = d14;
                    dArray[1] = d7 += Math.PI * 2;
                    dArray[2] = d7 = d14 - Math.PI * 2;
                    int n4 = dArray.length;
                    for (int i2 = 0; i2 < n4; ++i2) {
                        double d15;
                        double d16;
                        double d17 = d6;
                        double d18 = dArray[i2];
                        double d19 = d16 = d12 - d2;
                        double d20 = d17 * d17 + d19 * d19;
                        d20 = d15 <= 0.0 ? 0.0 : a.a((d18 * d6 + (d9 - d2) * d16) / d20, 0.0, 1.0);
                        double d21 = d16;
                        d16 = d20 * d6;
                        if (!(a.b(d4, a.d(d2 + d20 * d21), d18 - d16) < d3)) continue;
                        return true;
                    }
                }
                d2 = d12;
                d7 = d13;
                d6 = d11;
            }
        }
        return false;
    }

    private static double sinDeltaBearing(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9 = d5;
        double d10 = d3;
        double d11 = d4;
        double d12 = d2;
        double d13 = d3;
        double d14 = d2;
        d2 = Math.sin(d2);
        d3 = Math.cos(d4);
        d4 = Math.cos(d6);
        d5 = d6 - d14;
        d6 = d7 - d13;
        d7 = d11 - d12;
        double d15 = d9 - d10;
        double d16 = Math.sin(d6) * d4;
        double d17 = d5;
        d5 = Math.sin(d15) * d3;
        d4 = Math.sin(d17) + (d2 *= 2.0) * d4 * a.b(d6);
        d2 = Math.sin(d7) + d2 * d3 * a.b(d15);
        double d18 = d4;
        double d19 = d5;
        double d20 = d2;
        d3 = (d16 * d16 + d18 * d18) * (d19 * d19 + d20 * d20);
        return d8 <= 0.0 ? 1.0 : (d16 * d2 - d4 * d5) / Math.sqrt(d3);
    }

    private static boolean isOnSegmentGC(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10;
        double d11;
        double d12;
        double d13 = a.b(d2, d6, d3 - d7);
        if (d12 <= d8) {
            return true;
        }
        double d14 = a.b(d4, d6, d5 - d7);
        if (d11 <= d8) {
            return true;
        }
        d6 = MaptexPolyUtil.sinDeltaBearing(d2, d3, d4, d5, d6, d7);
        d6 = a.c(a.f(d13) * d6);
        if (d10 > d8) {
            return false;
        }
        d2 = a.b(d2, d4, d3 - d5);
        d3 = d2 * 2.0;
        d3 = d2 + d6 * (1.0 - d3);
        if (d13 <= d9 && d14 <= d3) {
            if (d2 < 0.74) {
                return true;
            }
            double d15 = d6;
            d2 = d15 * 2.0;
            return a.b((d13 - d15) / (d2 = 1.0 - d2), (d14 - d6) / d2) > 0.0;
        }
        return false;
    }

    public static List<MaptexLatLng> simplify(List<MaptexLatLng> list, double d2) {
        int n2 = list.size();
        if (n2 >= 1) {
            if (!(d2 <= 0.0)) {
                ArrayList<MaptexLatLng> arrayList;
                Stack<int[]> stack;
                boolean bl = MaptexPolyUtil.isClosedPolygon(list);
                MaptexLatLng maptexLatLng = null;
                if (bl) {
                    List<MaptexLatLng> list2 = list;
                    maptexLatLng = list2.get(list2.size() - 1);
                    list2.remove(list2.size() - 1);
                    list2.add(new MaptexLatLng(maptexLatLng.latitude + 1.0E-11, maptexLatLng.longitude + 1.0E-11));
                }
                int n3 = n2--;
                int n4 = 0;
                Stack<int[]> stack2 = stack;
                stack = new Stack<int[]>();
                double[] dArray = new double[n3];
                double[] dArray2 = dArray;
                dArray2[0] = 1.0;
                dArray[n2] = 1.0;
                if (n3 > 2) {
                    stack2.push(new int[]{0, n2});
                    while (stack2.size() > 0) {
                        int[] nArray = (int[])stack2.pop();
                        double d3 = 0.0;
                        for (int i2 = nArray[0] + 1; i2 < nArray[1]; ++i2) {
                            double d4;
                            double d5 = MaptexPolyUtil.distanceToLine(list.get(i2), list.get(nArray[0]), list.get(nArray[1]));
                            if (d4 > d3) {
                                n4 = i2;
                            } else {
                                d5 = d3;
                            }
                            d3 = d5;
                        }
                        if (!(d3 > d2)) continue;
                        Stack<int[]> stack3 = stack2;
                        dArray2[n4] = d3;
                        stack3.push(new int[]{nArray[0], n4});
                        stack3.push(new int[]{n4, nArray[1]});
                    }
                }
                if (bl) {
                    List<MaptexLatLng> list3 = list;
                    list3.remove(list3.size() - 1);
                    list.add(maptexLatLng);
                }
                int n5 = 0;
                ArrayList<MaptexLatLng> arrayList2 = arrayList;
                arrayList = new ArrayList<MaptexLatLng>();
                for (MaptexLatLng maptexLatLng2 : list) {
                    if (dArray2[n5] != 0.0) {
                        arrayList2.add(maptexLatLng2);
                    }
                    ++n5;
                }
                return arrayList2;
            }
            throw new IllegalArgumentException("Tolerance must be greater than zero");
        }
        throw new IllegalArgumentException("Polyline must have at least 1 point");
    }

    public static boolean isClosedPolygon(List<MaptexLatLng> list) {
        List<MaptexLatLng> list2 = list;
        return list.get(0).equals(list2.get(list2.size() - 1));
    }

    public static double distanceToLine(MaptexLatLng maptexLatLng, MaptexLatLng maptexLatLng2, MaptexLatLng maptexLatLng3) {
        double d2;
        if (maptexLatLng2.equals(maptexLatLng3)) {
            return MaptexSphericalUtil.computeDistanceBetween(maptexLatLng3, maptexLatLng);
        }
        double d3 = Math.toRadians(maptexLatLng.longitude);
        double d4 = Math.toRadians(maptexLatLng2.latitude);
        double d5 = d4;
        MaptexLatLng maptexLatLng4 = maptexLatLng3;
        double d6 = Math.toRadians(maptexLatLng2.longitude);
        double d7 = Math.toRadians(maptexLatLng4.latitude);
        d5 = d7 - d5;
        d7 = Math.toRadians(maptexLatLng4.longitude) - d6;
        double d8 = d5;
        double d9 = d7;
        d3 = ((Math.toRadians(maptexLatLng.latitude) - d4) * d5 + (d3 - d6) * d7) / (d8 * d8 + d9 * d9);
        if (d2 <= 0.0) {
            return MaptexSphericalUtil.computeDistanceBetween(maptexLatLng, maptexLatLng2);
        }
        if (d3 >= 1.0) {
            return MaptexSphericalUtil.computeDistanceBetween(maptexLatLng, maptexLatLng3);
        }
        return MaptexSphericalUtil.computeDistanceBetween(new MaptexLatLng(maptexLatLng.latitude - maptexLatLng2.latitude, maptexLatLng.longitude - maptexLatLng2.longitude), new MaptexLatLng(d3 * (maptexLatLng3.latitude - maptexLatLng2.latitude), d3 * (maptexLatLng3.longitude - maptexLatLng2.longitude)));
    }

    public static List<MaptexLatLng> decode(String string) {
        ArrayList<MaptexLatLng> arrayList;
        int n2 = string.length();
        ArrayList<MaptexLatLng> arrayList2 = arrayList;
        arrayList = new ArrayList<MaptexLatLng>();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < n2) {
            int n6;
            int n7;
            int n8 = 1;
            int n9 = 0;
            do {
                n7 = string.charAt(n3++) - 63 - 1;
                n8 += n7 << n9;
                n9 += 5;
            } while (n7 >= 31);
            n8 = (n8 & 1) != 0 ? ~(n8 >> 1) : (n8 >>= 1);
            int n10 = n4 + n8;
            n4 = 1;
            n8 = 0;
            do {
                n6 = string.charAt(n3++) - 63 - 1;
                n4 += n6 << n8;
                n8 += 5;
            } while (n6 >= 31);
            n4 = (n4 & 1) != 0 ? ~(n4 >> 1) : (n4 >>= 1);
            arrayList2.add(new MaptexLatLng((double)n10 * 1.0E-5, (double)(n5 += n4) * 1.0E-5));
            n4 = n10;
        }
        return arrayList2;
    }

    public static String encode(List<MaptexLatLng> object) {
        StringBuffer stringBuffer;
        List<MaptexLatLng> list = object;
        long l2 = 0L;
        long l3 = 0L;
        object = stringBuffer;
        stringBuffer = new StringBuffer();
        for (MaptexLatLng maptexLatLng : list) {
            long l4 = Math.round(maptexLatLng.latitude * 100000.0);
            long l5 = Math.round(maptexLatLng.longitude * 100000.0);
            l2 = l4 - l2;
            MaptexPolyUtil.encode(l2, (StringBuffer)object);
            MaptexPolyUtil.encode(l5 - l3, (StringBuffer)object);
            l3 = l5;
            l2 = l4;
        }
        return ((StringBuffer)object).toString();
    }

    private static void encode(long l2, StringBuffer stringBuffer) {
        l2 = l2 < 0L ? l2 << 1 ^ 0xFFFFFFFFFFFFFFFFL : (l2 <<= 1);
        while (l2 >= 32L) {
            stringBuffer.append(Character.toChars((int)((l2 & 0x1FL | 0x20L) + 63L)));
            l2 >>= 5;
        }
        stringBuffer.append(Character.toChars((int)(l2 + 63L)));
    }
}

