package ir.map.sdk_map.wrapper;

import android.os.Parcel;
import android.os.Parcelable;


public final class MaptexTileOverlayOptions implements Parcelable {

    public static final Creator<MaptexTileOverlayOptions> CREATOR = new Creator<MaptexTileOverlayOptions>() {
        public MaptexTileOverlayOptions createFromParcel(Parcel in) {
            return new MaptexTileOverlayOptions((com.google.android.gms.maps.model.TileOverlayOptions) in.readParcelable(null));
        }

        public MaptexTileOverlayOptions[] newArray(int size) {
            return new MaptexTileOverlayOptions[size];
        }
    };

    /**
     * DO NOT USE (for internal use only). The original MaptexTileOverlayOptions.
     *

     */
    public final com.google.android.gms.maps.model.TileOverlayOptions mOriginal;

    private BaseMaptexUrlTileProvider mMaptexTileProvider;
    private MaptexTileOverlayOptions mDefaultOptions;

    public MaptexTileOverlayOptions() {
        this(new com.google.android.gms.maps.model.TileOverlayOptions());
    }

    MaptexTileOverlayOptions(com.google.android.gms.maps.model.TileOverlayOptions original) {
        mOriginal = original;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(mOriginal, flags);
    }

    public BaseMaptexUrlTileProvider getTileProvider() {
        return mMaptexTileProvider;
    }

    public float getZIndex() {
        return mOriginal.getZIndex();
    }

    public boolean isVisible() {
        return mOriginal.isVisible();
    }

    /**
     * Reset the MaptexTileOverlayOptions by setting all of its properties to their default values.
     */
    @Maptex
    public void reset() {
        if (mDefaultOptions == null) {
            mDefaultOptions = new MaptexTileOverlayOptions();
        }
        tileProvider(mDefaultOptions.getTileProvider());
        visible(mDefaultOptions.isVisible());
        zIndex(mDefaultOptions.getZIndex());
    }

    public MaptexTileOverlayOptions tileProvider(BaseMaptexUrlTileProvider maptexTileProvider) {
        mMaptexTileProvider = maptexTileProvider;

        final BaseMaptexUrlTileProvider fMaptexTileProvider = maptexTileProvider;
        mOriginal.tileProvider(fMaptexTileProvider == null ? null : new com.google.android.gms.maps.model.TileProvider() {
            @Override
            public com.google.android.gms.maps.model.Tile getTile(int x, int y, int zoom) {
                return fMaptexTileProvider.getTile(x, y, zoom).mOriginal;
            }
        });

        return this;
    }

    public MaptexTileOverlayOptions visible(boolean visible) {
        mOriginal.visible(visible);
        return this;
    }

    public MaptexTileOverlayOptions zIndex(float zIndex) {
        mOriginal.zIndex(zIndex);
        return this;
    }

    public MaptexTileOverlayOptions fadeIn(boolean b) {
        mOriginal.fadeIn(b);
        return this;
    }
}
