package ir.map.sdk_map.wrapper;


public final class MaptexTileOverlay {

    final com.google.android.gms.maps.model.TileOverlay mOriginal;

    private MaptexTileOverlay(com.google.android.gms.maps.model.TileOverlay original) {
        mOriginal = original;
    }

    /**
     * Obtain a new MaptexTileOverlay based an original one.
     *
     * @param original
     * @return

     */
    public static MaptexTileOverlay obtain(com.google.android.gms.maps.model.TileOverlay original) {
        return new MaptexTileOverlay(original);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MaptexTileOverlay)) {
            return false;
        }
        return mOriginal.equals(((MaptexTileOverlay) other).mOriginal);
    }

    @Override
    public int hashCode() {
        return mOriginal.hashCode();
    }

    public void clearTileCache() {
        mOriginal.clearTileCache();
    }

    public String getId() {
        return mOriginal.getId();
    }

    public float getZIndex() {
        return mOriginal.getZIndex();
    }

    public void setZIndex(float zIndex) {
        mOriginal.setZIndex(zIndex);
    }

    public boolean isVisible() {
        return mOriginal.isVisible();
    }

    public void setVisible(boolean visible) {
        mOriginal.setVisible(visible);
    }

    public void remove() {
        mOriginal.remove();
    }

}
