package ir.map.sdk_map.wrapper;

import com.google.android.gms.maps.model.LatLng;

import ir.map.sdk_common.MaptexLatLng;

public final class MaptexMarker {

    final com.google.android.gms.maps.model.Marker mOriginal;

    private MaptexMarker(com.google.android.gms.maps.model.Marker original) {
        mOriginal = original;
    }

    /**
     * <strong>DO NOT USE.</strong>

     * Obtain a new MaptexMarker based an original one.
     *
     * @param original
     * @return

     */
    public static MaptexMarker obtain(com.google.android.gms.maps.model.Marker original) {
        return new MaptexMarker(original);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MaptexMarker)) {
            return false;
        }

        return mOriginal.equals(((MaptexMarker) other).mOriginal);
    }

    @Override
    public int hashCode() {
        return mOriginal.hashCode();
    }

    public String getId() {
        return mOriginal.getId();
    }

    public MaptexLatLng getPosition() {
        final com.google.android.gms.maps.model.LatLng original = mOriginal.getPosition();
        return original == null ? null : new MaptexLatLng(original.latitude, original.longitude);
    }

    public void setPosition(MaptexLatLng latLng) {
        mOriginal.setPosition(new LatLng(latLng.latitude, latLng.longitude));
    }

    public String getSnippet() {
        return mOriginal.getSnippet();
    }

    public void setSnippet(String snippet) {
        mOriginal.setSnippet(snippet);
    }

    public String getTitle() {
        return mOriginal.getTitle();
    }

    public void setTitle(String title) {
        mOriginal.setTitle(title);
    }

    public void hideInfoWindow() {
        mOriginal.hideInfoWindow();
    }

    public boolean isDraggable() {
        return mOriginal.isDraggable();
    }

    public void setDraggable(boolean draggable) {
        mOriginal.setDraggable(draggable);
    }

    public boolean isInfoWindowShown() {
        return mOriginal.isInfoWindowShown();
    }

    public boolean isVisible() {
        return mOriginal.isVisible();
    }

    public void setVisible(boolean visible) {
        mOriginal.setVisible(visible);
    }

    public void remove() {
        mOriginal.remove();
    }

    public void showInfoWindow() {
        mOriginal.showInfoWindow();
    }

    public void setZIndex(float index) {
        mOriginal.setZIndex(index);
    }

    public Object getTag() {
        return mOriginal.getTag();
    }

    public void setTag(Object tag) {
        mOriginal.setTag(tag);
    }

    public void setAlpha(float v) {
        mOriginal.setAlpha(v);
    }
}
