package ir.map.sdk_map.wrapper;

import com.google.android.gms.maps.model.LatLng;

import ir.map.sdk_common.MaptexLatLng;


public final class MaptexGroundOverlay {

    final com.google.android.gms.maps.model.GroundOverlay mOriginal;

    private MaptexGroundOverlay(com.google.android.gms.maps.model.GroundOverlay original) {
        mOriginal = original;
    }

    /**
     * <strong>DO NOT USE.</strong>

     * Obtain a new MaptexGroundOverlay based an original one.
     *
     * @param original
     * @return

     */
    public static MaptexGroundOverlay obtain(com.google.android.gms.maps.model.GroundOverlay original) {
        return new MaptexGroundOverlay(original);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MaptexGroundOverlay)) {
            return false;
        }
        return mOriginal.equals(((MaptexGroundOverlay) other).mOriginal);
    }

    @Override
    public int hashCode() {
        return mOriginal.hashCode();
    }

    public float getBearing() {
        return mOriginal.getBearing();
    }

    public void setBearing(float bearing) {
        mOriginal.setBearing(bearing);
    }

    public MaptexLatLngBounds getBounds() {
        final com.google.android.gms.maps.model.LatLngBounds original = mOriginal.getBounds();
        return original == null ? null : MaptexLatLngBounds.obtain(original);
    }

    public float getHeight() {
        return mOriginal.getHeight();
    }

    public String getId() {
        return mOriginal.getId();
    }

    public MaptexLatLng getPosition() {
        final com.google.android.gms.maps.model.LatLng original = mOriginal.getPosition();
        return original == null ? null : new MaptexLatLng(original.latitude, original.longitude);
    }

    public void setPosition(MaptexLatLng position) {
        mOriginal.setPosition(position == null ? null : new LatLng(position.latitude, position.longitude));
    }

    public float getTransparency() {
        return mOriginal.getTransparency();
    }

    public void setTransparency(float transparency) {
        mOriginal.setTransparency(transparency);
    }

    public float getWidth() {
        return mOriginal.getWidth();
    }

    public float getZIndex() {
        return mOriginal.getZIndex();
    }

    public void setZIndex(float zIndex) {
        mOriginal.setZIndex(zIndex);
    }

    public boolean isVisible() {
        return mOriginal.isVisible();
    }

    public void setVisible(boolean visible) {
        mOriginal.setVisible(visible);
    }

    public void remove() {
        mOriginal.remove();
    }

    public void setDimensions(float width) {
        mOriginal.setDimensions(width);
    }

    public void setDimensions(float width, float height) {
        mOriginal.setDimensions(width, height);
    }

    public void setPositionFromBounds(MaptexLatLngBounds bounds) {
        mOriginal.setPositionFromBounds(bounds == null ? null : bounds.mOriginal);
    }

}
