package ir.map.sdk_map.wrapper;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;

import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_map.MapSDK;


public final class MaptexCameraPosition implements Parcelable {

    public static final Creator<MaptexCameraPosition> CREATOR = new Creator<MaptexCameraPosition>() {
        public MaptexCameraPosition createFromParcel(Parcel in) {
            return new MaptexCameraPosition((com.google.android.gms.maps.model.CameraPosition) in.readParcelable(null));
        }

        public MaptexCameraPosition[] newArray(int size) {
            return new MaptexCameraPosition[size];
        }
    };

    /**
     * <strong>DO NOT USE.</strong>

     * The original (immutable) MaptexCameraPosition.
     *

     */
    public final com.google.android.gms.maps.model.CameraPosition mOriginal;

    public final float bearing;
    public final MaptexLatLng target;
    public final float tilt;
    public final float zoom;

    private MaptexCameraPosition(com.google.android.gms.maps.model.CameraPosition original) {
        mOriginal = original;

        this.bearing = original.bearing;
        this.target = new MaptexLatLng(original.target.latitude, original.target.longitude);
        this.tilt = original.tilt;
        this.zoom = original.zoom;
    }

    public MaptexCameraPosition(MaptexLatLng position, int zoom, float tilt, float bearing) {
        mOriginal = new CameraPosition(new LatLng(position.latitude, position.longitude), zoom, tilt, bearing);

        this.bearing = bearing;
        this.target = new MaptexLatLng(position.latitude, position.longitude);
        this.tilt = tilt;
        this.zoom = zoom;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MaptexCameraPosition maptexCameraPosition) {
        return new Builder(maptexCameraPosition);
    }

    public static MaptexCameraPosition createFromAttributes(AttributeSet attrs) {
        return new MaptexCameraPosition(com.google.android.gms.maps.model.CameraPosition.createFromAttributes(MapSDK.getContext(), attrs));
    }

    public static MaptexCameraPosition fromLatLngZoom(MaptexLatLng target, float zoom) {
        return new MaptexCameraPosition(com.google.android.gms.maps.model.CameraPosition.fromLatLngZoom(target == null ? null : new LatLng(target.latitude, target.longitude),
                zoom));
    }

    /**
     * <strong>DO NOT USE.</strong>

     * Obtain a new MaptexCameraPosition based on an original one.
     *
     * @param original The original MaptexCameraPosition instance.
     * @return A MaptexCameraPosition wrapper instance

     */
    public static MaptexCameraPosition obtain(com.google.android.gms.maps.model.CameraPosition original) {
        return new MaptexCameraPosition(original);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MaptexCameraPosition)) {
            return false;
        }
        return mOriginal.equals(((MaptexCameraPosition) other).mOriginal);
    }

    @Override
    public int hashCode() {
        return mOriginal.hashCode();
    }

    @Override
    public String toString() {
        return mOriginal.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(mOriginal, flags);
    }

    public final static class Builder {

        private com.google.android.gms.maps.model.CameraPosition.Builder mOriginal;

        public Builder() {
            this(new com.google.android.gms.maps.model.CameraPosition.Builder());
        }

        public Builder(MaptexCameraPosition previous) {
            this(new com.google.android.gms.maps.model.CameraPosition.Builder(previous == null ? null : previous.mOriginal));
        }

        private Builder(com.google.android.gms.maps.model.CameraPosition.Builder original) {
            mOriginal = original;
        }

        public Builder bearing(float bearing) {
            mOriginal.bearing(bearing);
            return this;
        }

        public MaptexCameraPosition build() {
            return new MaptexCameraPosition(mOriginal.build());
        }

        public Builder target(MaptexLatLng location) {
            mOriginal.target(location == null ? null : new LatLng(location.latitude, location.longitude));
            return this;
        }

        public Builder tilt(float tilt) {
            mOriginal.tilt(tilt);
            return this;
        }

        public Builder zoom(float zoom) {
            mOriginal.zoom(zoom);
            return this;
        }
    }

}
