package ir.map.sdk_map.wrapper;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.android.gms.maps.model.LatLng;

import ir.map.sdk_common.MaptexLatLng;


public final class MaptexGroundOverlayOptions implements Parcelable {

    public static final Creator<MaptexGroundOverlayOptions> CREATOR = new Creator<MaptexGroundOverlayOptions>() {
        public MaptexGroundOverlayOptions createFromParcel(Parcel in) {
            return new MaptexGroundOverlayOptions((com.google.android.gms.maps.model.GroundOverlayOptions) in.readParcelable(null));
        }

        public MaptexGroundOverlayOptions[] newArray(int size) {
            return new MaptexGroundOverlayOptions[size];
        }
    };

    public static final float NO_DIMENSION = com.google.android.gms.maps.model.GroundOverlayOptions.NO_DIMENSION;

    /**
     * <strong>DO NOT USE.</strong>

     * The original MaptexGroundOverlayOptions.
     *

     */
    public final com.google.android.gms.maps.model.GroundOverlayOptions mOriginal;

    private MaptexGroundOverlayOptions mDefaultOptions;

    public MaptexGroundOverlayOptions() {
        this(new com.google.android.gms.maps.model.GroundOverlayOptions());
    }

    MaptexGroundOverlayOptions(com.google.android.gms.maps.model.GroundOverlayOptions original) {
        mOriginal = original;
    }

    @Override
    public int describeContents() {
        return mOriginal.describeContents();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(mOriginal, flags);
    }

    public MaptexGroundOverlayOptions anchor(float u, float v) {
        mOriginal.anchor(u, v);
        return this;
    }

    public MaptexGroundOverlayOptions bearing(float bearing) {
        mOriginal.bearing(bearing);
        return this;
    }

    public float getAnchorU() {
        return mOriginal.getAnchorU();
    }

    public float getAnchorV() {
        return mOriginal.getAnchorV();
    }

    public float getBearing() {
        return mOriginal.getBearing();
    }

    public MaptexLatLngBounds getBounds() {
        final com.google.android.gms.maps.model.LatLngBounds original = mOriginal.getBounds();
        return original == null ? null : MaptexLatLngBounds.obtain(original);
    }

    public float getHeight() {
        return mOriginal.getHeight();
    }

    public MaptexBitmapDescriptor getImage() {
        final com.google.android.gms.maps.model.BitmapDescriptor original = mOriginal.getImage();
        return original == null ? null : new MaptexBitmapDescriptor(mOriginal.getImage());
    }

    public MaptexLatLng getLocation() {
        final com.google.android.gms.maps.model.LatLng original = mOriginal.getLocation();
        return original == null ? null : new MaptexLatLng(original.latitude, original.longitude);
    }

    public float getTransparency() {
        return mOriginal.getTransparency();
    }

    public float getWidth() {
        return mOriginal.getWidth();
    }

    public float getZIndex() {
        return mOriginal.getZIndex();
    }

    public MaptexGroundOverlayOptions image(MaptexBitmapDescriptor image) {
        mOriginal.image(image == null ? null : image.mOriginal);
        return this;
    }

    public boolean isVisible() {
        return mOriginal.isVisible();
    }

    public MaptexGroundOverlayOptions position(MaptexLatLng location, float width) {
        mOriginal.position(location == null ? null : new LatLng(location.latitude, location.longitude), width);
        return this;
    }

    public MaptexGroundOverlayOptions position(MaptexLatLng location, float width, float height) {
        mOriginal.position(location == null ? null : new LatLng(location.latitude, location.longitude), width, height);
        return this;
    }

    public MaptexGroundOverlayOptions positionFromBounds(MaptexLatLngBounds bounds) {
        mOriginal.positionFromBounds(bounds == null ? null : bounds.mOriginal);
        return this;
    }

    /**
     * Reset the MaptexGroundOverlayOptions by setting all of its properties to their default values.
     */
    @Maptex
    public void reset() {
        if (mDefaultOptions == null) {
            mDefaultOptions = new MaptexGroundOverlayOptions();
        }
        anchor(mDefaultOptions.getAnchorU(), mDefaultOptions.getAnchorV());
        bearing(mDefaultOptions.getBearing());
        image(mDefaultOptions.getImage());
        position(mDefaultOptions.getLocation(), mDefaultOptions.getWidth(), mDefaultOptions.getHeight());
        transparency(mDefaultOptions.getTransparency());
        visible(mDefaultOptions.isVisible());
        zIndex(mDefaultOptions.getZIndex());
    }

    public MaptexGroundOverlayOptions transparency(float transparency) {
        mOriginal.transparency(transparency);
        return this;
    }

    public MaptexGroundOverlayOptions visible(boolean visible) {
        mOriginal.visible(visible);
        return this;
    }

    public MaptexGroundOverlayOptions zIndex(float zIndex) {
        mOriginal.zIndex(zIndex);
        return this;
    }

}
