package ir.map.sdk_map.wrapper;


import android.os.Parcel;
import android.os.Parcelable;

import com.google.android.gms.maps.model.LatLng;

import ir.map.sdk_common.MaptexLatLng;


public final class MaptexCircleOptions implements Parcelable {

    public static final Creator<MaptexCircleOptions> CREATOR = new Creator<MaptexCircleOptions>() {
        public MaptexCircleOptions createFromParcel(Parcel in) {
            return new MaptexCircleOptions((com.google.android.gms.maps.model.CircleOptions) in.readParcelable(null));
        }

        public MaptexCircleOptions[] newArray(int size) {
            return new MaptexCircleOptions[size];
        }
    };

    /**
     * <strong>DO NOT USE.</strong>

     * The original MaptexCircleOptions.
     *

     */
    public final com.google.android.gms.maps.model.CircleOptions mOriginal;

    private MaptexCircleOptions mDefaultOptions;

    public MaptexCircleOptions() {
        this(new com.google.android.gms.maps.model.CircleOptions());
    }

    MaptexCircleOptions(com.google.android.gms.maps.model.CircleOptions original) {
        mOriginal = original;
    }

    @Override
    public int describeContents() {
        return mOriginal.describeContents();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(mOriginal, flags);
    }

    public MaptexCircleOptions center(MaptexLatLng point) {
        mOriginal.center(point == null ? null : new LatLng(point.latitude, point.longitude));
        return this;
    }

    public MaptexCircleOptions fillColor(int color) {
        mOriginal.fillColor(color);
        return this;
    }

    public MaptexLatLng getCenter() {
        final com.google.android.gms.maps.model.LatLng original = mOriginal.getCenter();
        return original == null ? null : new MaptexLatLng(original.latitude, original.longitude);
    }

    public int getFillColor() {
        return mOriginal.getFillColor();
    }

    public double getRadius() {
        return mOriginal.getRadius();
    }

    public int getStrokeColor() {
        return mOriginal.getStrokeColor();
    }

    public float getStrokeWidth() {
        return mOriginal.getStrokeWidth();
    }

    public float getZIndex() {
        return mOriginal.getZIndex();
    }

    public boolean isVisible() {
        return mOriginal.isVisible();
    }

    public MaptexCircleOptions radius(double radius) {
        mOriginal.radius(radius);
        return this;
    }

    /**
     * Reset the MaptexCircleOptions by setting all of its properties to their default values.
     */
    @Maptex
    public void reset() {
        if (mDefaultOptions == null) {
            mDefaultOptions = new MaptexCircleOptions();
        }
        center(mDefaultOptions.getCenter());
        fillColor(mDefaultOptions.getFillColor());
        radius(mDefaultOptions.getRadius());
        strokeColor(mDefaultOptions.getStrokeColor());
        strokeWidth(mDefaultOptions.getStrokeWidth());
        visible(mDefaultOptions.isVisible());
        zIndex(mDefaultOptions.getZIndex());
    }

    public MaptexCircleOptions strokeColor(int color) {
        mOriginal.strokeColor(color);
        return this;
    }

    public MaptexCircleOptions strokeWidth(float width) {
        mOriginal.strokeWidth(width);
        return this;
    }

    public MaptexCircleOptions visible(boolean visible) {
        mOriginal.visible(visible);
        return this;
    }

    public MaptexCircleOptions zIndex(float zIndex) {
        mOriginal.zIndex(zIndex);
        return this;
    }

}
