/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import ir.map.sdk_map.R;
import ir.map.sdk_map.utils.BubbleDrawable;
import ir.map.sdk_map.utils.RotationLayout;

public class IconGenerator {
    public static final int STYLE_DEFAULT = 1;
    public static final int STYLE_WHITE = 2;
    public static final int STYLE_RED = 3;
    public static final int STYLE_BLUE = 4;
    public static final int STYLE_GREEN = 5;
    public static final int STYLE_PURPLE = 6;
    public static final int STYLE_ORANGE = 7;
    private final Context mContext;
    private ViewGroup mContainer;
    private RotationLayout mRotationLayout;
    private TextView mTextView;
    private View mContentView;
    private int mRotation;
    private float mAnchorU = 0.5f;
    private float mAnchorV = 1.0f;
    private BubbleDrawable mBackground;

    public IconGenerator(Context context) {
        this.mContext = context;
        this.mBackground = new BubbleDrawable(this.mContext.getResources());
        this.mContainer = (ViewGroup)LayoutInflater.from((Context)this.mContext).inflate(R.layout.amu_text_bubble_sdk, null);
        this.mRotationLayout = (RotationLayout)this.mContainer.getChildAt(0);
        this.mTextView = (TextView)this.mRotationLayout.findViewById(R.id.amu_text);
        this.mContentView = this.mTextView;
        this.setStyle(1);
    }

    private static int getStyleColor(int n) {
        switch (n) {
            default: {
                return -1;
            }
            case 3: {
                return -3407872;
            }
            case 4: {
                return -16737844;
            }
            case 5: {
                return -10053376;
            }
            case 6: {
                return -6736948;
            }
            case 7: 
        }
        return -30720;
    }

    private static int getTextStyle(int n) {
        switch (n) {
            default: {
                return R.style.amu_Bubble_TextAppearance_Dark;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
        }
        return R.style.amu_Bubble_TextAppearance_Light;
    }

    public Bitmap makeIcon(CharSequence charSequence) {
        if (this.mTextView != null) {
            this.mTextView.setText(charSequence);
        }
        return this.makeIcon();
    }

    public Bitmap makeIcon() {
        int n = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.mContainer.measure(n, n);
        int n2 = this.mContainer.getMeasuredWidth();
        int n3 = this.mContainer.getMeasuredHeight();
        this.mContainer.layout(0, 0, n2, n3);
        if (this.mRotation == 1 || this.mRotation == 3) {
            n3 = this.mContainer.getMeasuredWidth();
            n2 = this.mContainer.getMeasuredHeight();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.eraseColor(0);
        Canvas canvas = new Canvas(bitmap);
        switch (this.mRotation) {
            case 0: {
                break;
            }
            case 1: {
                canvas.translate((float)n2, 0.0f);
                canvas.rotate(90.0f);
                break;
            }
            case 2: {
                canvas.rotate(180.0f, (float)(n2 / 2), (float)(n3 / 2));
                break;
            }
            case 3: {
                canvas.translate(0.0f, (float)n3);
                canvas.rotate(270.0f);
            }
        }
        this.mContainer.draw(canvas);
        return bitmap;
    }

    public void setContentView(View view) {
        this.mRotationLayout.removeAllViews();
        this.mRotationLayout.addView(view);
        this.mContentView = view;
        View view2 = this.mRotationLayout.findViewById(R.id.amu_text);
        this.mTextView = view2 instanceof TextView ? (TextView)view2 : null;
    }

    public void setContentRotation(int n) {
        this.mRotationLayout.setViewRotation(n);
    }

    public void setRotation(int n) {
        this.mRotation = (n + 360) % 360 / 90;
    }

    public float getAnchorU() {
        return this.rotateAnchor(this.mAnchorU, this.mAnchorV);
    }

    public float getAnchorV() {
        return this.rotateAnchor(this.mAnchorV, this.mAnchorU);
    }

    private float rotateAnchor(float f2, float f3) {
        switch (this.mRotation) {
            case 0: {
                return f2;
            }
            case 1: {
                return 1.0f - f3;
            }
            case 2: {
                return 1.0f - f2;
            }
            case 3: {
                return f3;
            }
        }
        throw new IllegalStateException();
    }

    public void setTextAppearance(Context context, int n) {
        if (this.mTextView != null) {
            this.mTextView.setTextAppearance(context, n);
        }
    }

    public void setTextAppearance(int n) {
        this.setTextAppearance(this.mContext, n);
    }

    public void setStyle(int n) {
        this.setColor(IconGenerator.getStyleColor(n));
        this.setTextAppearance(this.mContext, IconGenerator.getTextStyle(n));
    }

    public void setColor(int n) {
        this.mBackground.setColor(n);
        this.setBackground(this.mBackground);
    }

    public void setBackground(Drawable drawable2) {
        this.mContainer.setBackgroundDrawable(drawable2);
        if (drawable2 != null) {
            Rect rect = new Rect();
            drawable2.getPadding(rect);
            this.mContainer.setPadding(rect.left, rect.top, rect.right, rect.bottom);
        } else {
            this.mContainer.setPadding(0, 0, 0, 0);
        }
    }

    public void setContentPadding(int n, int n2, int n3, int n4) {
        this.mContentView.setPadding(n, n2, n3, n4);
    }
}

