/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map.utils;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.google.maps.android.R;

public class BubbleDrawable
extends Drawable {
    private final Drawable mShadow;
    private final Drawable mMask;
    private int mColor = -1;

    public BubbleDrawable(Resources resources) {
        this.mMask = resources.getDrawable(R.drawable.amu_bubble_mask);
        this.mShadow = resources.getDrawable(R.drawable.amu_bubble_shadow);
    }

    public void setColor(int n) {
        this.mColor = n;
    }

    public void draw(Canvas canvas) {
        this.mMask.draw(canvas);
        canvas.drawColor(this.mColor, PorterDuff.Mode.SRC_IN);
        this.mShadow.draw(canvas);
    }

    public void setAlpha(int n) {
        throw new UnsupportedOperationException();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        throw new UnsupportedOperationException();
    }

    public int getOpacity() {
        return -3;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.mMask.setBounds(n, n2, n3, n4);
        this.mShadow.setBounds(n, n2, n3, n4);
    }

    public void setBounds(Rect rect) {
        this.mMask.setBounds(rect);
        this.mShadow.setBounds(rect);
    }

    public boolean getPadding(Rect rect) {
        return this.mMask.getPadding(rect);
    }
}

