package ir.map.sdk_map.wrapper;

import java.net.URL;


public abstract class BaseMaptexUrlTileProvider implements MaptexTileProvider {

    public final com.google.android.gms.maps.model.UrlTileProvider mOriginal;

    public BaseMaptexUrlTileProvider(int width, int height) {
        mOriginal = new com.google.android.gms.maps.model.UrlTileProvider(width, height) {
            @Override
            public URL getTileUrl(int x, int y, int zoom) {
                return innerGetTileUrl(x, y, zoom);
            }

            private URL innerGetTileUrl(int x, int y, int zoom) {
                return BaseMaptexUrlTileProvider.this.getTileUrl(x, y, zoom);
            }
        };
    }

    @Override
    public MaptexTile getTile(int x, int y, int zoom) {
        return new MaptexTile(mOriginal.getTile(x, y, zoom));
    }

    public abstract URL getTileUrl(int x, int y, int zoom);
}
