package ir.map.sdk_map.wrapper;

import android.os.Parcel;
import android.os.Parcelable;


public final class MaptexTile implements Parcelable {

    public static final Creator<MaptexTile> CREATOR = new Creator<MaptexTile>() {
        public MaptexTile createFromParcel(Parcel in) {
            return new MaptexTile((com.google.android.gms.maps.model.Tile) in.readParcelable(null));
        }

        public MaptexTile[] newArray(int size) {
            return new MaptexTile[size];
        }
    };

    public final int width;
    public final int height;
    public final byte[] data;

    final com.google.android.gms.maps.model.Tile mOriginal;

    public MaptexTile(int width, int height, byte[] data) {
        this(new com.google.android.gms.maps.model.Tile(width, height, data));
    }

    MaptexTile(com.google.android.gms.maps.model.Tile original) {
        mOriginal = original;

        this.width = original.width;
        this.height = original.height;
        this.data = original.data;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(mOriginal, flags);
    }

}
