package ir.map.sdk_map.wrapper;

import android.graphics.Point;

import com.google.android.gms.maps.model.LatLng;

import ir.map.sdk_common.MaptexLatLng;


public final class MaptexProjection {

    final com.google.android.gms.maps.Projection mOriginal;

    MaptexProjection(com.google.android.gms.maps.Projection original) {
        mOriginal = original;
    }

    public MaptexLatLng fromScreenLocation(Point point) {
        return new MaptexLatLng(mOriginal.fromScreenLocation(point).latitude, mOriginal.fromScreenLocation(point).longitude);
    }

    public MaptexVisibleRegion getVisibleRegion() {
        return MaptexVisibleRegion.obtain(mOriginal.getVisibleRegion());
    }

    public Point toScreenLocation(MaptexLatLng location) {
        return mOriginal.toScreenLocation(new LatLng(location.latitude, location.longitude));
    }
}
