package ir.map.sdk_map.wrapper;

import java.util.List;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_map.internal.ListTranslators;
import ir.map.sdk_map.internal.ListWrappers;


public final class MaptexPolygon {

    final com.google.android.gms.maps.model.Polygon mOriginal;

    private MaptexPolygon(com.google.android.gms.maps.model.Polygon original) {
        mOriginal = original;
    }

    /**
     * Obtain a new MaptexPolygon based an original one.
     *
     * @param original
     * @return

     */
    public static MaptexPolygon obtain(com.google.android.gms.maps.model.Polygon original) {
        return new MaptexPolygon(original);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MaptexPolygon)) {
            return false;
        }
        return mOriginal.equals(((MaptexPolygon) other).mOriginal);
    }

    @Override
    public int hashCode() {
        return mOriginal.hashCode();
    }

    public int getFillColor() {
        return mOriginal.getFillColor();
    }

    public void setFillColor(int color) {
        mOriginal.setFillColor(color);
    }

    public List<List<MaptexLatLng>> getHoles() {
        final List<List<com.google.android.gms.maps.model.LatLng>> original = mOriginal.getHoles();
        return original == null ? null : ListWrappers.forLatLngList(original);
    }

    public void setHoles(List<? extends List<MaptexLatLng>> holes) {
        mOriginal.setHoles(holes == null ? null : ListTranslators.latLngListList(holes));
    }

    public String getId() {
        return mOriginal.getId();
    }

    public List<MaptexLatLng> getPoints() {
        final List<com.google.android.gms.maps.model.LatLng> original = mOriginal.getPoints();
        return original == null ? null : ListWrappers.forLatLng(original);
    }

    public void setPoints(List<MaptexLatLng> points) {
        mOriginal.setPoints(points == null ? null : ListTranslators.latLngList(points));
    }

    public int getStrokeColor() {
        return mOriginal.getStrokeColor();
    }

    public void setStrokeColor(int color) {
        mOriginal.setStrokeColor(color);
    }

    public float getStrokeWidth() {
        return mOriginal.getStrokeWidth();
    }

    public void setStrokeWidth(float width) {
        mOriginal.setStrokeWidth(width);
    }

    public float getZIndex() {
        return mOriginal.getZIndex();
    }

    public void setZIndex(float zIndex) {
        mOriginal.setZIndex(zIndex);
    }

    public boolean isGeodesic() {
        return mOriginal.isGeodesic();
    }

    public void setGeodesic(boolean geodesic) {
        mOriginal.setGeodesic(geodesic);
    }

    public boolean isVisible() {
        return mOriginal.isVisible();
    }

    public void setVisible(boolean visible) {
        mOriginal.setVisible(visible);
    }

    public void remove() {
        mOriginal.remove();
    }

    public void setClickable(boolean b) {
        mOriginal.setClickable(b);
    }
}
