/*
 * Copyright (C) 2013 Cyril Mottier (http://cyrilmottier.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ir.map.sdk_map.internal;


import com.google.android.gms.maps.model.LatLng;

import java.util.List;

import ir.map.sdk_common.MaptexLatLng;

public final class ListWrappers {

    private static final TypeTranslator<com.google.android.gms.maps.model.LatLng, MaptexLatLng> LAT_LNG_TRANSLATOR =
            new TypeTranslator<com.google.android.gms.maps.model.LatLng, MaptexLatLng>() {
                @Override
                public com.google.android.gms.maps.model.LatLng unwrap(MaptexLatLng wrapper) {
                    return new LatLng(wrapper.latitude, wrapper.longitude);
                }

                @Override
                public MaptexLatLng wrap(com.google.android.gms.maps.model.LatLng original) {
                    return new MaptexLatLng(original.latitude, original.longitude);
                }
            };

    private static final TypeTranslator<List<com.google.android.gms.maps.model.LatLng>, List<MaptexLatLng>> LAT_LNG_LIST_TRANSLATOR =
            new TypeTranslator<List<com.google.android.gms.maps.model.LatLng>, List<MaptexLatLng>>() {
                @Override
                public List<com.google.android.gms.maps.model.LatLng> unwrap(List<MaptexLatLng> wrapper) {
                    return ListTranslators.latLngList(wrapper);
                }

                @Override
                public List<MaptexLatLng> wrap(List<com.google.android.gms.maps.model.LatLng> original) {
                    return forLatLng(original);
                }
            };

    private ListWrappers() {
    }

    public static List<MaptexLatLng> forLatLng(List<com.google.android.gms.maps.model.LatLng> original) {
        return new ListWrapper<>(original, LAT_LNG_TRANSLATOR);
    }

    public static List<List<MaptexLatLng>> forLatLngList(List<List<com.google.android.gms.maps.model.LatLng>> original) {
        return new ListWrapper<>(original, LAT_LNG_LIST_TRANSLATOR);
    }

}
