/*
 * Decompiled with CFR 0.152.
 */
package ir.map.sdk_map;

import ir.map.sdk_common.MaptexLatLng;
import ir.map.sdk_map.a;
import java.util.List;

public class MaptexSphericalUtil {
    private MaptexSphericalUtil() {
    }

    public static double computeHeading(MaptexLatLng maptexLatLng, MaptexLatLng maptexLatLng2) {
        double d2 = Math.toRadians(maptexLatLng.latitude);
        double d3 = Math.toRadians(maptexLatLng.longitude);
        double d4 = Math.toRadians(maptexLatLng2.latitude);
        double d5 = Math.toRadians(maptexLatLng2.longitude);
        double d6 = d5 - d3;
        double d7 = Math.atan2(Math.sin(d6) * Math.cos(d4), Math.cos(d2) * Math.sin(d4) - Math.sin(d2) * Math.cos(d4) * Math.cos(d6));
        return a.b(Math.toDegrees(d7), -180.0, 180.0);
    }

    public static MaptexLatLng computeOffset(MaptexLatLng maptexLatLng, double d2, double d3) {
        d3 = Math.toRadians(d3);
        double d4 = Math.toRadians(maptexLatLng.latitude);
        double d5 = Math.toRadians(maptexLatLng.longitude);
        double d6 = Math.cos(d2 /= 6371009.0);
        double d7 = Math.sin(d2);
        double d8 = Math.sin(d4);
        double d9 = Math.cos(d4);
        double d10 = d6 * d8 + d7 * d9 * Math.cos(d3);
        double d11 = Math.atan2(d7 * d9 * Math.sin(d3), d6 - d8 * d10);
        return new MaptexLatLng(Math.toDegrees(Math.asin(d10)), Math.toDegrees(d5 + d11));
    }

    public static MaptexLatLng computeOffsetOrigin(MaptexLatLng maptexLatLng, double d2, double d3) {
        double d4;
        d3 = Math.toRadians(d3);
        double d5 = Math.cos(d2 /= 6371009.0);
        double d6 = Math.sin(d2) * Math.cos(d3);
        double d7 = Math.sin(d2) * Math.sin(d3);
        double d8 = d5 * d5;
        double d9 = Math.sin(Math.toRadians(maptexLatLng.latitude));
        double d10 = d6 * d6 * d8 + d8 * d8 - d8 * d9 * d9;
        if (d10 < 0.0) {
            return null;
        }
        double d11 = d6 * d9 + Math.sqrt(d10);
        double d12 = (d9 - d6 * (d11 /= d5 * d5 + d6 * d6)) / d5;
        if ((d4 = Math.atan2(d12, d11)) < -1.5707963267948966 || d4 > 1.5707963267948966) {
            d11 = d6 * d9 - Math.sqrt(d10);
            d4 = Math.atan2(d12, d11 /= d5 * d5 + d6 * d6);
        }
        if (d4 >= -1.5707963267948966 && d4 <= 1.5707963267948966) {
            double d13 = Math.toRadians(maptexLatLng.longitude) - Math.atan2(d7, d5 * Math.cos(d4) - d6 * Math.sin(d4));
            return new MaptexLatLng(Math.toDegrees(d4), Math.toDegrees(d13));
        }
        return null;
    }

    public static MaptexLatLng interpolate(MaptexLatLng maptexLatLng, MaptexLatLng maptexLatLng2, double d2) {
        double d3 = Math.toRadians(maptexLatLng.latitude);
        double d4 = Math.toRadians(maptexLatLng.longitude);
        double d5 = Math.toRadians(maptexLatLng2.latitude);
        double d6 = Math.toRadians(maptexLatLng2.longitude);
        double d7 = Math.cos(d3);
        double d8 = Math.cos(d5);
        double d9 = MaptexSphericalUtil.computeAngleBetween(maptexLatLng, maptexLatLng2);
        double d10 = Math.sin(d9);
        if (d10 < 1.0E-6) {
            return maptexLatLng;
        }
        double d11 = Math.sin((1.0 - d2) * d9) / d10;
        double d12 = Math.sin(d2 * d9) / d10;
        double d13 = d11 * d7 * Math.cos(d4) + d12 * d8 * Math.cos(d6);
        double d14 = d11 * d7 * Math.sin(d4) + d12 * d8 * Math.sin(d6);
        double d15 = d11 * Math.sin(d3) + d12 * Math.sin(d5);
        double d16 = Math.atan2(d15, Math.sqrt(d13 * d13 + d14 * d14));
        double d17 = Math.atan2(d14, d13);
        return new MaptexLatLng(Math.toDegrees(d16), Math.toDegrees(d17));
    }

    private static double distanceRadians(double d2, double d3, double d4, double d5) {
        return a.d(a.c(d2, d4, d3 - d5));
    }

    static double computeAngleBetween(MaptexLatLng maptexLatLng, MaptexLatLng maptexLatLng2) {
        return MaptexSphericalUtil.distanceRadians(Math.toRadians(maptexLatLng.latitude), Math.toRadians(maptexLatLng.longitude), Math.toRadians(maptexLatLng2.latitude), Math.toRadians(maptexLatLng2.longitude));
    }

    public static double computeDistanceBetween(MaptexLatLng maptexLatLng, MaptexLatLng maptexLatLng2) {
        return MaptexSphericalUtil.computeAngleBetween(maptexLatLng, maptexLatLng2) * 6371009.0;
    }

    public static double computeLength(List<MaptexLatLng> list) {
        if (list.size() < 2) {
            return 0.0;
        }
        double d2 = 0.0;
        MaptexLatLng maptexLatLng = list.get(0);
        double d3 = Math.toRadians(maptexLatLng.latitude);
        double d4 = Math.toRadians(maptexLatLng.longitude);
        for (MaptexLatLng maptexLatLng2 : list) {
            double d5 = Math.toRadians(maptexLatLng2.latitude);
            double d6 = Math.toRadians(maptexLatLng2.longitude);
            d2 += MaptexSphericalUtil.distanceRadians(d3, d4, d5, d6);
            d3 = d5;
            d4 = d6;
        }
        return d2 * 6371009.0;
    }

    public static double computeArea(List<MaptexLatLng> list) {
        return Math.abs(MaptexSphericalUtil.computeSignedArea(list));
    }

    public static double computeSignedArea(List<MaptexLatLng> list) {
        return MaptexSphericalUtil.computeSignedArea(list, 6371009.0);
    }

    static double computeSignedArea(List<MaptexLatLng> list, double d2) {
        int n = list.size();
        if (n < 3) {
            return 0.0;
        }
        double d3 = 0.0;
        MaptexLatLng maptexLatLng = list.get(n - 1);
        double d4 = Math.tan((1.5707963267948966 - Math.toRadians(maptexLatLng.latitude)) / 2.0);
        double d5 = Math.toRadians(maptexLatLng.longitude);
        for (MaptexLatLng maptexLatLng2 : list) {
            double d6 = Math.tan((1.5707963267948966 - Math.toRadians(maptexLatLng2.latitude)) / 2.0);
            double d7 = Math.toRadians(maptexLatLng2.longitude);
            d3 += MaptexSphericalUtil.polarTriangleArea(d6, d7, d4, d5);
            d4 = d6;
            d5 = d7;
        }
        return d3 * d2 * d2;
    }

    private static double polarTriangleArea(double d2, double d3, double d4, double d5) {
        double d6 = d3 - d5;
        double d7 = d2 * d4;
        return 2.0 * Math.atan2(d7 * Math.sin(d6), 1.0 + d7 * Math.cos(d6));
    }
}

