package ir.map.sdk_map.wrapper;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.DeferredLifecycleHelper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import ir.map.sdk_map.MapSDK;


public class MaptexView extends FrameLayout {
    private final MaptexView.zzb zzbf;

    public MaptexView(Context var1) {
        super(var1);
        this.zzbf = new MaptexView.zzb(this, var1, (MaptexMapOptions) null);
        this.setClickable(true);
    }

    public MaptexView(Context var1, AttributeSet var2) {
        super(var1, var2);
        this.zzbf = new MaptexView.zzb(this, var1, MaptexMapOptions.createFromAttributes(var1, var2));
        this.setClickable(true);
    }

    public MaptexView(Context var1, AttributeSet var2, int var3) {
        super(var1, var2, var3);
        this.zzbf = new MaptexView.zzb(this, var1, MaptexMapOptions.createFromAttributes(var1, var2));
        this.setClickable(true);
    }

    public MaptexView(Context var1, MaptexMapOptions var2) {
        super(var1);
        this.zzbf = new MaptexView.zzb(this, var1, var2);
        this.setClickable(true);
    }

    public final void onCreate(Bundle var1) {
        StrictMode.ThreadPolicy var2 = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((new StrictMode.ThreadPolicy.Builder(var2)).permitAll().build());

        try {
            this.zzbf.onCreate(var1);
            if (this.zzbf.getDelegate() == null) {
                DeferredLifecycleHelper.showGooglePlayUnavailableMessage(this);
            }
        } finally {
            StrictMode.setThreadPolicy(var2);
        }

    }

    public final void onResume() {
        this.zzbf.onResume();
    }

    public final void onPause() {
        this.zzbf.onPause();
    }

    public final void onStart() {
        this.zzbf.onStart();
    }

    public final void onStop() {
        this.zzbf.onStop();
    }

    public final void onDestroy() {
        this.zzbf.onDestroy();
    }

    public final void onLowMemory() {
        this.zzbf.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle var1) {
        this.zzbf.onSaveInstanceState(var1);
    }

    public void getMaptexAsync(final OnMaptexReadyCallback var1) {
        Preconditions.checkMainThread("getMapAsync() must be called on the main thread");
        this.zzbf.getMapAsync(new OnMapReadyCallback() {
            @Override
            public void onMapReady(GoogleMap googleMap) {
                MaptexMap maptexMap = new MaptexMap(googleMap);
                var1.onMaptexReady(maptexMap);
            }
        });
    }

    public final void onEnterAmbient(Bundle var1) {
        Preconditions.checkMainThread("onEnterAmbient() must be called on the main thread");
        MaptexView.zzb var2 = this.zzbf;
        if (this.zzbf.getDelegate() != null) {
            ((MaptexView.zza) var2.getDelegate()).onEnterAmbient(var1);
        }

    }

    public final void onExitAmbient() {
        Preconditions.checkMainThread("onExitAmbient() must be called on the main thread");
        MaptexView.zzb var1 = this.zzbf;
        if (this.zzbf.getDelegate() != null) {
            ((MaptexView.zza) var1.getDelegate()).onExitAmbient();
        }

    }

    @VisibleForTesting
    static class zzb extends DeferredLifecycleHelper<MaptexView.zza> {
        private final ViewGroup zzbi;
        private final Context zzbj;
        private final GoogleMapOptions zzbk;
        private final List<OnMapReadyCallback> zzbe = new ArrayList();
        private OnDelegateCreatedListener<MaptexView.zza> zzbc;

        @VisibleForTesting
        zzb(ViewGroup var1, Context var2, MaptexMapOptions var3) {
            this.zzbi = var1;
            this.zzbj = var2;
            this.zzbk = var3.mOriginal;
        }

        protected final void createDelegate(OnDelegateCreatedListener<MaptexView.zza> var1) {
            this.zzbc = var1;
            MaptexView.zzb var2 = this;
            if (this.zzbc != null && this.getDelegate() == null) {
                try {
                    MapsInitializer.initialize(var2.zzbj);
                    IMapViewDelegate var3;
                    if ((var3 = zzbz.zza(var2.zzbj).zza(ObjectWrapper.wrap(var2.zzbj), var2.zzbk)) == null) {
                        return;
                    }

                    var2.zzbc.onDelegateCreated(new MaptexView.zza(var2.zzbi, var3));
                    Iterator var4 = var2.zzbe.iterator();

                    while (var4.hasNext()) {
                        OnMapReadyCallback var5 = (OnMapReadyCallback) var4.next();
                        ((MaptexView.zza) var2.getDelegate()).getMapAsync(var5);
                    }

                    var2.zzbe.clear();
                    return;
                } catch (RemoteException var6) {
                    throw new RuntimeRemoteException(var6);
                } catch (GooglePlayServicesNotAvailableException var7) {
                    ;
                }
            }

        }

        public final void getMapAsync(OnMapReadyCallback var1) {
            if (this.getDelegate() != null) {
                ((MaptexView.zza) this.getDelegate()).getMapAsync(var1);
            } else {
                this.zzbe.add(var1);
            }
        }
    }

    @VisibleForTesting
    static class zza implements MapLifecycleDelegate {
        private final ViewGroup parent;
        private final IMapViewDelegate zzbg;
        private View zzbh;

        public zza(ViewGroup var1, IMapViewDelegate var2) {
            this.zzbg = (IMapViewDelegate) Preconditions.checkNotNull(var2);
            this.parent = (ViewGroup) Preconditions.checkNotNull(var1);
        }

        public final void onInflate(Activity var1, Bundle var2, Bundle var3) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public final void onCreate(Bundle var1) {
            try {
                Bundle var2 = new Bundle();
                zzby.zza(var1, var2);
                this.zzbg.onCreate(var2);
                zzby.zza(var2, var1);
                this.zzbh = (View) ObjectWrapper.unwrap(this.zzbg.getView());
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(
                        FrameLayout.LayoutParams.MATCH_PARENT,
                        FrameLayout.LayoutParams.MATCH_PARENT
                );
                int bottomMargin = new UnitHelper().convertDpToPixel(MapSDK.getContext(), 35f);
                params.setMargins(0, 0, 0, -bottomMargin);
                this.zzbh.setLayoutParams(params);
                this.zzbh.requestLayout();
                this.parent.removeAllViews();
                this.parent.addView(this.zzbh);
            } catch (RemoteException var3) {
                throw new RuntimeRemoteException(var3);
            }
        }

        public final View onCreateView(LayoutInflater var1, ViewGroup var2, Bundle var3) {
            throw new UnsupportedOperationException("onCreateView not allowed on MaptexViewDelegate");
        }

        public final void onStart() {
            try {
                this.zzbg.onStart();
            } catch (RemoteException var2) {
                throw new RuntimeRemoteException(var2);
            }
        }

        public final void onResume() {
            try {
                this.zzbg.onResume();
            } catch (RemoteException var2) {
                throw new RuntimeRemoteException(var2);
            }
        }

        public final void onPause() {
            try {
                this.zzbg.onPause();
            } catch (RemoteException var2) {
                throw new RuntimeRemoteException(var2);
            }
        }

        public final void onStop() {
            try {
                this.zzbg.onStop();
            } catch (RemoteException var2) {
                throw new RuntimeRemoteException(var2);
            }
        }

        public final void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public final void onDestroy() {
            try {
                this.zzbg.onDestroy();
            } catch (RemoteException var2) {
                throw new RuntimeRemoteException(var2);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzbg.onLowMemory();
            } catch (RemoteException var2) {
                throw new RuntimeRemoteException(var2);
            }
        }

        public final void onSaveInstanceState(Bundle var1) {
            try {
                Bundle var2 = new Bundle();
                zzby.zza(var1, var2);
                this.zzbg.onSaveInstanceState(var2);
                zzby.zza(var2, var1);
            } catch (RemoteException var3) {
                throw new RuntimeRemoteException(var3);
            }
        }

        public final void getMapAsync(OnMapReadyCallback var1) {
            try {
                this.zzbg.getMapAsync(new zzac(this, var1));
            } catch (RemoteException var3) {
                throw new RuntimeRemoteException(var3);
            }
        }

        public final void onEnterAmbient(Bundle var1) {
            try {
                Bundle var2 = new Bundle();
                zzby.zza(var1, var2);
                this.zzbg.onEnterAmbient(var2);
                zzby.zza(var2, var1);
            } catch (RemoteException var3) {
                throw new RuntimeRemoteException(var3);
            }
        }

        public final void onExitAmbient() {
            try {
                this.zzbg.onExitAmbient();
            } catch (RemoteException var2) {
                throw new RuntimeRemoteException(var2);
            }
        }
    }
}
