package ir.map.sdk_map.wrapper;

import android.graphics.Bitmap;


public final class MaptexBitmapDescriptorFactory {

    public static final float HUE_AZURE = com.google.android.gms.maps.model.BitmapDescriptorFactory.HUE_AZURE;
    public static final float HUE_BLUE = com.google.android.gms.maps.model.BitmapDescriptorFactory.HUE_BLUE;
    public static final float HUE_CYAN = com.google.android.gms.maps.model.BitmapDescriptorFactory.HUE_CYAN;
    public static final float HUE_GREEN = com.google.android.gms.maps.model.BitmapDescriptorFactory.HUE_GREEN;
    public static final float HUE_MAGENTA = com.google.android.gms.maps.model.BitmapDescriptorFactory.HUE_MAGENTA;
    public static final float HUE_ORANGE = com.google.android.gms.maps.model.BitmapDescriptorFactory.HUE_ORANGE;
    public static final float HUE_RED = com.google.android.gms.maps.model.BitmapDescriptorFactory.HUE_RED;
    public static final float HUE_ROSE = com.google.android.gms.maps.model.BitmapDescriptorFactory.HUE_ROSE;
    public static final float HUE_VIOLET = com.google.android.gms.maps.model.BitmapDescriptorFactory.HUE_VIOLET;
    public static final float HUE_YELLOW = com.google.android.gms.maps.model.BitmapDescriptorFactory.HUE_YELLOW;

    private MaptexBitmapDescriptorFactory() {
        // No instance
    }

    public static MaptexBitmapDescriptor defaultMarker() {
        return new MaptexBitmapDescriptor(com.google.android.gms.maps.model.BitmapDescriptorFactory.defaultMarker());
    }

    public static MaptexBitmapDescriptor defaultMarker(float hue) {
        return new MaptexBitmapDescriptor(com.google.android.gms.maps.model.BitmapDescriptorFactory.defaultMarker(hue));
    }

    public static MaptexBitmapDescriptor fromAsset(String assetName) {
        return new MaptexBitmapDescriptor(com.google.android.gms.maps.model.BitmapDescriptorFactory.fromAsset(assetName));
    }

    public static MaptexBitmapDescriptor fromBitmap(Bitmap image) {
        return new MaptexBitmapDescriptor(com.google.android.gms.maps.model.BitmapDescriptorFactory.fromBitmap(image));
    }

    public static MaptexBitmapDescriptor fromFile(String fileName) {
        return new MaptexBitmapDescriptor(com.google.android.gms.maps.model.BitmapDescriptorFactory.fromFile(fileName));
    }

    public static MaptexBitmapDescriptor fromPath(String absolutePath) {
        return new MaptexBitmapDescriptor(com.google.android.gms.maps.model.BitmapDescriptorFactory.fromPath(absolutePath));
    }

    public static MaptexBitmapDescriptor fromResource(int resourceId) {
        return new MaptexBitmapDescriptor(com.google.android.gms.maps.model.BitmapDescriptorFactory.fromResource(resourceId));
    }

}
