/*
 * Decompiled with CFR 0.152.
 */
package ir.basalam.rtlnavigationview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.design.internal.NavigationMenu;
import android.support.design.widget.NavigationView;
import android.support.v7.view.SupportMenuInflater;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ImageView;
import android.widget.TextView;
import ir.basalam.rtlnavigationview.R;

public class RtlNavigationView
extends NavigationView {
    private NavigationView.OnNavigationItemSelectedListener navigationItemSelectedListener;

    public RtlNavigationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray array = context.obtainStyledAttributes(attrs, new int[]{R.attr.rtl_menu});
        if (array.getResourceId(0, -1) != -1) {
            NavigationMenu menu = new NavigationMenu(context);
            new SupportMenuInflater(context).inflate(array.getResourceId(0, -1), (Menu)menu);
            this.createRtlMenu((Menu)menu);
            array.recycle();
        }
    }

    public void setNavigationItemSelectedListener(@Nullable NavigationView.OnNavigationItemSelectedListener listener) {
        this.navigationItemSelectedListener = listener;
    }

    private void createRtlMenu(Menu rtlMenu) {
        for (int i = 0; i < rtlMenu.size(); ++i) {
            MenuItem addedMenuItem = this.getMenu().add(null);
            final MenuItem currentRtlMenuItem = rtlMenu.getItem(i);
            boolean isGroup = currentRtlMenuItem.hasSubMenu();
            if (isGroup) {
                addedMenuItem.setActionView(R.layout.list_item_rtl_navigationview_group_title);
                addedMenuItem.setEnabled(false);
                TextView tvGroupTitle = (TextView)addedMenuItem.getActionView().findViewById(R.id.list_item_navigationview_group_title_textview);
                tvGroupTitle.setText(currentRtlMenuItem.getTitle());
                this.createRtlMenu((Menu)currentRtlMenuItem.getSubMenu());
                continue;
            }
            addedMenuItem.setActionView(R.layout.list_item_rtl_navigationview);
            addedMenuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem menuItem) {
                    if (RtlNavigationView.this.navigationItemSelectedListener != null) {
                        RtlNavigationView.this.navigationItemSelectedListener.onNavigationItemSelected(currentRtlMenuItem);
                    }
                    return false;
                }
            });
            TextView tvTitle = (TextView)addedMenuItem.getActionView().findViewById(R.id.list_item_rtl_navigationview_title_textview);
            ImageView ivIcon = (ImageView)addedMenuItem.getActionView().findViewById(R.id.list_item_rtl_navigationview_icon_imageview);
            tvTitle.setText(currentRtlMenuItem.getTitle());
            Drawable itemIcon = currentRtlMenuItem.getIcon();
            itemIcon.setColorFilter(this.getResources().getColor(R.color.colorListItemIcon), PorterDuff.Mode.SRC_IN);
            ivIcon.setImageDrawable(itemIcon);
        }
    }
}

