/*
 * Decompiled with CFR 0.152.
 */
package ir.afraapps.view.numberpicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.NumberKeyListener;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.StringRes;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.content.ContextCompat;
import ir.afraapps.view.numberpicker.R;
import ir.afraapps.view.numberpicker.Scroller;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class NumberPicker
extends LinearLayout {
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 0;
    private static final long DEFAULT_LONG_PRESS_UPDATE_INTERVAL = 300L;
    private static final int SELECTOR_MAX_FLING_VELOCITY_ADJUSTMENT = 8;
    private static final int SELECTOR_ADJUSTMENT_DURATION_MILLIS = 800;
    private static final int SNAP_SCROLL_DURATION = 300;
    private static final float FADING_EDGE_STRENGTH = 0.9f;
    private static final int UNSCALED_DEFAULT_SELECTION_DIVIDER_THICKNESS = 2;
    private static final int UNSCALED_DEFAULT_SELECTION_DIVIDERS_DISTANCE = 48;
    private static final int SIZE_UNSPECIFIED = -1;
    private static final int DEFAULT_MAX_VALUE = 100;
    private static final int DEFAULT_MIN_VALUE = 1;
    private static final int DEFAULT_MAX_HEIGHT = 180;
    private static final int DEFAULT_MIN_WIDTH = 64;
    private static final int DEFAULT_TEXT_COLOR = -16777216;
    private static final float DEFAULT_TEXT_SIZE = 25.0f;
    private static final TwoDigitFormatter sTwoDigitFormatter = new TwoDigitFormatter();
    private final AppCompatEditText mSelectedText;
    private int mMinHeight;
    private int mMaxHeight;
    private int mMinWidth;
    private int mMaxWidth;
    private final boolean mComputeMaxWidth;
    private int mSelectedTextColor = -16777216;
    private int mTextColor = -16777216;
    private float mTextSize = 25.0f;
    private Typeface mTypeface;
    private int mSelectorTextGapWidth;
    private int mSelectorTextGapHeight;
    private String[] mDisplayedValues;
    private int mMinValue = 1;
    private int mMaxValue = 100;
    private int mValue;
    private OnValueChangeListener mOnValueChangeListener;
    private OnScrollListener mOnScrollListener;
    private Formatter mFormatter;
    private long mLongPressUpdateInterval = 300L;
    private final SparseArray<String> mSelectorIndexToStringCache = new SparseArray();
    private int mWheelItemCount = 3;
    private int mWheelMiddleItemIndex = this.mWheelItemCount / 2;
    private int[] mSelectorIndices = new int[this.mWheelItemCount];
    private final Paint mSelectorWheelPaint;
    private int mSelectorElementSize;
    private int mInitialScrollOffset = Integer.MIN_VALUE;
    private int mCurrentScrollOffset;
    private final Scroller mFlingScroller;
    private final Scroller mAdjustScroller;
    private int mPreviousScrollerX;
    private int mPreviousScrollerY;
    private SetSelectionCommand mSetSelectionCommand;
    private ChangeCurrentByOneFromLongPressCommand mChangeCurrentByOneFromLongPressCommand;
    private float mLastDownEventX;
    private float mLastDownEventY;
    private float mLastDownOrMoveEventX;
    private float mLastDownOrMoveEventY;
    private VelocityTracker mVelocityTracker;
    private int mTouchSlop;
    private int mMinimumFlingVelocity;
    private int mMaximumFlingVelocity;
    private boolean mWrapSelectorWheel;
    private Drawable mSelectionDivider;
    private int mSelectionDividerColor;
    private int mSelectionDividersDistance;
    private int mSelectionDividerThickness;
    private int mScrollState = 0;
    private int mTopSelectionDividerTop;
    private int mBottomSelectionDividerBottom;
    private int mLeftOfSelectionDividerLeft;
    private int mRightOfSelectionDividerRight;
    private int mLastHandledDownDpadKeyCode = -1;
    private float mWidth;
    private float mHeight;
    private int mOrientation;
    private Context mContext;
    private static final char[] DIGIT_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0660', '\u0661', '\u0662', '\u0663', '\u0664', '\u0665', '\u0666', '\u0667', '\u0668', '\u0669', '\u06f0', '\u06f1', '\u06f2', '\u06f3', '\u06f4', '\u06f5', '\u06f6', '\u06f7', '\u06f8', '\u06f9', '-'};

    public static final Formatter getTwoDigitFormatter() {
        return sTwoDigitFormatter;
    }

    public NumberPicker(Context context) {
        this(context, null);
    }

    public NumberPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NumberPicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        this.mContext = context;
        TypedArray attributesArray = context.obtainStyledAttributes(attrs, R.styleable.NumberPicker, defStyle, 0);
        this.mSelectionDivider = ContextCompat.getDrawable((Context)context, (int)R.drawable.np_numberpicker_selection_divider);
        this.mSelectionDividerColor = attributesArray.getColor(R.styleable.NumberPicker_np_dividerColor, this.mSelectionDividerColor);
        int defSelectionDividerDistance = (int)TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mSelectionDividersDistance = attributesArray.getDimensionPixelSize(R.styleable.NumberPicker_np_dividerDistance, defSelectionDividerDistance);
        int defSelectionDividerThickness = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mSelectionDividerThickness = attributesArray.getDimensionPixelSize(R.styleable.NumberPicker_np_dividerThickness, defSelectionDividerThickness);
        this.mOrientation = attributesArray.getInt(R.styleable.NumberPicker_np_orientation, 1);
        this.mWidth = attributesArray.getDimensionPixelSize(R.styleable.NumberPicker_np_width, -1);
        this.mHeight = attributesArray.getDimensionPixelSize(R.styleable.NumberPicker_np_height, -1);
        this.setWidthAndHeight();
        this.mComputeMaxWidth = true;
        this.mValue = attributesArray.getInt(R.styleable.NumberPicker_np_value, this.mValue);
        this.mMaxValue = attributesArray.getInt(R.styleable.NumberPicker_np_max, this.mMaxValue);
        this.mMinValue = attributesArray.getInt(R.styleable.NumberPicker_np_min, this.mMinValue);
        this.mSelectedTextColor = attributesArray.getColor(R.styleable.NumberPicker_np_selectedTextColor, this.mSelectedTextColor);
        this.mTextColor = attributesArray.getColor(R.styleable.NumberPicker_np_textColor, this.mTextColor);
        this.mTextSize = attributesArray.getDimension(R.styleable.NumberPicker_np_textSize, this.spToPx(this.mTextSize));
        if (attributesArray.hasValue(R.styleable.NumberPicker_np_typeface)) {
            String font = "fonts/" + attributesArray.getString(R.styleable.NumberPicker_np_typeface);
            this.mTypeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)font);
        }
        this.mFormatter = this.stringToFormatter(attributesArray.getString(R.styleable.NumberPicker_np_formatter));
        this.mWheelItemCount = attributesArray.getInt(R.styleable.NumberPicker_np_wheelItemCount, this.mWheelItemCount);
        this.setWillNotDraw(false);
        LayoutInflater.from((Context)context).inflate(R.layout.number_picker_with_selector_wheel, (ViewGroup)this, true);
        this.mSelectedText = (AppCompatEditText)this.findViewById(R.id.np__numberpicker_input);
        this.mSelectedText.setEnabled(false);
        this.mSelectedText.setFocusable(false);
        this.mSelectedText.setImeOptions(1);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setTextAlign(Paint.Align.CENTER);
        this.mSelectorWheelPaint = paint;
        this.setSelectedTextColor(this.mSelectedTextColor);
        this.setTextColor(this.mTextColor);
        this.setTextSize(this.mTextSize);
        this.setFormatter(this.mFormatter);
        if (this.mTypeface != null) {
            this.setTypeface(this.mTypeface);
        }
        this.updateInputTextView();
        this.setValue(this.mValue);
        this.setMaxValue(this.mMaxValue);
        this.setMinValue(this.mMinValue);
        this.setDividerColor(this.mSelectionDividerColor);
        this.setWheelItemCount(this.mWheelItemCount);
        this.mWrapSelectorWheel = attributesArray.getBoolean(R.styleable.NumberPicker_np_wrapSelectorWheel, this.mWrapSelectorWheel);
        this.setWrapSelectorWheel(this.mWrapSelectorWheel);
        if (this.mWidth != -1.0f && this.mHeight != -1.0f) {
            this.setScaleX(this.mWidth / (float)this.mMinWidth);
            this.setScaleY(this.mHeight / (float)this.mMaxHeight);
        } else if (this.mWidth != -1.0f) {
            this.setScaleX(this.mWidth / (float)this.mMinWidth);
            this.setScaleY(this.mWidth / (float)this.mMinWidth);
        } else if (this.mHeight != -1.0f) {
            this.setScaleX(this.mHeight / (float)this.mMaxHeight);
            this.setScaleY(this.mHeight / (float)this.mMaxHeight);
        }
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumFlingVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity() / 8;
        this.mFlingScroller = new Scroller(context, null, true);
        this.mAdjustScroller = new Scroller(context, (Interpolator)new DecelerateInterpolator(2.5f));
        if (Build.VERSION.SDK_INT >= 16 && this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        attributesArray.recycle();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int msrdWdth = this.getMeasuredWidth();
        int msrdHght = this.getMeasuredHeight();
        int inptTxtMsrdWdth = this.mSelectedText.getMeasuredWidth();
        int inptTxtMsrdHght = this.mSelectedText.getMeasuredHeight();
        int inptTxtLeft = (msrdWdth - inptTxtMsrdWdth) / 2;
        int inptTxtTop = (msrdHght - inptTxtMsrdHght) / 2;
        int inptTxtRight = inptTxtLeft + inptTxtMsrdWdth;
        int inptTxtBottom = inptTxtTop + inptTxtMsrdHght;
        this.mSelectedText.layout(inptTxtLeft, inptTxtTop, inptTxtRight, inptTxtBottom);
        if (changed) {
            this.initializeSelectorWheel();
            this.initializeFadingEdges();
            if (this.isHorizontalMode()) {
                this.mLeftOfSelectionDividerLeft = (this.getWidth() - this.mSelectionDividersDistance) / 2 - this.mSelectionDividerThickness;
                this.mRightOfSelectionDividerRight = this.mLeftOfSelectionDividerLeft + 2 * this.mSelectionDividerThickness + this.mSelectionDividersDistance;
            } else {
                this.mTopSelectionDividerTop = (this.getHeight() - this.mSelectionDividersDistance) / 2 - this.mSelectionDividerThickness;
                this.mBottomSelectionDividerBottom = this.mTopSelectionDividerTop + 2 * this.mSelectionDividerThickness + this.mSelectionDividersDistance;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int newWidthMeasureSpec = this.makeMeasureSpec(widthMeasureSpec, this.mMaxWidth);
        int newHeightMeasureSpec = this.makeMeasureSpec(heightMeasureSpec, this.mMaxHeight);
        super.onMeasure(newWidthMeasureSpec, newHeightMeasureSpec);
        int widthSize = this.resolveSizeAndStateRespectingMinSize(this.mMinWidth, this.getMeasuredWidth(), widthMeasureSpec);
        int heightSize = this.resolveSizeAndStateRespectingMinSize(this.mMinHeight, this.getMeasuredHeight(), heightMeasureSpec);
        this.setMeasuredDimension(widthSize, heightSize);
    }

    private boolean moveToFinalScrollerPosition(Scroller scroller) {
        scroller.forceFinished(true);
        if (this.isHorizontalMode()) {
            int amountToScroll = scroller.getFinalX() - scroller.getCurrX();
            int futureScrollOffset = (this.mCurrentScrollOffset + amountToScroll) % this.mSelectorElementSize;
            int overshootAdjustment = this.mInitialScrollOffset - futureScrollOffset;
            if (overshootAdjustment != 0) {
                if (Math.abs(overshootAdjustment) > this.mSelectorElementSize / 2) {
                    overshootAdjustment = overshootAdjustment > 0 ? (overshootAdjustment -= this.mSelectorElementSize) : (overshootAdjustment += this.mSelectorElementSize);
                }
                this.scrollBy(amountToScroll += overshootAdjustment, 0);
                return true;
            }
        } else {
            int amountToScroll = scroller.getFinalY() - scroller.getCurrY();
            int futureScrollOffset = (this.mCurrentScrollOffset + amountToScroll) % this.mSelectorElementSize;
            int overshootAdjustment = this.mInitialScrollOffset - futureScrollOffset;
            if (overshootAdjustment != 0) {
                if (Math.abs(overshootAdjustment) > this.mSelectorElementSize / 2) {
                    overshootAdjustment = overshootAdjustment > 0 ? (overshootAdjustment -= this.mSelectorElementSize) : (overshootAdjustment += this.mSelectorElementSize);
                }
                this.scrollBy(0, amountToScroll += overshootAdjustment);
                return true;
            }
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getAction() & 0xFF;
        switch (action) {
            case 0: {
                this.removeAllCallbacks();
                this.mSelectedText.setVisibility(4);
                if (this.isHorizontalMode()) {
                    this.mLastDownOrMoveEventX = this.mLastDownEventX = event.getX();
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                    if (!this.mFlingScroller.isFinished()) {
                        this.mFlingScroller.forceFinished(true);
                        this.mAdjustScroller.forceFinished(true);
                        this.onScrollStateChange(0);
                    } else if (!this.mAdjustScroller.isFinished()) {
                        this.mFlingScroller.forceFinished(true);
                        this.mAdjustScroller.forceFinished(true);
                    } else if (this.mLastDownEventX < (float)this.mLeftOfSelectionDividerLeft) {
                        this.postChangeCurrentByOneFromLongPress(false, ViewConfiguration.getLongPressTimeout());
                    } else if (this.mLastDownEventX > (float)this.mRightOfSelectionDividerRight) {
                        this.postChangeCurrentByOneFromLongPress(true, ViewConfiguration.getLongPressTimeout());
                    }
                    return true;
                }
                this.mLastDownOrMoveEventY = this.mLastDownEventY = event.getY();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                if (!this.mFlingScroller.isFinished()) {
                    this.mFlingScroller.forceFinished(true);
                    this.mAdjustScroller.forceFinished(true);
                    this.onScrollStateChange(0);
                } else if (!this.mAdjustScroller.isFinished()) {
                    this.mFlingScroller.forceFinished(true);
                    this.mAdjustScroller.forceFinished(true);
                } else if (this.mLastDownEventY < (float)this.mTopSelectionDividerTop) {
                    this.postChangeCurrentByOneFromLongPress(false, ViewConfiguration.getLongPressTimeout());
                } else if (this.mLastDownEventY > (float)this.mBottomSelectionDividerBottom) {
                    this.postChangeCurrentByOneFromLongPress(true, ViewConfiguration.getLongPressTimeout());
                }
                return true;
            }
        }
        return false;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        int action = event.getAction() & 0xFF;
        switch (action) {
            case 2: {
                if (this.isHorizontalMode()) {
                    float currentMoveX = event.getX();
                    if (this.mScrollState != 1) {
                        int deltaDownX = (int)Math.abs(currentMoveX - this.mLastDownEventX);
                        if (deltaDownX > this.mTouchSlop) {
                            this.removeAllCallbacks();
                            this.onScrollStateChange(1);
                        }
                    } else {
                        int deltaMoveX = (int)(currentMoveX - this.mLastDownOrMoveEventX);
                        this.scrollBy(deltaMoveX, 0);
                        this.invalidate();
                    }
                    this.mLastDownOrMoveEventX = currentMoveX;
                    break;
                }
                float currentMoveY = event.getY();
                if (this.mScrollState != 1) {
                    int deltaDownY = (int)Math.abs(currentMoveY - this.mLastDownEventY);
                    if (deltaDownY > this.mTouchSlop) {
                        this.removeAllCallbacks();
                        this.onScrollStateChange(1);
                    }
                } else {
                    int deltaMoveY = (int)(currentMoveY - this.mLastDownOrMoveEventY);
                    this.scrollBy(0, deltaMoveY);
                    this.invalidate();
                }
                this.mLastDownOrMoveEventY = currentMoveY;
                break;
            }
            case 1: {
                this.removeChangeCurrentByOneFromLongPress();
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                if (this.isHorizontalMode()) {
                    int initialVelocity = (int)velocityTracker.getXVelocity();
                    if (Math.abs(initialVelocity) > this.mMinimumFlingVelocity) {
                        this.fling(initialVelocity);
                        this.onScrollStateChange(2);
                    } else {
                        int eventX = (int)event.getX();
                        int deltaMoveX = (int)Math.abs((float)eventX - this.mLastDownEventX);
                        if (deltaMoveX <= this.mTouchSlop) {
                            int selectorIndexOffset = eventX / this.mSelectorElementSize - this.mWheelMiddleItemIndex;
                            if (selectorIndexOffset > 0) {
                                this.changeValueByOne(true);
                            } else if (selectorIndexOffset < 0) {
                                this.changeValueByOne(false);
                            } else {
                                this.ensureScrollWheelAdjusted();
                            }
                        } else {
                            this.ensureScrollWheelAdjusted();
                        }
                        this.onScrollStateChange(0);
                    }
                } else {
                    int initialVelocity = (int)velocityTracker.getYVelocity();
                    if (Math.abs(initialVelocity) > this.mMinimumFlingVelocity) {
                        this.fling(initialVelocity);
                        this.onScrollStateChange(2);
                    } else {
                        int eventY = (int)event.getY();
                        int deltaMoveY = (int)Math.abs((float)eventY - this.mLastDownEventY);
                        if (deltaMoveY <= this.mTouchSlop) {
                            int selectorIndexOffset = eventY / this.mSelectorElementSize - this.mWheelMiddleItemIndex;
                            if (selectorIndexOffset > 0) {
                                this.changeValueByOne(true);
                            } else if (selectorIndexOffset < 0) {
                                this.changeValueByOne(false);
                            } else {
                                this.ensureScrollWheelAdjusted();
                            }
                        } else {
                            this.ensureScrollWheelAdjusted();
                        }
                        this.onScrollStateChange(0);
                    }
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return true;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        int action = event.getAction() & 0xFF;
        switch (action) {
            case 1: 
            case 3: {
                this.removeAllCallbacks();
            }
        }
        return super.dispatchTouchEvent(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        switch (keyCode) {
            case 23: 
            case 66: {
                this.removeAllCallbacks();
                return super.dispatchKeyEvent(event);
            }
            case 19: 
            case 20: {
                switch (event.getAction()) {
                    case 0: {
                        if (!(this.mWrapSelectorWheel || keyCode == 20 ? this.getValue() < this.getMaxValue() : this.getValue() > this.getMinValue())) return super.dispatchKeyEvent(event);
                        this.requestFocus();
                        this.mLastHandledDownDpadKeyCode = keyCode;
                        this.removeAllCallbacks();
                        if (!this.mFlingScroller.isFinished()) return true;
                        this.changeValueByOne(keyCode == 20);
                        return true;
                    }
                    case 1: {
                        if (this.mLastHandledDownDpadKeyCode != keyCode) return super.dispatchKeyEvent(event);
                        this.mLastHandledDownDpadKeyCode = -1;
                        return true;
                    }
                }
            }
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean dispatchTrackballEvent(MotionEvent event) {
        int action = event.getAction() & 0xFF;
        switch (action) {
            case 1: 
            case 3: {
                this.removeAllCallbacks();
            }
        }
        return super.dispatchTrackballEvent(event);
    }

    public void computeScroll() {
        Scroller scroller = this.mFlingScroller;
        if (scroller.isFinished() && (scroller = this.mAdjustScroller).isFinished()) {
            return;
        }
        scroller.computeScrollOffset();
        if (this.isHorizontalMode()) {
            int currentScrollerX = scroller.getCurrX();
            if (this.mPreviousScrollerX == 0) {
                this.mPreviousScrollerX = scroller.getStartX();
            }
            this.scrollBy(currentScrollerX - this.mPreviousScrollerX, 0);
            this.mPreviousScrollerX = currentScrollerX;
        } else {
            int currentScrollerY = scroller.getCurrY();
            if (this.mPreviousScrollerY == 0) {
                this.mPreviousScrollerY = scroller.getStartY();
            }
            this.scrollBy(0, currentScrollerY - this.mPreviousScrollerY);
            this.mPreviousScrollerY = currentScrollerY;
        }
        if (scroller.isFinished()) {
            this.onScrollerFinished(scroller);
        } else {
            this.invalidate();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mSelectedText.setEnabled(enabled);
    }

    public void scrollBy(int x, int y) {
        int gap;
        int[] selectorIndices = this.mSelectorIndices;
        if (this.isHorizontalMode()) {
            if (!this.mWrapSelectorWheel && x > 0 && selectorIndices[this.mWheelMiddleItemIndex] <= this.mMinValue) {
                this.mCurrentScrollOffset = this.mInitialScrollOffset;
                return;
            }
            if (!this.mWrapSelectorWheel && x < 0 && selectorIndices[this.mWheelMiddleItemIndex] >= this.mMaxValue) {
                this.mCurrentScrollOffset = this.mInitialScrollOffset;
                return;
            }
            this.mCurrentScrollOffset += x;
            gap = this.mSelectorTextGapWidth;
        } else {
            if (!this.mWrapSelectorWheel && y > 0 && selectorIndices[this.mWheelMiddleItemIndex] <= this.mMinValue) {
                this.mCurrentScrollOffset = this.mInitialScrollOffset;
                return;
            }
            if (!this.mWrapSelectorWheel && y < 0 && selectorIndices[this.mWheelMiddleItemIndex] >= this.mMaxValue) {
                this.mCurrentScrollOffset = this.mInitialScrollOffset;
                return;
            }
            this.mCurrentScrollOffset += y;
            gap = this.mSelectorTextGapHeight;
        }
        while (this.mCurrentScrollOffset - this.mInitialScrollOffset > gap) {
            this.mCurrentScrollOffset -= this.mSelectorElementSize;
            this.decrementSelectorIndices(selectorIndices);
            this.setValueInternal(selectorIndices[this.mWheelMiddleItemIndex], true);
            if (this.mWrapSelectorWheel || selectorIndices[this.mWheelMiddleItemIndex] >= this.mMinValue) continue;
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
        }
        while (this.mCurrentScrollOffset - this.mInitialScrollOffset < -gap) {
            this.mCurrentScrollOffset += this.mSelectorElementSize;
            this.incrementSelectorIndices(selectorIndices);
            this.setValueInternal(selectorIndices[this.mWheelMiddleItemIndex], true);
            if (this.mWrapSelectorWheel || selectorIndices[this.mWheelMiddleItemIndex] <= this.mMaxValue) continue;
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
        }
    }

    public void setOnValueChangedListener(OnValueChangeListener onValueChangedListener) {
        this.mOnValueChangeListener = onValueChangedListener;
    }

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }

    public void setFormatter(Formatter formatter) {
        if (formatter == this.mFormatter) {
            return;
        }
        this.mFormatter = formatter;
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
    }

    public void setValue(int value) {
        this.setValueInternal(value, false);
    }

    private void tryComputeMaxWidth() {
        if (!this.mComputeMaxWidth) {
            return;
        }
        int maxTextWidth = 0;
        if (this.mDisplayedValues == null) {
            float maxDigitWidth = 0.0f;
            for (int i = 0; i <= 9; ++i) {
                float digitWidth = this.mSelectorWheelPaint.measureText(this.formatNumberWithLocale(i));
                if (!(digitWidth > maxDigitWidth)) continue;
                maxDigitWidth = digitWidth;
            }
            int numberOfDigits = 0;
            for (int current = this.mMaxValue; current > 0; current /= 10) {
                ++numberOfDigits;
            }
            maxTextWidth = (int)((float)numberOfDigits * maxDigitWidth);
        } else {
            int valueCount = this.mDisplayedValues.length;
            for (int i = 0; i < valueCount; ++i) {
                float textWidth = this.mSelectorWheelPaint.measureText(this.mDisplayedValues[i]);
                if (!(textWidth > (float)maxTextWidth)) continue;
                maxTextWidth = (int)textWidth;
            }
        }
        if (this.mMaxWidth != (maxTextWidth += this.mSelectedText.getPaddingLeft() + this.mSelectedText.getPaddingRight())) {
            this.mMaxWidth = maxTextWidth > this.mMinWidth ? maxTextWidth : this.mMinWidth;
            this.invalidate();
        }
    }

    public boolean getWrapSelectorWheel() {
        return this.mWrapSelectorWheel;
    }

    public void setWrapSelectorWheel(boolean wrapSelectorWheel) {
        boolean wrappingAllowed;
        boolean bl = wrappingAllowed = this.mMaxValue - this.mMinValue >= this.mSelectorIndices.length;
        if ((!wrapSelectorWheel || wrappingAllowed) && wrapSelectorWheel != this.mWrapSelectorWheel) {
            this.mWrapSelectorWheel = wrapSelectorWheel;
        }
    }

    public void setOnLongPressUpdateInterval(long intervalMillis) {
        this.mLongPressUpdateInterval = intervalMillis;
    }

    public int getValue() {
        return this.mValue;
    }

    public int getMinValue() {
        return this.mMinValue;
    }

    public void setMinValue(int minValue) {
        this.mMinValue = minValue;
        if (this.mMinValue > this.mValue) {
            this.mValue = this.mMinValue;
        }
        boolean wrapSelectorWheel = this.mMaxValue - this.mMinValue > this.mSelectorIndices.length;
        this.setWrapSelectorWheel(wrapSelectorWheel);
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
        this.tryComputeMaxWidth();
        this.invalidate();
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(int maxValue) {
        if (maxValue < 0) {
            throw new IllegalArgumentException("maxValue must be >= 0");
        }
        this.mMaxValue = maxValue;
        if (this.mMaxValue < this.mValue) {
            this.mValue = this.mMaxValue;
        }
        boolean wrapSelectorWheel = this.mMaxValue - this.mMinValue > this.mSelectorIndices.length;
        this.setWrapSelectorWheel(wrapSelectorWheel);
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
        this.tryComputeMaxWidth();
        this.invalidate();
    }

    public String[] getDisplayedValues() {
        return this.mDisplayedValues;
    }

    public void setDisplayedValues(String[] displayedValues) {
        if (this.mDisplayedValues == displayedValues) {
            return;
        }
        this.mDisplayedValues = displayedValues;
        if (this.mDisplayedValues != null) {
            this.mSelectedText.setRawInputType(524289);
        } else {
            this.mSelectedText.setRawInputType(2);
        }
        this.updateInputTextView();
        this.initializeSelectorWheelIndices();
        this.tryComputeMaxWidth();
    }

    protected float getTopFadingEdgeStrength() {
        return this.isHorizontalMode() ? 0.0f : 0.9f;
    }

    protected float getBottomFadingEdgeStrength() {
        return this.isHorizontalMode() ? 0.0f : 0.9f;
    }

    protected float getLeftFadingEdgeStrength() {
        return this.isHorizontalMode() ? 0.9f : 0.0f;
    }

    protected float getRightFadingEdgeStrength() {
        return this.isHorizontalMode() ? 0.9f : 0.0f;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeAllCallbacks();
    }

    protected void onDraw(Canvas canvas) {
        float y;
        float x;
        if (this.isHorizontalMode()) {
            x = this.mCurrentScrollOffset;
            y = this.mSelectedText.getBaseline() + this.mSelectedText.getTop();
        } else {
            x = (this.getRight() - this.getLeft()) / 2;
            y = this.mCurrentScrollOffset;
        }
        int[] selectorIndices = this.mSelectorIndices;
        for (int i = 0; i < selectorIndices.length; ++i) {
            if (i == this.mWheelMiddleItemIndex) {
                this.mSelectorWheelPaint.setColor(this.mSelectedTextColor);
            } else {
                this.mSelectorWheelPaint.setColor(this.mTextColor);
            }
            int selectorIndex = selectorIndices[i];
            String scrollSelectorValue = (String)this.mSelectorIndexToStringCache.get(selectorIndex);
            if (i != this.mWheelMiddleItemIndex || this.mSelectedText.getVisibility() != 0) {
                canvas.drawText(scrollSelectorValue, x, y, this.mSelectorWheelPaint);
            }
            if (this.isHorizontalMode()) {
                x += (float)this.mSelectorElementSize;
                continue;
            }
            y += (float)this.mSelectorElementSize;
        }
        if (this.mSelectionDivider != null) {
            if (this.isHorizontalMode()) {
                int leftOfLeftDivider = this.mLeftOfSelectionDividerLeft;
                int rightOfLeftDivider = leftOfLeftDivider + this.mSelectionDividerThickness;
                this.mSelectionDivider.setBounds(leftOfLeftDivider, 0, rightOfLeftDivider, this.getBottom());
                this.mSelectionDivider.draw(canvas);
                int rightOfRightDivider = this.mRightOfSelectionDividerRight;
                int leftOfRightDivider = rightOfRightDivider - this.mSelectionDividerThickness;
                this.mSelectionDivider.setBounds(leftOfRightDivider, 0, rightOfRightDivider, this.getBottom());
                this.mSelectionDivider.draw(canvas);
            } else {
                int topOfTopDivider = this.mTopSelectionDividerTop;
                int bottomOfTopDivider = topOfTopDivider + this.mSelectionDividerThickness;
                this.mSelectionDivider.setBounds(0, topOfTopDivider, this.getRight(), bottomOfTopDivider);
                this.mSelectionDivider.draw(canvas);
                int bottomOfBottomDivider = this.mBottomSelectionDividerBottom;
                int topOfBottomDivider = bottomOfBottomDivider - this.mSelectionDividerThickness;
                this.mSelectionDivider.setBounds(0, topOfBottomDivider, this.getRight(), bottomOfBottomDivider);
                this.mSelectionDivider.draw(canvas);
            }
        }
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)NumberPicker.class.getName());
        event.setScrollable(true);
        int scroll = (this.mMinValue + this.mValue) * this.mSelectorElementSize;
        int maxScroll = (this.mMaxValue - this.mMinValue) * this.mSelectorElementSize;
        if (this.isHorizontalMode()) {
            event.setScrollX(scroll);
            event.setMaxScrollX(maxScroll);
        } else {
            event.setScrollY(scroll);
            event.setMaxScrollY(maxScroll);
        }
    }

    private int makeMeasureSpec(int measureSpec, int maxSize) {
        if (maxSize == -1) {
            return measureSpec;
        }
        int size = View.MeasureSpec.getSize((int)measureSpec);
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        switch (mode) {
            case 0x40000000: {
                return measureSpec;
            }
            case -2147483648: {
                return View.MeasureSpec.makeMeasureSpec((int)Math.min(size, maxSize), (int)0x40000000);
            }
            case 0: {
                return View.MeasureSpec.makeMeasureSpec((int)maxSize, (int)0x40000000);
            }
        }
        throw new IllegalArgumentException("Unknown measure mode: " + mode);
    }

    private int resolveSizeAndStateRespectingMinSize(int minSize, int measuredSize, int measureSpec) {
        if (minSize != -1) {
            int desiredWidth = Math.max(minSize, measuredSize);
            return NumberPicker.resolveSizeAndState(desiredWidth, measureSpec, 0);
        }
        return measuredSize;
    }

    public static int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
        int result = size;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: {
                if (specSize < size) {
                    result = specSize | 0x1000000;
                    break;
                }
                result = size;
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result | childMeasuredState & 0xFF000000;
    }

    private void initializeSelectorWheelIndices() {
        this.mSelectorIndexToStringCache.clear();
        int[] selectorIndices = this.mSelectorIndices;
        int current = this.getValue();
        for (int i = 0; i < this.mSelectorIndices.length; ++i) {
            int selectorIndex = current + (i - this.mWheelMiddleItemIndex);
            if (this.mWrapSelectorWheel) {
                selectorIndex = this.getWrappedSelectorIndex(selectorIndex);
            }
            selectorIndices[i] = selectorIndex;
            this.ensureCachedScrollSelectorValue(selectorIndices[i]);
        }
    }

    private void setValueInternal(int current, boolean notifyChange) {
        if (this.mValue == current) {
            return;
        }
        if (this.mWrapSelectorWheel) {
            current = this.getWrappedSelectorIndex(current);
        } else {
            current = Math.max(current, this.mMinValue);
            current = Math.min(current, this.mMaxValue);
        }
        int previous = this.mValue;
        this.mValue = current;
        this.updateInputTextView();
        if (notifyChange) {
            this.notifyChange(previous, current);
        }
        this.initializeSelectorWheelIndices();
        this.invalidate();
    }

    private void changeValueByOne(boolean increment) {
        this.mSelectedText.setVisibility(4);
        if (!this.moveToFinalScrollerPosition(this.mFlingScroller)) {
            this.moveToFinalScrollerPosition(this.mAdjustScroller);
        }
        if (this.isHorizontalMode()) {
            this.mPreviousScrollerX = 0;
            if (increment) {
                this.mFlingScroller.startScroll(0, 0, -this.mSelectorElementSize, 0, 300);
            } else {
                this.mFlingScroller.startScroll(0, 0, this.mSelectorElementSize, 0, 300);
            }
        } else {
            this.mPreviousScrollerY = 0;
            if (increment) {
                this.mFlingScroller.startScroll(0, 0, 0, -this.mSelectorElementSize, 300);
            } else {
                this.mFlingScroller.startScroll(0, 0, 0, this.mSelectorElementSize, 300);
            }
        }
        this.invalidate();
    }

    private void initializeSelectorWheel() {
        int editTextTextPosition;
        this.initializeSelectorWheelIndices();
        int[] selectorIndices = this.mSelectorIndices;
        int totalTextSize = selectorIndices.length * (int)this.mTextSize;
        float textGapCount = selectorIndices.length;
        if (this.isHorizontalMode()) {
            float totalTextGapWidth = this.getRight() - this.getLeft() - totalTextSize;
            this.mSelectorTextGapWidth = (int)(totalTextGapWidth / textGapCount + 0.5f);
            this.mSelectorElementSize = (int)this.mTextSize + this.mSelectorTextGapWidth;
            editTextTextPosition = this.mSelectedText.getRight() / 2;
        } else {
            float totalTextGapHeight = this.getBottom() - this.getTop() - totalTextSize;
            this.mSelectorTextGapHeight = (int)(totalTextGapHeight / textGapCount + 0.5f);
            this.mSelectorElementSize = (int)this.mTextSize + this.mSelectorTextGapHeight;
            editTextTextPosition = this.mSelectedText.getBaseline() + this.mSelectedText.getTop();
        }
        this.mCurrentScrollOffset = this.mInitialScrollOffset = editTextTextPosition - this.mSelectorElementSize * this.mWheelMiddleItemIndex;
        this.updateInputTextView();
    }

    private void initializeFadingEdges() {
        if (this.isHorizontalMode()) {
            this.setHorizontalFadingEdgeEnabled(true);
            this.setFadingEdgeLength((this.getRight() - this.getLeft() - (int)this.mTextSize) / 2);
        } else {
            this.setVerticalFadingEdgeEnabled(true);
            this.setFadingEdgeLength((this.getBottom() - this.getTop() - (int)this.mTextSize) / 2);
        }
    }

    private void onScrollerFinished(Scroller scroller) {
        if (scroller == this.mFlingScroller) {
            if (!this.ensureScrollWheelAdjusted()) {
                this.updateInputTextView();
            }
            this.onScrollStateChange(0);
        } else if (this.mScrollState != 1) {
            this.updateInputTextView();
        }
    }

    private void onScrollStateChange(int scrollState) {
        if (this.mScrollState == scrollState) {
            return;
        }
        this.mScrollState = scrollState;
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChange(this, scrollState);
        }
    }

    private void fling(int velocity) {
        if (this.isHorizontalMode()) {
            this.mPreviousScrollerX = 0;
            if (velocity > 0) {
                this.mFlingScroller.fling(0, 0, velocity, 0, 0, Integer.MAX_VALUE, 0, 0);
            } else {
                this.mFlingScroller.fling(Integer.MAX_VALUE, 0, velocity, 0, 0, Integer.MAX_VALUE, 0, 0);
            }
        } else {
            this.mPreviousScrollerY = 0;
            if (velocity > 0) {
                this.mFlingScroller.fling(0, 0, 0, velocity, 0, 0, 0, Integer.MAX_VALUE);
            } else {
                this.mFlingScroller.fling(0, Integer.MAX_VALUE, 0, velocity, 0, 0, 0, Integer.MAX_VALUE);
            }
        }
        this.invalidate();
    }

    private int getWrappedSelectorIndex(int selectorIndex) {
        if (selectorIndex > this.mMaxValue) {
            return this.mMinValue + (selectorIndex - this.mMaxValue) % (this.mMaxValue - this.mMinValue) - 1;
        }
        if (selectorIndex < this.mMinValue) {
            return this.mMaxValue - (this.mMinValue - selectorIndex) % (this.mMaxValue - this.mMinValue) + 1;
        }
        return selectorIndex;
    }

    private void incrementSelectorIndices(int[] selectorIndices) {
        for (int i = 0; i < selectorIndices.length - 1; ++i) {
            selectorIndices[i] = selectorIndices[i + 1];
        }
        int nextScrollSelectorIndex = selectorIndices[selectorIndices.length - 2] + 1;
        if (this.mWrapSelectorWheel && nextScrollSelectorIndex > this.mMaxValue) {
            nextScrollSelectorIndex = this.mMinValue;
        }
        selectorIndices[selectorIndices.length - 1] = nextScrollSelectorIndex;
        this.ensureCachedScrollSelectorValue(nextScrollSelectorIndex);
    }

    private void decrementSelectorIndices(int[] selectorIndices) {
        for (int i = selectorIndices.length - 1; i > 0; --i) {
            selectorIndices[i] = selectorIndices[i - 1];
        }
        int nextScrollSelectorIndex = selectorIndices[1] - 1;
        if (this.mWrapSelectorWheel && nextScrollSelectorIndex < this.mMinValue) {
            nextScrollSelectorIndex = this.mMaxValue;
        }
        selectorIndices[0] = nextScrollSelectorIndex;
        this.ensureCachedScrollSelectorValue(nextScrollSelectorIndex);
    }

    private void ensureCachedScrollSelectorValue(int selectorIndex) {
        SparseArray<String> cache = this.mSelectorIndexToStringCache;
        String scrollSelectorValue = (String)cache.get(selectorIndex);
        if (scrollSelectorValue != null) {
            return;
        }
        if (selectorIndex < this.mMinValue || selectorIndex > this.mMaxValue) {
            scrollSelectorValue = "";
        } else if (this.mDisplayedValues != null) {
            int displayedValueIndex = selectorIndex - this.mMinValue;
            scrollSelectorValue = this.mDisplayedValues[displayedValueIndex];
        } else {
            scrollSelectorValue = this.formatNumber(selectorIndex);
        }
        cache.put(selectorIndex, (Object)scrollSelectorValue);
    }

    private String formatNumber(int value) {
        return this.mFormatter != null ? this.mFormatter.format(value) : this.formatNumberWithLocale(value);
    }

    private boolean updateInputTextView() {
        String text;
        String string = text = this.mDisplayedValues == null ? this.formatNumber(this.mValue) : this.mDisplayedValues[this.mValue - this.mMinValue];
        if (!TextUtils.isEmpty((CharSequence)text) && !text.equals(this.mSelectedText.getText().toString())) {
            this.mSelectedText.setText((CharSequence)text);
            return true;
        }
        return false;
    }

    private void notifyChange(int previous, int current) {
        if (this.mOnValueChangeListener != null) {
            this.mOnValueChangeListener.onValueChange(this, previous, this.mValue);
        }
    }

    private void postChangeCurrentByOneFromLongPress(boolean increment, long delayMillis) {
        if (this.mChangeCurrentByOneFromLongPressCommand == null) {
            this.mChangeCurrentByOneFromLongPressCommand = new ChangeCurrentByOneFromLongPressCommand();
        } else {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
        this.mChangeCurrentByOneFromLongPressCommand.setStep(increment);
        this.postDelayed(this.mChangeCurrentByOneFromLongPressCommand, delayMillis);
    }

    private void removeChangeCurrentByOneFromLongPress() {
        if (this.mChangeCurrentByOneFromLongPressCommand != null) {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
    }

    private void removeAllCallbacks() {
        if (this.mChangeCurrentByOneFromLongPressCommand != null) {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
        if (this.mSetSelectionCommand != null) {
            this.removeCallbacks(this.mSetSelectionCommand);
        }
    }

    private int getSelectedPos(String value) {
        if (this.mDisplayedValues == null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            for (int i = 0; i < this.mDisplayedValues.length; ++i) {
                value = value.toLowerCase(Locale.getDefault());
                if (!this.mDisplayedValues[i].toLowerCase(Locale.getDefault()).startsWith(value)) continue;
                return this.mMinValue + i;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.mMinValue;
    }

    private void postSetSelectionCommand(int selectionStart, int selectionEnd) {
        if (this.mSetSelectionCommand == null) {
            this.mSetSelectionCommand = new SetSelectionCommand();
        } else {
            this.removeCallbacks(this.mSetSelectionCommand);
        }
        this.mSetSelectionCommand.mSelectionStart = selectionStart;
        this.mSetSelectionCommand.mSelectionEnd = selectionEnd;
        this.post(this.mSetSelectionCommand);
    }

    private boolean ensureScrollWheelAdjusted() {
        int delta = this.mInitialScrollOffset - this.mCurrentScrollOffset;
        if (delta != 0) {
            if (Math.abs(delta) > this.mSelectorElementSize / 2) {
                delta += delta > 0 ? -this.mSelectorElementSize : this.mSelectorElementSize;
            }
            if (this.isHorizontalMode()) {
                this.mPreviousScrollerX = 0;
                this.mAdjustScroller.startScroll(0, 0, delta, 0, 800);
            } else {
                this.mPreviousScrollerY = 0;
                this.mAdjustScroller.startScroll(0, 0, 0, delta, 800);
            }
            this.invalidate();
            return true;
        }
        return false;
    }

    private String formatNumberWithLocale(int value) {
        return String.format(Locale.getDefault(), "%d", value);
    }

    private void setWidthAndHeight() {
        if (this.isHorizontalMode()) {
            this.mMinHeight = -1;
            this.mMaxHeight = (int)this.dpToPx(64.0f);
            this.mMinWidth = (int)this.dpToPx(180.0f);
            this.mMaxWidth = -1;
        } else {
            this.mMinHeight = -1;
            this.mMaxHeight = (int)this.dpToPx(180.0f);
            this.mMinWidth = (int)this.dpToPx(64.0f);
            this.mMaxWidth = -1;
        }
    }

    public void setDividerColor(@ColorInt int color) {
        this.mSelectionDividerColor = color;
        this.mSelectionDivider = new ColorDrawable(color);
    }

    public void setDividerColorResource(@ColorRes int colorId) {
        this.setDividerColor(ContextCompat.getColor((Context)this.mContext, (int)colorId));
    }

    public void setDividerDistance(int distance) {
        this.mSelectionDividersDistance = (int)this.dpToPx(distance);
    }

    public void setDividerThickness(int thickness) {
        this.mSelectionDividerThickness = (int)this.dpToPx(thickness);
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
        this.setWidthAndHeight();
    }

    public void setWheelItemCount(int count) {
        this.mWheelItemCount = count;
        this.mWheelMiddleItemIndex = this.mWheelItemCount / 2;
        this.mSelectorIndices = new int[this.mWheelItemCount];
    }

    public void setFormatter(String formatter) {
        if (TextUtils.isEmpty((CharSequence)formatter)) {
            return;
        }
        this.setFormatter(this.stringToFormatter(formatter));
    }

    public void setFormatter(@StringRes int stringId) {
        this.setFormatter(this.getResources().getString(stringId));
    }

    public void setSelectedTextColor(@ColorInt int color) {
        this.mSelectedTextColor = color;
        this.mSelectedText.setTextColor(this.mSelectedTextColor);
    }

    public void setSelectedTextColorResource(@ColorRes int colorId) {
        this.setSelectedTextColor(ContextCompat.getColor((Context)this.mContext, (int)colorId));
    }

    public void setTextColor(@ColorInt int color) {
        this.mTextColor = color;
        this.mSelectorWheelPaint.setColor(this.mTextColor);
    }

    public void setTextColorResource(@ColorRes int colorId) {
        this.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)colorId));
    }

    public void setTextSize(float textSize) {
        this.mTextSize = textSize;
        this.mSelectedText.setTextSize(this.pxToSp(this.mTextSize));
        this.mSelectorWheelPaint.setTextSize(this.mTextSize);
    }

    public void setTextSize(@DimenRes int dimenId) {
        this.setTextSize(this.getResources().getDimension(dimenId));
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
        if (this.mTypeface != null) {
            this.mSelectedText.setTypeface(this.mTypeface);
            this.mSelectorWheelPaint.setTypeface(this.mTypeface);
        } else {
            this.mSelectedText.setTypeface(Typeface.MONOSPACE);
            this.mSelectorWheelPaint.setTypeface(Typeface.MONOSPACE);
        }
    }

    public void setTypeface(String string, int style) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.setTypeface(Typeface.create((String)string, (int)style));
    }

    public void setTypeface(String string) {
        this.setTypeface(string, 0);
    }

    public void setTypeface(@StringRes int stringId, int style) {
        this.setTypeface(this.getResources().getString(stringId), style);
    }

    public void setTypeface(@StringRes int stringId) {
        this.setTypeface(stringId, 0);
    }

    private Formatter stringToFormatter(final String formatter) {
        if (TextUtils.isEmpty((CharSequence)formatter)) {
            return null;
        }
        return new Formatter(){

            @Override
            public String format(int i) {
                return String.format(Locale.getDefault(), formatter, i);
            }
        };
    }

    private float dpToPx(float dp) {
        return dp * this.getResources().getDisplayMetrics().density;
    }

    private float pxToDp(float px) {
        return px / this.getResources().getDisplayMetrics().density;
    }

    private float spToPx(float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private float pxToSp(float px) {
        return px / this.getResources().getDisplayMetrics().scaledDensity;
    }

    public boolean isHorizontalMode() {
        return this.mOrientation == 0;
    }

    public int getDividerColor() {
        return this.mSelectionDividerColor;
    }

    public float getDividerDistance() {
        return this.pxToDp(this.mSelectionDividersDistance);
    }

    public float getDividerThickness() {
        return this.pxToDp(this.mSelectionDividerThickness);
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getWheelItemCount() {
        return this.mWheelItemCount;
    }

    public Formatter getFormatter() {
        return this.mFormatter;
    }

    public int getSelectedTextColor() {
        return this.mSelectedTextColor;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public float getTextSize() {
        return this.spToPx(this.mTextSize);
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    class ChangeCurrentByOneFromLongPressCommand
    implements Runnable {
        private boolean mIncrement;

        ChangeCurrentByOneFromLongPressCommand() {
        }

        private void setStep(boolean increment) {
            this.mIncrement = increment;
        }

        @Override
        public void run() {
            NumberPicker.this.changeValueByOne(this.mIncrement);
            NumberPicker.this.postDelayed(this, NumberPicker.this.mLongPressUpdateInterval);
        }
    }

    class SetSelectionCommand
    implements Runnable {
        private int mSelectionStart;
        private int mSelectionEnd;

        SetSelectionCommand() {
        }

        @Override
        public void run() {
            NumberPicker.this.mSelectedText.setSelection(this.mSelectionStart, this.mSelectionEnd);
        }
    }

    class InputTextFilter
    extends NumberKeyListener {
        InputTextFilter() {
        }

        public int getInputType() {
            return 1;
        }

        protected char[] getAcceptedChars() {
            return DIGIT_CHARACTERS;
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (NumberPicker.this.mDisplayedValues == null) {
                String result;
                CharSequence filtered = super.filter(source, start, end, dest, dstart, dend);
                if (filtered == null) {
                    filtered = source.subSequence(start, end);
                }
                if ("".equals(result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length()))) {
                    return result;
                }
                int val = NumberPicker.this.getSelectedPos(result);
                if (val > NumberPicker.this.mMaxValue) {
                    return "";
                }
                return filtered;
            }
            String filtered = String.valueOf(source.subSequence(start, end));
            if (TextUtils.isEmpty((CharSequence)filtered)) {
                return "";
            }
            String result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length());
            String str = String.valueOf(result).toLowerCase(Locale.getDefault());
            for (String val : NumberPicker.this.mDisplayedValues) {
                String valLowerCase = val.toLowerCase(Locale.getDefault());
                if (!valLowerCase.startsWith(str)) continue;
                NumberPicker.this.postSetSelectionCommand(result.length(), val.length());
                return val.subSequence(dstart, val.length());
            }
            return "";
        }
    }

    public static interface Formatter {
        public String format(int var1);
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChange(NumberPicker var1, int var2);
    }

    public static interface OnValueChangeListener {
        public void onValueChange(NumberPicker var1, int var2, int var3);
    }

    private static class TwoDigitFormatter
    implements Formatter {
        final StringBuilder mBuilder = new StringBuilder();
        char mZeroDigit;
        java.util.Formatter mFmt;
        final Object[] mArgs = new Object[1];

        TwoDigitFormatter() {
            Locale locale = Locale.getDefault();
            this.init(locale);
        }

        private void init(Locale locale) {
            this.mFmt = this.createFormatter(locale);
            this.mZeroDigit = TwoDigitFormatter.getZeroDigit(locale);
        }

        @Override
        public String format(int value) {
            Locale currentLocale = Locale.getDefault();
            if (this.mZeroDigit != TwoDigitFormatter.getZeroDigit(currentLocale)) {
                this.init(currentLocale);
            }
            this.mArgs[0] = value;
            this.mBuilder.delete(0, this.mBuilder.length());
            this.mFmt.format("%02d", this.mArgs);
            return this.mFmt.toString();
        }

        private static char getZeroDigit(Locale locale) {
            return new DecimalFormatSymbols(locale).getZeroDigit();
        }

        private java.util.Formatter createFormatter(Locale locale) {
            return new java.util.Formatter(this.mBuilder, locale);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

