/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres.embedded;

import io.zonky.test.db.postgres.embedded.PgBinaryResolver;
import io.zonky.test.db.postgres.util.ArchUtils;
import io.zonky.test.db.postgres.util.LinuxUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPostgresBinaryResolver
implements PgBinaryResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPostgresBinaryResolver.class);
    public static final DefaultPostgresBinaryResolver INSTANCE = new DefaultPostgresBinaryResolver();

    private DefaultPostgresBinaryResolver() {
    }

    @Override
    public InputStream getPgBinary(String system, String machineHardware) throws IOException {
        Resource resource;
        String architecture = ArchUtils.normalize(machineHardware);
        String distribution = LinuxUtils.getDistributionName();
        logger.info("Detected distribution: '{}'", (Object)Optional.ofNullable(distribution).orElse("Unknown"));
        if (distribution != null) {
            resource = DefaultPostgresBinaryResolver.findPgBinary(DefaultPostgresBinaryResolver.normalize(String.format("postgres-%s-%s-%s.txz", system, architecture, distribution)));
            if (resource != null) {
                logger.info("Distribution specific postgres binaries found: {}", (Object)resource.getFilename());
                return resource.getInputStream();
            }
            logger.debug("Distribution specific postgres binaries not found");
        }
        if ((resource = DefaultPostgresBinaryResolver.findPgBinary(DefaultPostgresBinaryResolver.normalize(String.format("postgres-%s-%s.txz", system, architecture)))) != null) {
            logger.info("System specific postgres binaries found: {}", (Object)resource.getFilename());
            return resource.getInputStream();
        }
        logger.error("No postgres binaries were found, you must add an appropriate maven dependency that meets the following parameters - system: {}, architecture: {}", (Object)system, (Object)architecture);
        throw new IllegalStateException("Missing postgres binaries");
    }

    private static Resource findPgBinary(String resourceLocation) throws IOException {
        logger.trace("Searching for postgres binaries - location: '{}'", (Object)resourceLocation);
        ClassLoader classLoader = DefaultPostgresBinaryResolver.class.getClassLoader();
        ArrayList<URL> urls = Collections.list(classLoader.getResources(resourceLocation));
        if (urls.size() > 1) {
            logger.error("Detected multiple binaries of the same architecture: {}", urls);
            throw new IllegalStateException("Duplicate postgres binaries");
        }
        if (urls.size() == 1) {
            return new Resource((URL)urls.get(0));
        }
        return null;
    }

    private static String normalize(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return input;
        }
        return StringUtils.lowerCase((String)input.replace(' ', '_'));
    }

    private static class Resource {
        private final URL url;

        public Resource(URL url) {
            this.url = url;
        }

        public String getFilename() {
            return FilenameUtils.getName((String)this.url.getPath());
        }

        public InputStream getInputStream() throws IOException {
            URLConnection con = this.url.openConnection();
            try {
                return con.getInputStream();
            }
            catch (IOException ex) {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                throw ex;
            }
        }
    }
}

