/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres.embedded;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

final class ProcessOutputLogger
implements Runnable {
    private final Logger logger;
    private final Process process;
    private final BufferedReader reader;

    private ProcessOutputLogger(Logger logger, Process process) {
        this.logger = logger;
        this.process = process;
        this.reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (this.process.isAlive()) {
                try {
                    Optional.ofNullable(this.reader.readLine()).ifPresent(arg_0 -> ((Logger)this.logger).info(arg_0));
                }
                catch (IOException e) {
                    this.logger.error("while reading output", (Throwable)e);
                    try {
                        this.reader.close();
                        return;
                    }
                    catch (IOException e2) {
                        this.logger.error("caught i/o exception closing reader", (Throwable)e2);
                    }
                    return;
                }
            }
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                this.logger.error("caught i/o exception closing reader", (Throwable)e);
            }
        }
    }

    static void logOutput(Logger logger, Process process, String processName) {
        String threadName = (StringUtils.isNotBlank((CharSequence)processName) ? processName : "unknown") + ":" + ProcessOutputLogger.processId(process);
        Thread t = new Thread(new ProcessOutputLogger(logger, process));
        t.setName(threadName);
        t.start();
    }

    private static String processId(Process process) {
        try {
            return String.format("pid(%s)", MethodHandles.lookup().findVirtual(Process.class, "pid", MethodType.methodType(Long.TYPE)).invoke(process));
        }
        catch (Throwable throwable) {
            try {
                Field pid = process.getClass().getDeclaredField("pid");
                pid.setAccessible(true);
                return String.format("pid(%s)", pid.getInt(process));
            }
            catch (Exception exception) {
                return String.format("id(%s)", process.hashCode());
            }
        }
    }
}

