/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres;

import io.zonky.test.db.flyway.FlywayDataSourceContext;
import io.zonky.test.db.logging.EmbeddedDatabaseReporter;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.util.concurrent.ListenableFuture;

public class FlywayEmbeddedPostgresDataSourceFactoryBean
implements FactoryBean<DataSource>,
BeanPostProcessor,
BeanFactoryAware,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(FlywayEmbeddedPostgresDataSourceFactoryBean.class);
    private final String flywayName;
    private final String dataSourceContextName;
    private BeanFactory beanFactory;
    private DataSource proxyInstance;

    public FlywayEmbeddedPostgresDataSourceFactoryBean(String flywayName, String dataSourceContextName) {
        this.flywayName = flywayName;
        this.dataSourceContextName = dataSourceContextName;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    public DataSource getObject() {
        if (this.proxyInstance == null) {
            FlywayDataSourceContext dataSourceContext = (FlywayDataSourceContext)this.beanFactory.getBean(this.dataSourceContextName, FlywayDataSourceContext.class);
            this.proxyInstance = (DataSource)ProxyFactory.getProxy(DataSource.class, (TargetSource)dataSourceContext);
        }
        return this.proxyInstance;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Flyway && StringUtils.equals((CharSequence)beanName, (CharSequence)this.flywayName)) {
            FlywayDataSourceContext dataSourceContext = (FlywayDataSourceContext)this.beanFactory.getBean(this.dataSourceContextName, FlywayDataSourceContext.class);
            ListenableFuture<DataSource> reloadFuture = dataSourceContext.reload((Flyway)bean);
            reloadFuture.addCallback(result -> EmbeddedDatabaseReporter.reportDataSource(result), error -> logger.error("Unexpected error during the initialization of embedded database", error));
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

