/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opentable.db.postgres.embedded.EmbeddedPostgres;
import io.zonky.test.db.flyway.BlockingDataSourceWrapper;
import io.zonky.test.db.provider.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.DatabaseType;
import io.zonky.test.db.provider.ProviderType;
import io.zonky.test.db.util.PropertyUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.env.Environment;

public class OpenTablePostgresDatabaseProvider
implements DatabaseProvider {
    private static final int MAX_DATABASE_CONNECTIONS = 300;
    private static final LoadingCache<DatabaseConfig, DatabaseInstance> databases = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<DatabaseConfig, DatabaseInstance>(){

        public DatabaseInstance load(DatabaseConfig config) throws IOException {
            return new DatabaseInstance(config);
        }
    });
    private final DatabaseConfig databaseConfig;
    private final ClientConfig clientConfig;

    public OpenTablePostgresDatabaseProvider(Environment environment, ObjectProvider<List<Consumer<EmbeddedPostgres.Builder>>> databaseCustomizers) {
        Map<String, String> initdbProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.initdb.properties");
        Map<String, String> configProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.server.properties");
        Map<String, String> connectProperties = PropertyUtils.extractAll(environment, "zonky.test.database.postgres.client.properties");
        List customizers = Optional.ofNullable(databaseCustomizers.getIfAvailable()).orElse(Collections.emptyList());
        this.databaseConfig = new DatabaseConfig(initdbProperties, configProperties, customizers);
        this.clientConfig = new ClientConfig(connectProperties);
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.POSTGRES;
    }

    @Override
    public ProviderType getProviderType() {
        return ProviderType.OPENTABLE;
    }

    @Override
    public DataSource getDatabase(DatabasePreparer preparer) throws SQLException {
        DatabaseInstance instance = (DatabaseInstance)databases.getUnchecked((Object)this.databaseConfig);
        DatabaseInstance.DatabaseTemplate template = instance.getTemplate(this.clientConfig, preparer);
        return template.createDatabase();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenTablePostgresDatabaseProvider that = (OpenTablePostgresDatabaseProvider)o;
        return Objects.equals(this.databaseConfig, that.databaseConfig) && Objects.equals(this.clientConfig, that.clientConfig);
    }

    public int hashCode() {
        return Objects.hash(this.databaseConfig, this.clientConfig);
    }

    private static class ClientConfig {
        private final Map<String, String> connectProperties;

        private ClientConfig(Map<String, String> connectProperties) {
            this.connectProperties = ImmutableMap.copyOf(connectProperties);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientConfig that = (ClientConfig)o;
            return Objects.equals(this.connectProperties, that.connectProperties);
        }

        public int hashCode() {
            return Objects.hash(this.connectProperties);
        }
    }

    private static class DatabaseConfig {
        private final Map<String, String> initdbProperties;
        private final Map<String, String> configProperties;
        private final List<Consumer<EmbeddedPostgres.Builder>> customizers;
        private final EmbeddedPostgres.Builder builder;

        private DatabaseConfig(Map<String, String> initdbProperties, Map<String, String> configProperties, List<Consumer<EmbeddedPostgres.Builder>> customizers) {
            this.initdbProperties = ImmutableMap.copyOf(initdbProperties);
            this.configProperties = ImmutableMap.copyOf(configProperties);
            this.customizers = ImmutableList.copyOf(customizers);
            this.builder = EmbeddedPostgres.builder();
            this.applyTo(this.builder);
        }

        public final void applyTo(EmbeddedPostgres.Builder builder) {
            builder.setPGStartupWait(Duration.ofSeconds(20L));
            this.initdbProperties.forEach((arg_0, arg_1) -> ((EmbeddedPostgres.Builder)builder).setLocaleConfig(arg_0, arg_1));
            this.configProperties.forEach((arg_0, arg_1) -> ((EmbeddedPostgres.Builder)builder).setServerConfig(arg_0, arg_1));
            this.customizers.forEach(c -> c.accept(builder));
            builder.setServerConfig("max_connections", String.valueOf(300));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabaseConfig that = (DatabaseConfig)o;
            return Objects.equals(this.builder, that.builder);
        }

        public int hashCode() {
            return Objects.hash(this.builder);
        }
    }

    protected static class DatabaseInstance {
        private final EmbeddedPostgres postgres;
        private final Semaphore semaphore;
        private final LoadingCache<TemplateKey, DatabaseTemplate> templates = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TemplateKey, DatabaseTemplate>(){

            public DatabaseTemplate load(TemplateKey key) throws Exception {
                return new DatabaseTemplate(key.config, key.preparer);
            }
        });

        private DatabaseInstance(DatabaseConfig config) throws IOException {
            EmbeddedPostgres.Builder builder = EmbeddedPostgres.builder();
            config.applyTo(builder);
            this.postgres = builder.start();
            this.semaphore = new Semaphore(300);
        }

        public DatabaseTemplate getTemplate(ClientConfig config, DatabasePreparer preparer) {
            return (DatabaseTemplate)this.templates.getUnchecked((Object)new TemplateKey(config, preparer));
        }

        protected static class TemplateKey {
            private final ClientConfig config;
            private final DatabasePreparer preparer;

            private TemplateKey(ClientConfig config, DatabasePreparer preparer) {
                this.config = config;
                this.preparer = preparer;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TemplateKey that = (TemplateKey)o;
                return Objects.equals(this.config, that.config) && Objects.equals(this.preparer, that.preparer);
            }

            public int hashCode() {
                return Objects.hash(this.config, this.preparer);
            }
        }

        protected class DatabaseTemplate {
            private final ClientConfig config;
            private final String templateName;

            private DatabaseTemplate(ClientConfig config, DatabasePreparer preparer) throws SQLException {
                this.config = config;
                this.templateName = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ENGLISH);
                this.executeStatement(String.format("CREATE DATABASE %s OWNER %s ENCODING 'utf8'", this.templateName, "postgres"));
                DataSource dataSource = this.getDatabase(this.templateName);
                preparer.prepare(dataSource);
            }

            public DataSource createDatabase() throws SQLException {
                String databaseName = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ENGLISH);
                this.executeStatement(String.format("CREATE DATABASE %s TEMPLATE %s OWNER %s ENCODING 'utf8'", databaseName, this.templateName, "postgres"));
                return this.getDatabase(databaseName);
            }

            private void executeStatement(String ddlStatement) throws SQLException {
                DataSource dataSource = this.getDatabase("postgres");
                try (Connection connection = dataSource.getConnection();
                     PreparedStatement stmt = connection.prepareStatement(ddlStatement);){
                    stmt.execute();
                }
            }

            private DataSource getDatabase(String dbName) {
                DataSource dataSource = DatabaseInstance.this.postgres.getDatabase("postgres", dbName, this.config.connectProperties);
                return new BlockingDataSourceWrapper(dataSource, DatabaseInstance.this.semaphore);
            }
        }
    }
}

