/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres;

import com.google.common.collect.ImmutableMap;
import io.zonky.test.db.AutoConfigureEmbeddedDatabase;
import io.zonky.test.db.flyway.DefaultFlywayDataSourceContext;
import io.zonky.test.db.flyway.FlywayDataSourceContext;
import io.zonky.test.db.postgres.EmptyEmbeddedPostgresDataSourceFactoryBean;
import io.zonky.test.db.postgres.FlywayEmbeddedPostgresDataSourceFactoryBean;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.Flyway;
import org.flywaydb.test.annotation.FlywayTest;
import org.flywaydb.test.annotation.FlywayTests;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.ObjectUtils;

public class EmbeddedPostgresContextCustomizerFactory
implements ContextCustomizerFactory {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedPostgresContextCustomizerFactory.class);

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        AutoConfigureEmbeddedDatabase databaseAnnotation = (AutoConfigureEmbeddedDatabase)AnnotatedElementUtils.findMergedAnnotation(testClass, AutoConfigureEmbeddedDatabase.class);
        if (databaseAnnotation != null && databaseAnnotation.type() == AutoConfigureEmbeddedDatabase.EmbeddedDatabaseType.POSTGRES && databaseAnnotation.replace() != AutoConfigureEmbeddedDatabase.Replace.NONE) {
            return new PreloadableEmbeddedPostgresContextCustomizer(databaseAnnotation);
        }
        return null;
    }

    protected static BeanDefinitionRegistry getBeanDefinitionRegistry(ApplicationContext context) {
        if (context instanceof BeanDefinitionRegistry) {
            return (BeanDefinitionRegistry)context;
        }
        if (context instanceof AbstractApplicationContext) {
            return (BeanDefinitionRegistry)((AbstractApplicationContext)context).getBeanFactory();
        }
        throw new IllegalStateException("Could not locate BeanDefinitionRegistry");
    }

    protected static BeanDefinitionHolder getDataSourceBeanDefinition(ConfigurableListableBeanFactory beanFactory, AutoConfigureEmbeddedDatabase annotation) {
        if (StringUtils.isNotBlank((CharSequence)annotation.beanName())) {
            if (beanFactory.containsBean(annotation.beanName())) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(annotation.beanName());
                return new BeanDefinitionHolder(beanDefinition, annotation.beanName());
            }
            return new BeanDefinitionHolder((BeanDefinition)new RootBeanDefinition(), annotation.beanName());
        }
        Object[] beanNames = beanFactory.getBeanNamesForType(DataSource.class);
        if (ObjectUtils.isEmpty((Object[])beanNames)) {
            throw new IllegalStateException("No DataSource beans found, embedded version will not be used, you must specify data source name - use @AutoConfigureEmbeddedDatabase(beanName = \"dataSource\") annotation");
        }
        if (beanNames.length == 1) {
            Object beanName = beanNames[0];
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
            return new BeanDefinitionHolder(beanDefinition, (String)beanName);
        }
        for (Object beanName : beanNames) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
            if (!beanDefinition.isPrimary()) continue;
            return new BeanDefinitionHolder(beanDefinition, (String)beanName);
        }
        throw new IllegalStateException("No primary DataSource found, embedded version will not be used");
    }

    protected static BeanDefinitionHolder getDataSourceContextBeanDefinition(ConfigurableListableBeanFactory beanFactory, FlywayTests annotations) {
        FlywayTest annotation = EmbeddedPostgresContextCustomizerFactory.getFlywayTestAnnotation(annotations);
        if (annotation != null && StringUtils.isNotBlank((CharSequence)annotation.flywayName())) {
            String contextBeanName = annotation.flywayName() + "DataSourceContext";
            if (beanFactory.containsBean(contextBeanName)) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(contextBeanName);
                return new BeanDefinitionHolder(beanDefinition, contextBeanName);
            }
            return null;
        }
        Object[] beanNames = beanFactory.getBeanNamesForType(FlywayDataSourceContext.class);
        if (ObjectUtils.isEmpty((Object[])beanNames)) {
            return null;
        }
        if (beanNames.length == 1) {
            Object beanName = beanNames[0];
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
            return new BeanDefinitionHolder(beanDefinition, (String)beanName);
        }
        for (Object beanName : beanNames) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
            if (!beanDefinition.isPrimary()) continue;
            return new BeanDefinitionHolder(beanDefinition, (String)beanName);
        }
        return null;
    }

    protected static BeanDefinitionHolder getFlywayBeanDefinition(ConfigurableListableBeanFactory beanFactory, FlywayTests annotations) {
        if (annotations != null && annotations.value().length > 1) {
            return null;
        }
        FlywayTest annotation = EmbeddedPostgresContextCustomizerFactory.getFlywayTestAnnotation(annotations);
        if (annotation != null && StringUtils.isNotBlank((CharSequence)annotation.flywayName())) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(annotation.flywayName());
            return new BeanDefinitionHolder(beanDefinition, annotation.flywayName());
        }
        Object[] beanNames = beanFactory.getBeanNamesForType(Flyway.class);
        if (ObjectUtils.isEmpty((Object[])beanNames)) {
            return null;
        }
        if (beanNames.length == 1) {
            Object beanName = beanNames[0];
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
            return new BeanDefinitionHolder(beanDefinition, (String)beanName);
        }
        for (Object beanName : beanNames) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition((String)beanName);
            if (!beanDefinition.isPrimary()) continue;
            return new BeanDefinitionHolder(beanDefinition, (String)beanName);
        }
        return null;
    }

    protected static FlywayTest getFlywayTestAnnotation(FlywayTests annotations) {
        return annotations != null && annotations.value().length == 1 ? annotations.value()[0] : null;
    }

    protected static FlywayTests findFlywayTestAnnotations(AnnotatedElement element) {
        FlywayTests flywayContainerAnnotation = (FlywayTests)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, FlywayTests.class);
        FlywayTest flywayAnnotation = (FlywayTest)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, FlywayTest.class);
        if (flywayContainerAnnotation != null) {
            return flywayContainerAnnotation;
        }
        if (flywayAnnotation == null) {
            return null;
        }
        ImmutableMap attributes = ImmutableMap.of((Object)"value", (Object)new FlywayTest[]{flywayAnnotation});
        return (FlywayTests)AnnotationUtils.synthesizeAnnotation((Map)attributes, FlywayTests.class, null);
    }

    protected static class PreloadableEmbeddedPostgresRegistrar
    implements BeanDefinitionRegistryPostProcessor {
        private final AutoConfigureEmbeddedDatabase databaseAnnotation;
        private final FlywayTests flywayAnnotations;

        public PreloadableEmbeddedPostgresRegistrar(AutoConfigureEmbeddedDatabase databaseAnnotation, FlywayTests flywayAnnotations) {
            this.databaseAnnotation = databaseAnnotation;
            this.flywayAnnotations = flywayAnnotations;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            ConfigurableListableBeanFactory beanFactory = (ConfigurableListableBeanFactory)registry;
            BeanDefinitionHolder dataSourceInfo = EmbeddedPostgresContextCustomizerFactory.getDataSourceBeanDefinition(beanFactory, this.databaseAnnotation);
            RootBeanDefinition dataSourceDefinition = new RootBeanDefinition();
            dataSourceDefinition.setPrimary(dataSourceInfo.getBeanDefinition().isPrimary());
            BeanDefinitionHolder flywayInfo = EmbeddedPostgresContextCustomizerFactory.getFlywayBeanDefinition(beanFactory, this.flywayAnnotations);
            if (flywayInfo == null) {
                dataSourceDefinition.setBeanClass(EmptyEmbeddedPostgresDataSourceFactoryBean.class);
            } else {
                BeanDefinitionHolder contextInfo = EmbeddedPostgresContextCustomizerFactory.getDataSourceContextBeanDefinition(beanFactory, this.flywayAnnotations);
                if (contextInfo == null) {
                    RootBeanDefinition dataSourceContextDefinition = new RootBeanDefinition();
                    dataSourceContextDefinition.setBeanClass(DefaultFlywayDataSourceContext.class);
                    registry.registerBeanDefinition("defaultDataSourceContext", (BeanDefinition)dataSourceContextDefinition);
                    contextInfo = new BeanDefinitionHolder((BeanDefinition)dataSourceContextDefinition, "defaultDataSourceContext");
                }
                dataSourceDefinition.setBeanClass(FlywayEmbeddedPostgresDataSourceFactoryBean.class);
                dataSourceDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)flywayInfo.getBeanName());
                dataSourceDefinition.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)new RuntimeBeanReference(contextInfo.getBeanName()));
            }
            logger.info("Replacing '{}' DataSource bean with embedded version", (Object)dataSourceInfo.getBeanName());
            registry.registerBeanDefinition(dataSourceInfo.getBeanName(), (BeanDefinition)dataSourceDefinition);
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }

    protected static class PreloadableEmbeddedPostgresContextCustomizer
    implements ContextCustomizer {
        private final AutoConfigureEmbeddedDatabase databaseAnnotation;

        public PreloadableEmbeddedPostgresContextCustomizer(AutoConfigureEmbeddedDatabase databaseAnnotation) {
            this.databaseAnnotation = databaseAnnotation;
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
            Class testClass = mergedConfig.getTestClass();
            FlywayTests flywayAnnotations = EmbeddedPostgresContextCustomizerFactory.findFlywayTestAnnotations(testClass);
            BeanDefinitionRegistry registry = EmbeddedPostgresContextCustomizerFactory.getBeanDefinitionRegistry((ApplicationContext)context);
            RootBeanDefinition registrarDefinition = new RootBeanDefinition();
            registrarDefinition.setBeanClass(PreloadableEmbeddedPostgresRegistrar.class);
            registrarDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)this.databaseAnnotation);
            registrarDefinition.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)flywayAnnotations);
            registry.registerBeanDefinition("preloadableEmbeddedPostgresRegistrar", (BeanDefinition)registrarDefinition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PreloadableEmbeddedPostgresContextCustomizer that = (PreloadableEmbeddedPostgresContextCustomizer)o;
            return this.databaseAnnotation.equals(that.databaseAnnotation);
        }

        public int hashCode() {
            return this.databaseAnnotation.hashCode();
        }
    }
}

