/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import io.zonky.test.db.flyway.FlywayDataSourceContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.util.ConfigurationInjectionUtils;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.Scanner;
import org.flywaydb.test.annotation.FlywayTest;
import org.flywaydb.test.annotation.FlywayTests;
import org.flywaydb.test.junit.FlywayTestExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.util.CollectionUtils;

public class OptimizedFlywayTestExecutionListener
extends FlywayTestExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(OptimizedFlywayTestExecutionListener.class);
    private int order = 3900;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
        Class testClass = testContext.getTestClass();
        FlywayTests containerAnnotation = (FlywayTests)AnnotationUtils.findAnnotation((Class)testClass, FlywayTests.class);
        if (containerAnnotation != null) {
            FlywayTest[] annotations = containerAnnotation.value();
            if (annotations.length > 1) {
                logger.warn("Optimized database loading is not supported when using multiple flyway test annotations");
            }
            for (FlywayTest annotation : annotations) {
                this.optimizedDbReset(testContext, annotation);
            }
        } else {
            FlywayTest annotation = (FlywayTest)AnnotationUtils.findAnnotation((Class)testClass, FlywayTest.class);
            this.optimizedDbReset(testContext, annotation);
        }
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        FlywayTests containerAnnotation = (FlywayTests)AnnotationUtils.findAnnotation((Method)testMethod, FlywayTests.class);
        if (containerAnnotation != null) {
            FlywayTest[] annotations = containerAnnotation.value();
            if (annotations.length > 1) {
                logger.warn("Optimized database loading is not supported when using multiple flyway test annotations");
            }
            for (FlywayTest annotation : annotations) {
                this.optimizedDbReset(testContext, annotation);
            }
        } else {
            FlywayTest annotation = (FlywayTest)AnnotationUtils.findAnnotation((Method)testMethod, FlywayTest.class);
            this.optimizedDbReset(testContext, annotation);
        }
    }

    protected synchronized void optimizedDbReset(TestContext testContext, FlywayTest annotation) throws Exception {
        FlywayDataSourceContext dataSourceContext;
        ApplicationContext applicationContext;
        Flyway flywayBean;
        if (annotation != null && annotation.invokeCleanDB() && annotation.invokeMigrateDB() && !annotation.invokeBaselineDB() && (flywayBean = (Flyway)ReflectionTestUtils.invokeMethod((Object)((Object)this), (String)"getBean", (Object[])new Object[]{applicationContext = testContext.getApplicationContext(), Flyway.class, annotation.flywayName()})) != null && (dataSourceContext = OptimizedFlywayTestExecutionListener.getDataSourceContext(applicationContext, flywayBean)) != null) {
            dataSourceContext.getTarget();
            OptimizedFlywayTestExecutionListener.prepareDataSourceContext(dataSourceContext, flywayBean, annotation);
            FlywayTest adjustedAnnotation = OptimizedFlywayTestExecutionListener.copyAnnotation(annotation, false, false, true);
            ReflectionTestUtils.invokeMethod((Object)((Object)this), (String)"dbResetWithAnnotation", (Object[])new Object[]{testContext, adjustedAnnotation});
            return;
        }
        ReflectionTestUtils.invokeMethod((Object)((Object)this), (String)"dbResetWithAnnotation", (Object[])new Object[]{testContext, annotation});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void prepareDataSourceContext(FlywayDataSourceContext dataSourceContext, Flyway flywayBean, FlywayTest annotation) throws Exception {
        if (OptimizedFlywayTestExecutionListener.isAppendable(flywayBean, annotation)) {
            dataSourceContext.reload(flywayBean).get();
        } else {
            Object[] oldLocations = flywayBean.getLocations();
            try {
                if (annotation.overrideLocations()) {
                    flywayBean.setLocations(annotation.locationsForMigrate());
                } else {
                    flywayBean.setLocations((String[])ObjectArrays.concat((Object[])oldLocations, (Object[])annotation.locationsForMigrate(), String.class));
                }
                dataSourceContext.reload(flywayBean).get();
            }
            finally {
                flywayBean.setLocations((String[])oldLocations);
            }
        }
    }

    protected static boolean isAppendable(Flyway flyway, FlywayTest annotation) {
        if (annotation.overrideLocations()) {
            return false;
        }
        if (ArrayUtils.isEmpty((Object[])annotation.locationsForMigrate())) {
            return true;
        }
        MigrationVersion testVersion = OptimizedFlywayTestExecutionListener.findFirstVersion(flyway, annotation.locationsForMigrate());
        if (testVersion == MigrationVersion.EMPTY) {
            return true;
        }
        MigrationVersion coreVersion = OptimizedFlywayTestExecutionListener.findLastVersion(flyway, flyway.getLocations());
        return coreVersion.compareTo(testVersion) < 0;
    }

    protected static MigrationVersion findFirstVersion(Flyway flyway, String ... locations) {
        CompositeMigrationResolver resolver = OptimizedFlywayTestExecutionListener.createMigrationResolver(flyway, locations);
        List migrations = resolver.resolveMigrations();
        if (CollectionUtils.isEmpty((Collection)migrations)) {
            return MigrationVersion.EMPTY;
        }
        return ((ResolvedMigration)migrations.get(0)).getVersion();
    }

    protected static MigrationVersion findLastVersion(Flyway flyway, String ... locations) {
        CompositeMigrationResolver resolver = OptimizedFlywayTestExecutionListener.createMigrationResolver(flyway, locations);
        List migrations = resolver.resolveMigrations();
        if (CollectionUtils.isEmpty((Collection)migrations)) {
            return MigrationVersion.EMPTY;
        }
        return ((ResolvedMigration)Iterables.getLast((Iterable)migrations)).getVersion();
    }

    protected static CompositeMigrationResolver createMigrationResolver(Flyway flyway, String ... locations) {
        Scanner scanner = new Scanner(flyway.getClassLoader());
        for (MigrationResolver resolver : flyway.getResolvers()) {
            ConfigurationInjectionUtils.injectFlywayConfiguration((Object)resolver, (FlywayConfiguration)flyway);
        }
        return new CompositeMigrationResolver(null, scanner, (FlywayConfiguration)flyway, new Locations(locations), OptimizedFlywayTestExecutionListener.createPlaceholderReplacer(flyway), flyway.getResolvers());
    }

    protected static PlaceholderReplacer createPlaceholderReplacer(Flyway flyway) {
        if (flyway.isPlaceholderReplacement()) {
            return new PlaceholderReplacer(flyway.getPlaceholders(), flyway.getPlaceholderPrefix(), flyway.getPlaceholderSuffix());
        }
        return PlaceholderReplacer.NO_PLACEHOLDERS;
    }

    protected static FlywayDataSourceContext getDataSourceContext(ApplicationContext context, Flyway flywayBean) {
        Map flywayBeans = context.getBeansOfType(Flyway.class);
        String flywayBeanName = flywayBeans.entrySet().stream().filter(e -> e.getValue() == flywayBean).map(Map.Entry::getKey).findFirst().orElse("default");
        try {
            return (FlywayDataSourceContext)context.getBean(flywayBeanName + "DataSourceContext", FlywayDataSourceContext.class);
        }
        catch (BeansException beansException) {
            try {
                return (FlywayDataSourceContext)context.getBean(FlywayDataSourceContext.class);
            }
            catch (BeansException beansException2) {
                return null;
            }
        }
    }

    private static FlywayTest copyAnnotation(FlywayTest annotation, boolean invokeCleanDB, boolean invokeBaselineDB, boolean invokeMigrateDB) {
        Map attributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation);
        attributes.put("invokeCleanDB", invokeCleanDB);
        attributes.put("invokeBaselineDB", invokeBaselineDB);
        attributes.put("invokeMigrateDB", invokeMigrateDB);
        return (FlywayTest)AnnotationUtils.synthesizeAnnotation((Map)attributes, FlywayTest.class, null);
    }
}

