/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITStorage;
import zipkin2.storage.StorageComponent;

public abstract class ITStrictTraceIdFalse<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
        storage.strictTraceId(false);
    }

    @Test
    protected void getTraces_128BitTraceId(TestInfo testInfo) throws Exception {
        this.getTraces_128BitTraceId(this.accept128BitTrace(this.storage, testInfo), testInfo);
    }

    @Test
    protected void getTraces_128BitTraceId_mixed(TestInfo testInfo) throws Exception {
        this.getTraces_128BitTraceId(this.acceptMixedTrace(testInfo), testInfo);
    }

    protected void getTraces_128BitTraceId(List<Span> trace, TestInfo testInfo) throws Exception {
        String testSuffix = ITStrictTraceIdFalse.testSuffix(testInfo);
        this.assertGetTracesReturns(ITStrictTraceIdFalse.requestBuilder().build(), trace);
        String frontend = TestObjects.appendSuffix(TestObjects.FRONTEND.serviceName(), testSuffix);
        String backend = TestObjects.appendSuffix(TestObjects.BACKEND.serviceName(), testSuffix);
        this.assertGetTracesReturns(ITStrictTraceIdFalse.requestBuilder().serviceName(frontend).parseAnnotationQuery("foo").build(), trace);
        this.assertGetTracesReturns(ITStrictTraceIdFalse.requestBuilder().serviceName(backend).parseAnnotationQuery("error").build(), trace);
    }

    @Test
    protected void getTrace_retrievesBy64Or128BitTraceId(TestInfo testInfo) throws Exception {
        List<Span> trace = this.accept128BitTrace(this.storage, testInfo);
        this.retrievesBy64Or128BitTraceId(trace);
    }

    @Test
    protected void getTrace_retrievesBy64Or128BitTraceId_mixed(TestInfo testInfo) throws Exception {
        List<Span> trace = this.acceptMixedTrace(testInfo);
        this.retrievesBy64Or128BitTraceId(trace);
    }

    void retrievesBy64Or128BitTraceId(List<Span> trace) throws IOException {
        String traceId = trace.stream().filter(t -> t.traceId().length() == 32).findAny().get().traceId();
        this.assertGetTraceReturns(traceId, trace);
        this.assertGetTraceReturns(traceId.substring(16), trace);
    }

    protected List<Span> accept128BitTrace(StorageComponent storage, TestInfo testInfo) throws Exception {
        String testSuffix = ITStrictTraceIdFalse.testSuffix(testInfo);
        List<Span> trace = TestObjects.newTrace(testSuffix);
        Collections.reverse(trace);
        storage.spanConsumer().accept(trace).execute();
        this.blockWhileInFlight();
        return trace;
    }

    List<Span> acceptMixedTrace(TestInfo testInfo) throws Exception {
        String testSuffix = ITStrictTraceIdFalse.testSuffix(testInfo);
        List<Span> trace = TestObjects.newTrace(testSuffix);
        String downgraded = trace.get(0).traceId().substring(16);
        for (int i = 2; i < trace.size(); ++i) {
            trace.set(i, trace.get(i).toBuilder().traceId(downgraded).build());
        }
        Collections.reverse(trace);
        this.accept(trace.toArray(new Span[0]));
        return this.sortTrace(trace);
    }

    @Test
    protected void getTraces_retrievesBy64Or128BitTraceId(TestInfo testInfo) throws Exception {
        String testSuffix = ITStrictTraceIdFalse.testSuffix(testInfo);
        Span with128BitId1 = TestObjects.spanBuilder(testSuffix).build();
        Span with64BitId1 = with128BitId1.toBuilder().traceId(with128BitId1.traceId().substring(16)).id("a").timestamp(with128BitId1.timestampAsLong() + 1000L).build();
        Span with128BitId2 = TestObjects.spanBuilder(testSuffix).build();
        Span with64BitId2 = with128BitId2.toBuilder().traceId(with128BitId2.traceId().substring(16)).id("b").timestamp(with128BitId2.timestampAsLong() + 1000L).build();
        Span with128BitId3 = TestObjects.spanBuilder(testSuffix).build();
        Span with64BitId3 = with128BitId3.toBuilder().traceId(with128BitId3.traceId().substring(16)).id("c").timestamp(with128BitId3.timestampAsLong() + 1000L).build();
        this.accept(with128BitId1, with64BitId1, with128BitId2, with64BitId2, with128BitId3, with64BitId3);
        List[] trace1And3 = new List[]{List.of(with128BitId1, with64BitId1), List.of(with128BitId3, with64BitId3)};
        this.assertGetTracesReturns(List.of(with128BitId1.traceId(), with64BitId1.traceId(), with128BitId3.traceId(), with64BitId3.traceId()), trace1And3);
        this.assertGetTracesReturns(List.of(with64BitId1.traceId(), with64BitId3.traceId()), trace1And3);
        this.assertGetTracesReturns(List.of(with128BitId1.traceId(), with128BitId3.traceId()), trace1And3);
    }
}

