/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITStorage;
import zipkin2.storage.StorageComponent;

public abstract class ITServiceAndSpanNames<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
    }

    @Test
    protected void getLocalServiceNames_includesLocalServiceName(TestInfo testInfo) throws Exception {
        String testSuffix = ITServiceAndSpanNames.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix);
        Assertions.assertThat((List)((List)this.names().getServiceNames().execute())).isEmpty();
        this.accept(clientSpan);
        Assertions.assertThat((List)((List)this.names().getServiceNames().execute())).containsOnly((Object[])new String[]{clientSpan.localServiceName()});
    }

    @Test
    protected void getLocalServiceNames_noServiceName(TestInfo testInfo) throws Exception {
        String testSuffix = ITServiceAndSpanNames.testSuffix(testInfo);
        this.accept(TestObjects.spanBuilder(testSuffix).localEndpoint(null).build());
        Assertions.assertThat((List)((List)this.names().getServiceNames().execute())).isEmpty();
    }

    @Test
    protected void getRemoteServiceNames(TestInfo testInfo) throws Exception {
        String testSuffix = ITServiceAndSpanNames.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix);
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames(clientSpan.localServiceName()).execute())).isEmpty();
        this.accept(clientSpan);
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames(clientSpan.localServiceName() + "1").execute())).isEmpty();
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames(clientSpan.localServiceName()).execute())).contains((Object[])new String[]{clientSpan.remoteServiceName()});
    }

    @Test
    protected void getRemoteServiceNames_allReturned(TestInfo testInfo) throws Exception {
        String testSuffix = ITServiceAndSpanNames.testSuffix(testInfo);
        List<Span> spans = IntStream.rangeClosed(0, 50).mapToObj(i -> {
            Object suffix = i < 10 ? "0" + i : String.valueOf(i);
            return TestObjects.spanBuilder(testSuffix).id((long)(i + 1)).remoteEndpoint(Endpoint.newBuilder().serviceName("yak" + (String)suffix + testSuffix).build()).build();
        }).collect(Collectors.toList());
        this.accept(spans);
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames(spans.get(0).localServiceName()).execute())).containsExactlyInAnyOrderElementsOf(spans.stream().map(Span::remoteServiceName)::iterator);
    }

    @Test
    protected void getRemoteServiceNames_dedupes(TestInfo testInfo) throws Exception {
        String testSuffix = ITServiceAndSpanNames.testSuffix(testInfo);
        List<Span> spans = IntStream.rangeClosed(0, 50).mapToObj(i -> TestObjects.spanBuilder(testSuffix).remoteEndpoint(TestObjects.BACKEND).build()).collect(Collectors.toList());
        this.accept(spans);
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames(spans.get(0).localServiceName()).execute())).containsExactly((Object[])new String[]{TestObjects.BACKEND.serviceName()});
    }

    @Test
    protected void getRemoteServiceNames_noRemoteServiceName(TestInfo testInfo) throws Exception {
        String testSuffix = ITServiceAndSpanNames.testSuffix(testInfo);
        Span span = TestObjects.spanBuilder(testSuffix).build();
        this.accept(span);
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames(span.localServiceName()).execute())).isEmpty();
    }

    @Test
    protected void getRemoteServiceNames_serviceNameGoesLowercase(TestInfo testInfo) throws Exception {
        String testSuffix = ITServiceAndSpanNames.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix);
        this.accept(clientSpan);
        String uppercase = clientSpan.localServiceName().toUpperCase(Locale.ROOT);
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames(uppercase).execute())).containsExactly((Object[])new String[]{clientSpan.remoteServiceName()});
    }

    @Test
    protected void getSpanNames_doesNotMapNameToRemoteServiceName(TestInfo testInfo) throws Exception {
        String testSuffix = ITServiceAndSpanNames.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix);
        this.accept(clientSpan);
        Assertions.assertThat((List)((List)this.names().getSpanNames(clientSpan.remoteServiceName()).execute())).isEmpty();
    }

    @Test
    protected void getSpanNames(TestInfo testInfo) throws Exception {
        String testSuffix = ITServiceAndSpanNames.testSuffix(testInfo);
        Span span = TestObjects.spanBuilder(testSuffix).build();
        Assertions.assertThat((List)((List)this.names().getSpanNames(span.localServiceName()).execute())).isEmpty();
        this.accept(span);
        Assertions.assertThat((List)((List)this.names().getSpanNames(span.localServiceName() + "1").execute())).isEmpty();
        Assertions.assertThat((List)((List)this.names().getSpanNames(span.localServiceName()).execute())).contains((Object[])new String[]{span.name()});
    }

    @Test
    protected void getSpanNames_allReturned(TestInfo testInfo) throws Exception {
        String testSuffix = ITServiceAndSpanNames.testSuffix(testInfo);
        List<Span> spans = IntStream.rangeClosed(0, 50).mapToObj(i -> {
            Object suffix = i < 10 ? "0" + i : String.valueOf(i);
            return TestObjects.spanBuilder(testSuffix).name("yak" + (String)suffix).build();
        }).collect(Collectors.toList());
        this.accept(spans);
        Assertions.assertThat((List)((List)this.names().getSpanNames(spans.get(0).localServiceName()).execute())).containsExactlyInAnyOrderElementsOf(spans.stream().map(Span::name)::iterator);
    }

    @Test
    protected void getSpanNames_dedupes(TestInfo testInfo) throws Exception {
        String testSuffix = ITServiceAndSpanNames.testSuffix(testInfo);
        List<Span> spans = IntStream.rangeClosed(0, 50).mapToObj(i -> TestObjects.spanBuilder(testSuffix).build()).collect(Collectors.toList());
        this.accept(spans);
        Assertions.assertThat((List)((List)this.names().getSpanNames(spans.get(0).localServiceName()).execute())).containsExactly((Object[])new String[]{spans.get(0).name()});
    }

    @Test
    protected void getSpanNames_noSpanName(TestInfo testInfo) throws Exception {
        String testSuffix = ITServiceAndSpanNames.testSuffix(testInfo);
        Span span = TestObjects.spanBuilder(testSuffix).name(null).build();
        this.accept(span);
        Assertions.assertThat((List)((List)this.names().getSpanNames(span.localServiceName()).execute())).isEmpty();
    }

    @Test
    protected void getSpanNames_serviceNameGoesLowercase(TestInfo testInfo) throws Exception {
        String testSuffix = ITServiceAndSpanNames.testSuffix(testInfo);
        Span span = TestObjects.spanBuilder(testSuffix).build();
        this.accept(span);
        String uppercase = span.localServiceName().toUpperCase(Locale.ROOT);
        Assertions.assertThat((List)((List)this.names().getSpanNames(uppercase).execute())).containsExactly((Object[])new String[]{span.name()});
    }
}

