/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import zipkin2.DependencyLink;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITStorage;
import zipkin2.storage.StorageComponent;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class ITDependenciesHeavy<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected boolean initializeStoragePerTest() {
        return true;
    }

    @Override
    protected void configureStorageForTest(StorageComponent.Builder storage) {
    }

    protected void processDependencies(List<Span> spans) throws Exception {
        this.storage.spanConsumer().accept(spans).execute();
        this.blockWhileInFlight();
    }

    @Test
    protected void manyLinks() throws Exception {
        int count = 256;
        ArrayList<Span> spans = new ArrayList<Span>(count);
        for (int i = 1; i <= count; ++i) {
            String traceId = TestObjects.newTraceId();
            Endpoint web = TestObjects.FRONTEND.toBuilder().serviceName("web-" + i).build();
            Endpoint app = TestObjects.BACKEND.toBuilder().serviceName("app-" + i).build();
            Endpoint db = TestObjects.DB.toBuilder().serviceName("db-" + i).build();
            spans.add(Span.newBuilder().traceId(traceId).id("10").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).kind(Span.Kind.CLIENT).localEndpoint(web).build());
            spans.add(Span.newBuilder().traceId(traceId).id("10").name("get").shared(true).timestamp((TestObjects.TODAY + 100L) * 1000L).duration(150000L).kind(Span.Kind.SERVER).localEndpoint(app).build());
            spans.add(Span.newBuilder().traceId(traceId).parentId("10").id("11").name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).kind(Span.Kind.CLIENT).localEndpoint(app).remoteEndpoint(db).build());
        }
        this.processDependencies(spans);
        List links = (List)this.store().getDependencies(TestObjects.endTs(spans), TestObjects.DAY).execute();
        Assertions.assertThat((List)links).hasSize(count * 2);
        Assertions.assertThat((List)links).extracting(DependencyLink::callCount).allSatisfy(callCount -> Assertions.assertThat((Long)callCount).isEqualTo(1L));
    }
}

