/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import zipkin2.TestObjects;
import zipkin2.storage.ITStorage;
import zipkin2.storage.StorageComponent;

public abstract class ITAutocompleteTags<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
        storage.autocompleteKeys(List.of("http.host"));
    }

    @Test
    protected void ignores_when_key_not_in_autocompleteTags(TestInfo testInfo) throws Exception {
        String testSuffix = ITAutocompleteTags.testSuffix(testInfo);
        this.accept(TestObjects.spanBuilder(testSuffix).putTag("http.method", "GET").build());
        Assertions.assertThat((List)((List)this.storage.autocompleteTags().getKeys().execute())).doesNotContain((Object[])new String[]{"http.method"});
        Assertions.assertThat((List)((List)this.storage.autocompleteTags().getValues("http.method").execute())).isEmpty();
    }

    @Test
    protected void getTagsAndValues(TestInfo testInfo) throws Exception {
        String testSuffix = ITAutocompleteTags.testSuffix(testInfo);
        for (int i = 0; i < 2; ++i) {
            this.accept(TestObjects.spanBuilder(testSuffix).putTag("http.method", "GET").putTag("http.host", "host1").build());
        }
        Assertions.assertThat((List)((List)this.storage.autocompleteTags().getKeys().execute())).containsOnlyOnce((Object[])new String[]{"http.host"});
        Assertions.assertThat((List)((List)this.storage.autocompleteTags().getValues("http.host").execute())).containsOnlyOnce((Object[])new String[]{"host1"});
    }
}

