/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITStorage;
import zipkin2.storage.StorageComponent;

public abstract class ITTraces<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
    }

    @Test
    protected void getTrace_returnsEmptyOnNotFound(TestInfo testInfo) throws Exception {
        String testSuffix = ITTraces.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix);
        this.assertGetTraceReturnsEmpty(clientSpan.traceId());
        this.accept(clientSpan);
        this.assertGetTraceReturns(clientSpan);
        this.assertGetTraceReturnsEmpty(clientSpan.traceId().substring(16));
    }

    @Test
    protected void getTrace_differentiatesDebugFromShared(TestInfo testInfo) throws Exception {
        String testSuffix = ITTraces.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix).toBuilder().debug(true).build();
        Span serverSpan = clientSpan.toBuilder().kind(Span.Kind.SERVER).debug(null).shared(true).build();
        this.accept(clientSpan, serverSpan);
        this.assertGetTraceReturns(clientSpan.traceId(), List.of(clientSpan, serverSpan));
    }

    @Test
    protected void getTraces_onlyReturnsTracesThatMatch(TestInfo testInfo) throws Exception {
        String testSuffix = ITTraces.testSuffix(testInfo);
        Span span1 = TestObjects.spanBuilder(testSuffix).build();
        Span span2 = TestObjects.spanBuilder(testSuffix).build();
        List<String> traceIds = List.of(span1.traceId(), TestObjects.newTraceId());
        this.assertGetTracesReturnsEmpty(traceIds);
        this.accept(span1, span2);
        this.assertGetTracesReturns(traceIds, List.of(span1));
        List<String> shortTraceIds = traceIds.stream().map(t -> t.substring(16)).collect(Collectors.toList());
        this.assertGetTracesReturnsEmpty(shortTraceIds);
    }

    @Test
    protected void getTraces_differentiatesDebugFromShared(TestInfo testInfo) throws Exception {
        String testSuffix = ITTraces.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix).toBuilder().debug(true).build();
        Span serverSpan = clientSpan.toBuilder().kind(Span.Kind.SERVER).debug(null).shared(true).build();
        this.accept(clientSpan, serverSpan);
        this.assertGetTracesReturns(List.of(clientSpan.traceId()), List.of(clientSpan, serverSpan));
    }

    @Test
    protected void getTraces_returnsEmptyOnNotFound(TestInfo testInfo) throws Exception {
        String testSuffix = ITTraces.testSuffix(testInfo);
        Span span1 = TestObjects.spanBuilder(testSuffix).build();
        Span span2 = TestObjects.spanBuilder(testSuffix).build();
        List<String> traceIds = List.of(span1.traceId(), span2.traceId());
        this.assertGetTracesReturnsEmpty(traceIds);
        this.accept(span1, span2);
        this.assertGetTracesReturns(traceIds, List.of(span1), List.of(span2));
        List<String> shortTraceIds = traceIds.stream().map(t -> t.substring(16)).collect(Collectors.toList());
        this.assertGetTracesReturnsEmpty(shortTraceIds);
    }

    @Test
    protected void getTrace_deduplicates(TestInfo testInfo) throws Exception {
        String testSuffix = ITTraces.testSuffix(testInfo);
        Span span = TestObjects.spanBuilder(testSuffix).build();
        this.accept(span);
        this.accept(span);
        this.assertGetTraceReturns(span);
    }
}

