/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestInstance;
import org.opentest4j.TestAbortedException;
import zipkin2.CheckResult;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.internal.Trace;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.ServiceAndSpanNames;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.Traces;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class ITStorage<T extends StorageComponent> {
    protected T storage;

    @BeforeAll
    void initializeStorage(TestInfo testInfo) {
        if (this.initializeStoragePerTest()) {
            return;
        }
        this.doInitializeStorage(testInfo);
    }

    @BeforeEach
    void initializeStorageForTest(TestInfo testInfo) {
        if (!this.initializeStoragePerTest()) {
            return;
        }
        this.doInitializeStorage(testInfo);
    }

    void doInitializeStorage(TestInfo testInfo) {
        StorageComponent.Builder builder = this.newStorageBuilder(testInfo);
        this.configureStorageForTest(builder);
        StorageComponent storage = builder.build();
        this.storage = storage;
        this.checkStorage();
    }

    protected void checkStorage() {
        CheckResult check = this.storage.check();
        if (!check.ok()) {
            throw new TestAbortedException("Could not connect to storage, skipping test: " + check.error().getMessage(), check.error());
        }
    }

    @AfterAll
    void closeStorage() throws Exception {
        if (this.initializeStoragePerTest()) {
            return;
        }
        this.storage.close();
    }

    @AfterEach
    void closeStorageForTest() throws Exception {
        if (!this.initializeStoragePerTest()) {
            return;
        }
        this.storage.close();
    }

    @AfterEach
    void clearStorage() throws Exception {
        this.clear();
    }

    protected boolean initializeStoragePerTest() {
        return false;
    }

    protected abstract StorageComponent.Builder newStorageBuilder(TestInfo var1);

    protected abstract void configureStorageForTest(StorageComponent.Builder var1);

    protected Traces traces() {
        return this.storage.traces();
    }

    protected SpanStore store() {
        return this.storage.spanStore();
    }

    protected ServiceAndSpanNames names() {
        return this.storage.serviceAndSpanNames();
    }

    protected final void accept(Span ... spans) throws IOException {
        this.accept(Arrays.asList(spans));
    }

    protected final void accept(List<Span> spans) throws IOException {
        int length = spans.size();
        for (int i = 0; i < length; i += 100) {
            this.storage.spanConsumer().accept(spans.subList(i, Math.min(length, i + 100))).execute();
            this.blockWhileInFlight();
        }
    }

    protected void blockWhileInFlight() {
    }

    protected abstract void clear() throws Exception;

    protected static QueryRequest.Builder requestBuilder() {
        return QueryRequest.newBuilder().endTs(TestObjects.TODAY + TestObjects.DAY).lookback(TestObjects.DAY * 2L).limit(100);
    }

    protected void assertGetTracesReturns(QueryRequest request, List<Span> ... traces) throws IOException {
        ((ListAssert)Assertions.assertThat(this.sortTraces((List)this.store().getTraces(request).execute())).usingRecursiveFieldByFieldElementComparator()).containsAll(this.sortTraces(Arrays.asList(traces)));
    }

    protected void assertGetTraceReturns(Span onlySpan) throws IOException {
        this.assertGetTraceReturns(onlySpan.traceId(), Arrays.asList(onlySpan));
    }

    protected void assertGetTraceReturns(String traceId, List<Span> trace) throws IOException {
        ((ListAssert)Assertions.assertThat(this.sortTrace((List)this.storage.traces().getTrace(traceId).execute())).usingRecursiveFieldByFieldElementComparator()).containsAll(this.sortTrace(trace));
    }

    protected void assertGetTraceReturnsEmpty(String traceId) throws IOException {
        List<Span> results = this.sortTrace((List)this.storage.traces().getTrace(traceId).execute());
        ((ListAssert)Assertions.assertThat(results).withFailMessage("Expected no traces for traceId <%s>, but received <%s>", new Object[]{traceId, results})).isEmpty();
    }

    protected void assertGetTracesReturns(List<String> traceIds, List<Span> ... traces) throws IOException {
        ((ListAssert)Assertions.assertThat(this.sortTraces((List)this.storage.traces().getTraces(traceIds).execute())).usingRecursiveFieldByFieldElementComparator()).containsAll(this.sortTraces(Arrays.asList(traces)));
    }

    protected void assertGetTracesReturnsEmpty(List<String> traceIds) throws IOException {
        List<List<Span>> results = this.sortTraces((List)this.storage.traces().getTraces(traceIds).execute());
        ((ListAssert)Assertions.assertThat(results).withFailMessage("Expected no traces for traceIds <%s>, but received <%s>", new Object[]{traceIds, results})).isEmpty();
    }

    protected void assertGetTracesReturnsCount(QueryRequest request, int traceCount) throws IOException {
        int countReturned = ((List)this.store().getTraces(request).execute()).size();
        ((AbstractIntegerAssert)Assertions.assertThat((int)countReturned).withFailMessage("Expected <%s> traces for request <%s>, but received <%s>", new Object[]{traceCount, request, countReturned})).usingRecursiveComparison().isEqualTo((Object)traceCount);
    }

    protected void assertGetTracesReturnsEmpty(QueryRequest request) throws IOException {
        List<List<Span>> results = this.sortTraces((List)this.store().getTraces(request).execute());
        ((ListAssert)Assertions.assertThat(results).withFailMessage("Expected no traces for request <%s>, but received <%s>", new Object[]{request, results})).isEmpty();
    }

    List<List<Span>> sortTraces(List<List<Span>> traces) {
        ArrayList<List<Span>> result = new ArrayList<List<Span>>();
        for (List<Span> trace : traces) {
            result.add(this.sortTrace(trace));
        }
        return result;
    }

    protected boolean returnsRawSpans() {
        return true;
    }

    protected static String testSuffix(TestInfo testInfo) {
        String result;
        if (testInfo.getTestMethod().isPresent()) {
            result = ((Method)testInfo.getTestMethod().get()).getName();
        } else {
            assert (testInfo.getTestClass().isPresent());
            result = ((Class)testInfo.getTestClass().get()).getSimpleName();
        }
        result = result.toLowerCase();
        return result.length() <= 48 ? result : result.substring(result.length() - 48);
    }

    protected List<Span> sortTrace(List<Span> trace) {
        if (!this.returnsRawSpans()) {
            trace = Trace.merge(trace);
        }
        ArrayList<Span> result = new ArrayList<Span>(trace);
        result.sort((l, r) -> {
            int name;
            int traceId = l.traceId().compareTo(r.traceId());
            if (traceId != 0) {
                return traceId;
            }
            int id = l.id().compareTo(r.id());
            if (id != 0) {
                return id;
            }
            int shared = Boolean.compare(Boolean.TRUE.equals(l.shared()), Boolean.TRUE.equals(r.shared()));
            if (shared != 0) {
                return shared;
            }
            if (l.name() != null && r.name() != null && (name = l.name().compareTo(r.name())) != 0) {
                return name;
            }
            int timestamp = Long.compare(l.timestampAsLong(), r.timestampAsLong());
            if (timestamp != 0) {
                return timestamp;
            }
            int duration = Long.compare(l.durationAsLong(), r.durationAsLong());
            if (duration != 0) {
                return duration;
            }
            throw new AssertionError((Object)("Don't use test data that results in indeterministic ordering:\nl=" + l + ", r=" + r));
        });
        return result;
    }
}

