/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import zipkin2.Annotation;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITStorage;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.StorageComponent;

public abstract class ITSpanStore<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
    }

    @Test
    protected void allShouldWorkWhenEmpty() throws Exception {
        QueryRequest.Builder q = ITSpanStore.requestBuilder().serviceName("service");
        this.assertGetTracesReturnsEmpty(q.build());
        this.assertGetTracesReturnsEmpty(q.remoteServiceName("remotey").build());
        this.assertGetTracesReturnsEmpty(q.spanName("methodcall").build());
        this.assertGetTracesReturnsEmpty(q.parseAnnotationQuery("custom").build());
        this.assertGetTracesReturnsEmpty(q.parseAnnotationQuery("BAH=BEH").build());
    }

    @Test
    protected void allShouldWorkWhenNoIndexableDataYet() throws Exception {
        this.accept(Span.newBuilder().traceId(TestObjects.newTraceId()).id("1").build());
        this.allShouldWorkWhenEmpty();
    }

    @Test
    protected void consumer_implementsCall_execute(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span span = TestObjects.spanBuilder(testSuffix).build();
        Call call = this.storage.spanConsumer().accept(Arrays.asList(span));
        this.assertGetTraceReturnsEmpty(span.traceId());
        call.execute();
        this.blockWhileInFlight();
        this.assertGetTraceReturns(span);
        Assertions.assertThatThrownBy(() -> ((Call)call).execute()).isInstanceOf(IllegalStateException.class);
        call.clone().execute();
    }

    @Test
    protected void consumer_implementsCall_submit(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span span = TestObjects.spanBuilder(testSuffix).build();
        Call call = this.storage.spanConsumer().accept(Arrays.asList(span));
        this.assertGetTraceReturnsEmpty(span.traceId());
        final CountDownLatch latch = new CountDownLatch(1);
        Callback<Void> callback = new Callback<Void>(){

            public void onSuccess(Void value) {
                latch.countDown();
            }

            public void onError(Throwable t) {
                latch.countDown();
            }
        };
        call.enqueue((Callback)callback);
        latch.await();
        this.blockWhileInFlight();
        this.assertGetTraceReturns(span);
        Assertions.assertThatThrownBy(() -> ITSpanStore.lambda$consumer_implementsCall_submit$0(call, (Callback)callback)).isInstanceOf(IllegalStateException.class);
        call.clone().execute();
    }

    @Test
    protected void getTraces_groupsTracesTogether(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span traceASpan1 = TestObjects.spanBuilder(testSuffix).timestamp((TestObjects.TODAY + 1L) * 1000L).build();
        Span traceASpan2 = traceASpan1.toBuilder().id("2").timestamp((TestObjects.TODAY + 2L) * 1000L).build();
        String traceId2 = TestObjects.newTraceId();
        Span traceBSpan1 = traceASpan1.toBuilder().traceId(traceId2).build();
        Span traceBSpan2 = traceASpan2.toBuilder().traceId(traceId2).build();
        this.accept(traceASpan1, traceBSpan1, traceASpan2, traceBSpan2);
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().build(), Arrays.asList(traceASpan1, traceASpan2), Arrays.asList(traceBSpan1, traceBSpan2));
    }

    @Test
    protected void getTraces_considersBitsAbove64bit(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        String traceId = TestObjects.newTraceId();
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Span span1 = Span.newBuilder().traceId(traceId.substring(16)).id("1").putTag("foo", "1").timestamp(TestObjects.TODAY * 1000L).localEndpoint(frontend).build();
        Span span2 = span1.toBuilder().traceId(traceId).putTag("foo", "2").build();
        Span span3 = span1.toBuilder().traceId("1" + span1.traceId()).putTag("foo", "3").build();
        this.accept(span1, span2, span3);
        for (Span span : Arrays.asList(span1, span2, span3)) {
            this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(frontend.serviceName()).parseAnnotationQuery("foo=" + (String)span.tags().get("foo")).build(), Arrays.asList(span));
        }
    }

    @Test
    protected void getTraces_filteringMatchesMostRecentTraces(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        List endpoints = IntStream.rangeClosed(1, 10).mapToObj(i -> Endpoint.newBuilder().serviceName(TestObjects.appendSuffix("service" + i, testSuffix)).ip("127.0.0.1").build()).collect(Collectors.toList());
        long gapBetweenSpans = 100L;
        Span[] earlySpans = (Span[])IntStream.rangeClosed(1, 10).mapToObj(i -> Span.newBuilder().name("early").traceId(TestObjects.newTraceId()).id(Integer.toHexString(i)).timestamp((TestObjects.TODAY - (long)i) * 1000L).duration(1L).localEndpoint((Endpoint)endpoints.get(i - 1)).build()).toArray(Span[]::new);
        Span[] lateSpans = (Span[])IntStream.rangeClosed(1, 10).mapToObj(i -> Span.newBuilder().name("late").traceId(TestObjects.newTraceId()).id(Integer.toHexString(i + 10)).timestamp((TestObjects.TODAY + gapBetweenSpans - (long)i) * 1000L).duration(1L).localEndpoint((Endpoint)endpoints.get(i - 1)).build()).toArray(Span[]::new);
        this.accept(earlySpans);
        this.accept(lateSpans);
        List[] earlyTraces = (List[])Stream.of(earlySpans).map(Collections::singletonList).toArray(List[]::new);
        List[] lateTraces = (List[])Stream.of(lateSpans).map(Collections::singletonList).toArray(List[]::new);
        this.assertGetTracesReturnsCount(ITSpanStore.requestBuilder().build(), 20);
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().limit(10).build(), lateTraces);
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + gapBetweenSpans).lookback(gapBetweenSpans).build(), lateTraces);
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY).build(), earlyTraces);
    }

    @Test
    protected void getTraces_serviceNames(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        this.getTraces_serviceNames(TestObjects.newClientSpan(testSuffix));
    }

    void getTraces_serviceNames(Span clientSpan) throws Exception {
        this.accept(clientSpan);
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().serviceName(clientSpan.localServiceName() + "1").build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(clientSpan.localServiceName()).build(), Arrays.asList(clientSpan));
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().serviceName(clientSpan.localServiceName()).remoteServiceName(clientSpan.remoteServiceName() + "1").build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(clientSpan.localServiceName()).remoteServiceName(clientSpan.remoteServiceName()).build(), Arrays.asList(clientSpan));
    }

    @Test
    protected void getTraces_serviceNames_mixedTraceIdLength(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix);
        this.accept(TestObjects.spanBuilder(testSuffix).traceId(clientSpan.traceId().substring(16)).localEndpoint(Endpoint.newBuilder().serviceName(TestObjects.appendSuffix("foo", testSuffix)).build()).remoteEndpoint(Endpoint.newBuilder().serviceName(TestObjects.appendSuffix("bar", testSuffix)).build()).build());
        this.getTraces_serviceNames(clientSpan);
    }

    @Test
    protected void getTraces_spanName(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        this.getTraces_spanName(TestObjects.newClientSpan(testSuffix));
    }

    void getTraces_spanName(Span clientSpan) throws Exception {
        this.accept(clientSpan);
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().spanName(clientSpan.name() + "1").build());
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().serviceName(clientSpan.localServiceName()).spanName(clientSpan.name() + "1").build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().spanName(clientSpan.name()).build(), Arrays.asList(clientSpan));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(clientSpan.localServiceName()).spanName(clientSpan.name()).build(), Arrays.asList(clientSpan));
    }

    @Test
    protected void getTraces_spanName_mixedTraceIdLength(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix);
        this.accept(clientSpan.toBuilder().traceId(clientSpan.traceId().substring(16)).name("bar").build());
        this.getTraces_spanName(clientSpan);
    }

    @Test
    protected void getTraces_tags(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix);
        this.accept(clientSpan);
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().annotationQuery(Collections.singletonMap("foo", "bar")).build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().annotationQuery(clientSpan.tags()).build(), Arrays.asList(clientSpan));
    }

    @Test
    protected void getTraces_minDuration(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix);
        this.accept(clientSpan);
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().minDuration(Long.valueOf(clientSpan.durationAsLong() + 1L)).build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().minDuration(Long.valueOf(clientSpan.durationAsLong())).build(), Arrays.asList(clientSpan));
    }

    @Test
    protected void getTraces_lateDuration(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix);
        Span missingDuration = clientSpan.toBuilder().duration(0L).build();
        Span lateDuration = Span.newBuilder().traceId(clientSpan.traceId()).id(clientSpan.id()).timestamp(clientSpan.timestampAsLong()).duration(clientSpan.durationAsLong()).localEndpoint(clientSpan.localEndpoint()).build();
        this.accept(missingDuration);
        this.accept(lateDuration);
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().minDuration(Long.valueOf(clientSpan.durationAsLong() + 1L)).build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().minDuration(Long.valueOf(clientSpan.durationAsLong())).build(), Arrays.asList(lateDuration, missingDuration));
    }

    @Test
    protected void getTraces_maxDuration(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix);
        this.accept(clientSpan);
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().minDuration(Long.valueOf(clientSpan.durationAsLong() - 2L)).maxDuration(Long.valueOf(clientSpan.durationAsLong() - 1L)).build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().minDuration(Long.valueOf(clientSpan.durationAsLong())).maxDuration(Long.valueOf(clientSpan.durationAsLong())).build(), Arrays.asList(clientSpan));
    }

    @Test
    protected void readback_minimalErrorSpan(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        String serviceName = TestObjects.appendSuffix("isao01", testSuffix);
        Span errorSpan = Span.newBuilder().traceId(TestObjects.newTraceId()).id("1").timestamp(TestObjects.TODAY * 1000L).localEndpoint(Endpoint.newBuilder().serviceName(serviceName).build()).kind(Span.Kind.CLIENT).putTag("error", "").build();
        this.accept(errorSpan);
        QueryRequest.Builder requestBuilder = ITSpanStore.requestBuilder().serviceName(serviceName);
        this.assertGetTracesReturns(requestBuilder.build(), Arrays.asList(errorSpan));
        this.assertGetTracesReturns(requestBuilder.parseAnnotationQuery("error").build(), Arrays.asList(errorSpan));
        this.assertGetTracesReturnsEmpty(requestBuilder.parseAnnotationQuery("error=1").build());
        this.assertGetTraceReturns(errorSpan);
    }

    @Test
    protected void readsBackLargeValues(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        char[] kilobyteOfText = new char[1024];
        Arrays.fill(kilobyteOfText, 'a');
        Span span = TestObjects.spanBuilder(testSuffix).name("big").putTag("a", new String(kilobyteOfText)).build();
        this.accept(span);
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().build(), Arrays.asList(span));
        this.assertGetTraceReturns(span);
    }

    @Test
    protected void spanWithProblematicData(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span part1 = TestObjects.spanBuilder(testSuffix).putTag("http.path", "/api").build();
        this.accept(part1);
        String json = "{\"foo\":\"bar\"}";
        Span part2 = part1.toBuilder().name(json).clearTags().putTag("http.path.morepath", "/api/api").build();
        this.accept(part2);
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(part1.localServiceName()).spanName(json).build(), Arrays.asList(part2, part1));
        this.assertGetTraceReturns(part1.traceId(), Arrays.asList(part2, part1));
    }

    @Test
    protected void getTraces_duration(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        Endpoint db = TestObjects.suffixServiceName(TestObjects.DB, testSuffix);
        List<List<Span>> traces = this.setupDurationData(testInfo);
        List<Span> trace1 = traces.get(0);
        List<Span> trace2 = traces.get(1);
        List<Span> trace3 = traces.get(2);
        QueryRequest.Builder q = ITSpanStore.requestBuilder().endTs(TestObjects.TODAY).lookback(TestObjects.DAY);
        this.assertGetTracesReturns(q.serviceName(frontend.serviceName()).minDuration(Long.valueOf(200000L)).build(), trace1);
        this.assertGetTracesReturns(q.serviceName(db.serviceName()).minDuration(Long.valueOf(200000L)).build(), trace2);
        this.assertGetTracesReturns(q.serviceName(backend.serviceName()).minDuration(Long.valueOf(50000L)).maxDuration(Long.valueOf(150000L)).build(), trace1, trace2, trace3);
        this.assertGetTracesReturns(q.serviceName(frontend.serviceName()).remoteServiceName(backend.serviceName()).maxDuration(Long.valueOf(50000L)).build(), trace2);
        this.assertGetTracesReturns(q.serviceName(backend.serviceName()).spanName("zip").maxDuration(Long.valueOf(50000L)).build(), trace3);
        this.assertGetTracesReturns(q.serviceName(backend.serviceName()).minDuration(Long.valueOf(50000L)).maxDuration(Long.valueOf(50000L)).build(), trace3);
    }

    @Test
    protected void getTraces_absentWhenNoTimestamp(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span span = TestObjects.spanBuilder(testSuffix).build();
        Span spanWithoutTimestamp = span.toBuilder().timestamp(0L).duration(0L).build();
        this.accept(spanWithoutTimestamp);
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().serviceName(span.localServiceName()).build());
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().serviceName(span.localServiceName()).spanName(span.remoteServiceName()).build());
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().serviceName(span.localServiceName()).spanName(span.name()).build());
        this.accept(span);
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(span.localServiceName()).build(), Arrays.asList(spanWithoutTimestamp, span));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(span.localServiceName()).remoteServiceName(span.remoteServiceName()).build(), Arrays.asList(spanWithoutTimestamp, span));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(span.localServiceName()).spanName(span.name()).build(), Arrays.asList(spanWithoutTimestamp, span));
    }

    @Test
    protected void getTraces_differentiatesDebugFromShared(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix).toBuilder().debug(true).build();
        Span serverSpan = clientSpan.toBuilder().kind(Span.Kind.SERVER).debug(null).shared(true).build();
        this.accept(clientSpan, serverSpan);
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().build(), Arrays.asList(clientSpan, serverSpan));
    }

    @Test
    protected void getTraces_annotation(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix).toBuilder().addAnnotation(TestObjects.TODAY, "foo").build();
        this.accept(clientSpan);
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(clientSpan.localServiceName()).parseAnnotationQuery(((Annotation)clientSpan.annotations().get(0)).value()).build(), Arrays.asList(clientSpan));
        Map.Entry tag = clientSpan.tags().entrySet().iterator().next();
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(clientSpan.localServiceName()).parseAnnotationQuery((String)tag.getKey() + "=" + (String)tag.getValue()).build(), Arrays.asList(clientSpan));
    }

    @Test
    protected void getTraces_multipleAnnotationsBecomeAndFilter(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Span foo = Span.newBuilder().traceId(TestObjects.newTraceId()).name("call1").id(1L).timestamp((TestObjects.TODAY + 1L) * 1000L).localEndpoint(frontend).addAnnotation((TestObjects.TODAY + 1L) * 1000L, "foo").build();
        Span barAndFoo = Span.newBuilder().traceId(TestObjects.newTraceId()).name("call2").id(2L).timestamp((TestObjects.TODAY + 2L) * 1000L).localEndpoint(frontend).addAnnotation((TestObjects.TODAY + 2L) * 1000L, "bar").addAnnotation((TestObjects.TODAY + 2L) * 1000L, "foo").build();
        Span fooAndBazAndQux = Span.newBuilder().traceId(TestObjects.newTraceId()).name("call3").id(3L).timestamp((TestObjects.TODAY + 3L) * 1000L).localEndpoint(frontend).addAnnotation((TestObjects.TODAY + 3L) * 1000L, "foo").putTag("baz", "qux").build();
        Span barAndFooAndBazAndQux = Span.newBuilder().traceId(TestObjects.newTraceId()).name("call4").id(4L).timestamp((TestObjects.TODAY + 4L) * 1000L).localEndpoint(frontend).addAnnotation((TestObjects.TODAY + 4L) * 1000L, "bar").addAnnotation((TestObjects.TODAY + 4L) * 1000L, "foo").putTag("baz", "qux").build();
        this.accept(foo, barAndFoo, fooAndBazAndQux, barAndFooAndBazAndQux);
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(frontend.serviceName()).parseAnnotationQuery("foo").build(), Arrays.asList(foo), Arrays.asList(barAndFoo), Arrays.asList(fooAndBazAndQux), Arrays.asList(barAndFooAndBazAndQux));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(frontend.serviceName()).parseAnnotationQuery("foo and bar").build(), Arrays.asList(barAndFoo), Arrays.asList(barAndFooAndBazAndQux));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(frontend.serviceName()).parseAnnotationQuery("foo and bar and baz=qux").build(), Arrays.asList(barAndFooAndBazAndQux));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(frontend.serviceName()).parseAnnotationQuery("baz").build(), Arrays.asList(fooAndBazAndQux), Arrays.asList(barAndFooAndBazAndQux));
    }

    @Test
    protected void getTraces_differentiateOnServiceName(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        Span trace1 = Span.newBuilder().traceId(TestObjects.newTraceId()).name("1").id(1L).kind(Span.Kind.CLIENT).timestamp((TestObjects.TODAY + 1L) * 1000L).duration(3000L).localEndpoint(frontend).addAnnotation((TestObjects.TODAY + 1L) * 1000L + 500L, "web").putTag("local", "web").putTag("web-b", "web").build();
        Span trace1Server = Span.newBuilder().traceId(trace1.traceId()).name("1").id(1L).kind(Span.Kind.SERVER).shared(true).localEndpoint(backend).timestamp((TestObjects.TODAY + 2L) * 1000L).duration(1000L).build();
        Span trace2 = Span.newBuilder().traceId(TestObjects.newTraceId()).name("2").id(2L).timestamp((TestObjects.TODAY + 11L) * 1000L).duration(3000L).kind(Span.Kind.CLIENT).localEndpoint(backend).addAnnotation((TestObjects.TODAY + 11L) * 1000L + 500L, "app").putTag("local", "app").putTag("app-b", "app").build();
        Span trace2Server = Span.newBuilder().traceId(trace2.traceId()).name("2").id(2L).shared(true).kind(Span.Kind.SERVER).localEndpoint(frontend).timestamp((TestObjects.TODAY + 12L) * 1000L).duration(1000L).build();
        this.accept(trace1, trace1Server, trace2, trace2Server);
        this.assertGetTraceReturns(trace1.traceId(), Arrays.asList(trace1, trace1Server));
        this.assertGetTraceReturns(trace2.traceId(), Arrays.asList(trace2, trace2Server));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().build(), Arrays.asList(trace1, trace1Server), Arrays.asList(trace2, trace2Server));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(frontend.serviceName()).parseAnnotationQuery("web").build(), Arrays.asList(trace1, trace1Server));
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().serviceName(backend.serviceName()).parseAnnotationQuery("web").build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(backend.serviceName()).parseAnnotationQuery("app").build(), Arrays.asList(trace2, trace2Server));
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().serviceName(frontend.serviceName()).parseAnnotationQuery("app").build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(frontend.serviceName()).parseAnnotationQuery("web-b").build(), Arrays.asList(trace1, trace1Server));
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().serviceName(backend.serviceName()).parseAnnotationQuery("web-b").build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(backend.serviceName()).parseAnnotationQuery("app-b").build(), Arrays.asList(trace2, trace2Server));
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().serviceName(frontend.serviceName()).parseAnnotationQuery("app-b").build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(frontend.serviceName()).parseAnnotationQuery("local=web").build(), Arrays.asList(trace1, trace1Server));
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().serviceName(backend.serviceName()).parseAnnotationQuery("local=web").build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(backend.serviceName()).parseAnnotationQuery("local=app").build(), Arrays.asList(trace2, trace2Server));
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().serviceName(frontend.serviceName()).parseAnnotationQuery("local=app").build());
    }

    @Test
    protected void getTraces_limit(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span span1 = TestObjects.spanBuilder(testSuffix).build();
        Span span2 = span1.toBuilder().traceId(TestObjects.newTraceId()).timestamp((TestObjects.TODAY + 2L) * 1000L).build();
        this.accept(span1, span2);
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(span1.localServiceName()).limit(1).build(), Arrays.asList(span2));
    }

    @Test
    protected void getTraces_endTsAndLookback(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span span1 = TestObjects.spanBuilder(testSuffix).timestamp((TestObjects.TODAY + 1L) * 1000L).build();
        Span span2 = span1.toBuilder().traceId(TestObjects.newTraceId()).timestamp((TestObjects.TODAY + 2L) * 1000L).build();
        this.accept(span1, span2);
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY).build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + 1L).build(), Arrays.asList(span1));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + 2L).build(), Arrays.asList(span1), Arrays.asList(span2));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + 3L).build(), Arrays.asList(span1), Arrays.asList(span2));
        this.assertGetTracesReturnsEmpty(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY).build());
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + 1L).lookback(1L).build(), Arrays.asList(span1));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + 2L).lookback(1L).build(), Arrays.asList(span1), Arrays.asList(span2));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().endTs(TestObjects.TODAY + 3L).lookback(1L).build(), Arrays.asList(span2));
    }

    @Test
    protected void names_goLowercase(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix);
        this.accept(clientSpan);
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(clientSpan.localServiceName()).remoteServiceName(clientSpan.remoteServiceName().toUpperCase(Locale.ROOT)).build(), Arrays.asList(clientSpan));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(clientSpan.localServiceName()).spanName(clientSpan.name().toUpperCase(Locale.ROOT)).build(), Arrays.asList(clientSpan));
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().serviceName(clientSpan.localServiceName()).remoteServiceName(clientSpan.remoteServiceName().toUpperCase(Locale.ROOT)).build(), Arrays.asList(clientSpan));
    }

    @Test
    protected void getTraces_endTsInsideTheTrace(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        List<Span> trace = TestObjects.newTrace(testSuffix);
        this.accept(trace);
        long lookback = trace.get(0).durationAsLong() / 1000L;
        this.assertGetTracesReturns(ITSpanStore.requestBuilder().endTs(TestObjects.endTs(trace)).lookback(lookback).build(), trace);
    }

    List<List<Span>> setupDurationData(TestInfo testInfo) throws Exception {
        String testSuffix = ITSpanStore.testSuffix(testInfo);
        Endpoint frontend = TestObjects.suffixServiceName(TestObjects.FRONTEND, testSuffix);
        Endpoint backend = TestObjects.suffixServiceName(TestObjects.BACKEND, testSuffix);
        Endpoint db = TestObjects.suffixServiceName(TestObjects.DB, testSuffix);
        String traceId1 = TestObjects.newTraceId();
        String traceId2 = TestObjects.newTraceId();
        String traceId3 = TestObjects.newTraceId();
        long offsetMicros = (TestObjects.TODAY - 3L) * 1000L;
        Span targz = Span.newBuilder().traceId(traceId1).id(1L).name("targz").timestamp(offsetMicros + 100L).duration(200000L).localEndpoint(frontend).remoteEndpoint(db).putTag("lc", "archiver").build();
        Span tar = Span.newBuilder().traceId(traceId1).id(2L).parentId(1L).name("tar").timestamp(offsetMicros + 200L).duration(150000L).localEndpoint(backend).remoteEndpoint(backend).putTag("lc", "archiver").build();
        Span gz = Span.newBuilder().traceId(traceId1).id(3L).parentId(1L).name("gz").timestamp(offsetMicros + 250L).duration(50000L).localEndpoint(db).remoteEndpoint(frontend).putTag("lc", "archiver").build();
        Span zip = Span.newBuilder().traceId(traceId3).id(3L).name("zip").timestamp(offsetMicros + 130L).duration(50000L).addAnnotation(offsetMicros + 130L, "zip").localEndpoint(backend).remoteEndpoint(backend).putTag("lc", "archiver").build();
        List<Span> trace1 = Arrays.asList(targz, tar, gz);
        List<Span> trace2 = Arrays.asList(targz.toBuilder().traceId(traceId2).timestamp(offsetMicros + 110L).localEndpoint(db).remoteEndpoint(frontend).putTag("lc", "archiver-v2").build(), tar.toBuilder().traceId(traceId2).timestamp(offsetMicros + 210L).localEndpoint(backend).remoteEndpoint(backend).putTag("lc", "archiver").build(), gz.toBuilder().traceId(traceId2).timestamp(offsetMicros + 260L).localEndpoint(frontend).remoteEndpoint(backend).putTag("lc", "archiver").build());
        List<Span> trace3 = Arrays.asList(zip);
        this.accept(trace1);
        this.accept(trace2);
        this.accept(trace3);
        return Arrays.asList(trace1, trace2, trace3);
    }

    private static /* synthetic */ void lambda$consumer_implementsCall_submit$0(Call call, Callback callback) throws Throwable {
        call.enqueue(callback);
    }
}

