/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITStorage;
import zipkin2.storage.StorageComponent;

public abstract class ITSearchEnabledFalse<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
        storage.searchEnabled(false);
    }

    @Test
    protected void getTraces_indexDataReturnsNothing(TestInfo testInfo) throws Exception {
        String testSuffix = ITSearchEnabledFalse.testSuffix(testInfo);
        Span clientSpan = TestObjects.newClientSpan(testSuffix);
        this.accept(clientSpan);
        this.assertGetTracesReturnsEmpty(ITSearchEnabledFalse.requestBuilder().build());
        this.assertGetTracesReturnsEmpty(ITSearchEnabledFalse.requestBuilder().serviceName(clientSpan.localServiceName()).build());
        this.assertGetTracesReturnsEmpty(ITSearchEnabledFalse.requestBuilder().spanName(clientSpan.name()).build());
        this.assertGetTracesReturnsEmpty(ITSearchEnabledFalse.requestBuilder().annotationQuery(clientSpan.tags()).build());
        this.assertGetTracesReturnsEmpty(ITSearchEnabledFalse.requestBuilder().minDuration(clientSpan.duration()).build());
    }

    @Test
    protected void getServiceNames_isEmpty(TestInfo testInfo) throws Exception {
        String testSuffix = ITSearchEnabledFalse.testSuffix(testInfo);
        this.accept(TestObjects.spanBuilder(testSuffix).build());
        Assertions.assertThat((List)((List)this.names().getServiceNames().execute())).isEmpty();
    }

    @Test
    protected void getRemoteServiceNames_isEmpty(TestInfo testInfo) throws Exception {
        String testSuffix = ITSearchEnabledFalse.testSuffix(testInfo);
        Span span = TestObjects.spanBuilder(testSuffix).build();
        this.accept(span);
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames(span.localServiceName()).execute())).isEmpty();
    }

    @Test
    protected void getSpanNames_isEmpty(TestInfo testInfo) throws Exception {
        String testSuffix = ITSearchEnabledFalse.testSuffix(testInfo);
        Span span = TestObjects.spanBuilder(testSuffix).build();
        this.accept(span);
        Assertions.assertThat((List)((List)this.names().getSpanNames(span.localServiceName()).execute())).isEmpty();
    }
}

