/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestInstance;
import zipkin2.CheckResult;
import zipkin2.Span;
import zipkin2.storage.ServiceAndSpanNames;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.Traces;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class ITStorage<T extends StorageComponent> {
    protected T storage;

    @BeforeAll
    void initializeStorage(TestInfo testInfo) {
        if (this.initializeStoragePerTest()) {
            return;
        }
        this.doInitializeStorage(testInfo);
    }

    @BeforeEach
    void initializeStorageForTest(TestInfo testInfo) {
        if (!this.initializeStoragePerTest()) {
            return;
        }
        this.doInitializeStorage(testInfo);
    }

    void doInitializeStorage(TestInfo testInfo) {
        StorageComponent.Builder builder = this.newStorageBuilder(testInfo);
        this.configureStorageForTest(builder);
        StorageComponent storage = builder.build();
        this.storage = storage;
        CheckResult check = storage.check();
        Assumptions.assumeTrue((boolean)check.ok(), () -> "Could not connect to storage, skipping test: " + check.error().getMessage());
    }

    @AfterAll
    void closeStorage() throws Exception {
        if (this.initializeStoragePerTest()) {
            return;
        }
        this.storage.close();
    }

    @AfterEach
    void closeStorageForTest() throws Exception {
        if (!this.initializeStoragePerTest()) {
            return;
        }
        this.storage.close();
    }

    @AfterEach
    void clearStorage() throws Exception {
        this.clear();
    }

    protected boolean initializeStoragePerTest() {
        return false;
    }

    protected abstract StorageComponent.Builder newStorageBuilder(TestInfo var1);

    protected abstract void configureStorageForTest(StorageComponent.Builder var1);

    protected Traces traces() {
        return this.storage.traces();
    }

    protected SpanStore store() {
        return this.storage.spanStore();
    }

    protected ServiceAndSpanNames names() {
        return this.storage.serviceAndSpanNames();
    }

    protected final void accept(Span ... spans) throws IOException {
        this.accept(Arrays.asList(spans));
    }

    protected final void accept(List<Span> spans) throws IOException {
        int length = spans.size();
        for (int i = 0; i < length; i += 100) {
            this.storage.spanConsumer().accept(spans.subList(i, Math.min(length, i + 100))).execute();
            this.blockWhileInFlight();
        }
    }

    protected void blockWhileInFlight() {
    }

    protected abstract void clear() throws Exception;

    static List<List<Span>> sortTraces(List<List<Span>> traces) {
        ArrayList<List<Span>> result = new ArrayList<List<Span>>();
        for (List<Span> trace : traces) {
            result.add(ITStorage.sortTrace(trace));
        }
        Collections.sort(result, Comparator.comparing(o -> ((Span)o.get(0)).traceId()));
        return result;
    }

    static ArrayList<Span> sortTrace(List<Span> trace) {
        ArrayList<Span> result = new ArrayList<Span>(trace);
        result.sort((l, r) -> {
            int traceId = l.traceId().compareTo(r.traceId());
            return traceId == 0 ? Long.compare(l.timestampAsLong(), r.timestampAsLong()) : traceId;
        });
        return result;
    }
}

