/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import zipkin2.Annotation;
import zipkin2.DependencyLink;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.internal.DependencyLinker;
import zipkin2.storage.GroupByTraceId;
import zipkin2.storage.ITStorage;
import zipkin2.storage.StorageComponent;
import zipkin2.v1.V1Span;
import zipkin2.v1.V1SpanConverter;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class ITDependencies<T extends StorageComponent>
extends ITStorage<T> {
    static final Endpoint KAFKA = Endpoint.newBuilder().serviceName("kafka").build();
    static final List<DependencyLink> LINKS = Arrays.asList(DependencyLink.newBuilder().parent("frontend").child("backend").callCount(1L).build(), DependencyLink.newBuilder().parent("backend").child("db").callCount(1L).errorCount(1L).build());

    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
    }

    protected void processDependencies(List<Span> spans) throws Exception {
        this.storage.spanConsumer().accept(spans).execute();
    }

    @Test
    void getDependencies() throws Exception {
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.DAY).execute())).containsOnlyElementsOf(LINKS);
    }

    @Test
    void getDependencies_strictTraceId() throws Exception {
        List<Span> mixedTrace = Arrays.asList(Span.newBuilder().traceId("7180c278b62e8f6a216a2aea45d08fc9").id("1").name("get").kind(Span.Kind.SERVER).timestamp(TestObjects.TODAY * 1000L).duration(350000L).localEndpoint(TestObjects.FRONTEND).build(), Span.newBuilder().traceId("216a2aea45d08fc9").parentId("1").id("2").name("get").kind(Span.Kind.SERVER).shared(true).timestamp((TestObjects.TODAY + 100L) * 1000L).duration(250000L).localEndpoint(TestObjects.BACKEND).build(), Span.newBuilder().traceId("7180c278b62e8f6a216a2aea45d08fc9").parentId("1").id("2").kind(Span.Kind.CLIENT).timestamp((TestObjects.TODAY + 50L) * 1000L).duration(300000L).localEndpoint(TestObjects.FRONTEND).build());
        this.processDependencies(mixedTrace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("frontend").child("backend").callCount(1L).build()});
    }

    @Test
    void replayOverwrites() throws Exception {
        this.processDependencies(TestObjects.TRACE);
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.DAY).execute())).containsOnlyElementsOf(LINKS);
    }

    @Test
    void empty() throws Exception {
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.DAY).execute())).isEmpty();
    }

    @Test
    void traceIdIsOpaque() throws Exception {
        List<Span> differentTraceId = TestObjects.TRACE.stream().map(s -> s.toBuilder().traceId("123").build()).collect(Collectors.toList());
        this.processDependencies(differentTraceId);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.DAY).execute())).containsOnlyElementsOf(LINKS);
    }

    @Test
    void getDependenciesAllInstrumented() throws Exception {
        Endpoint one = Endpoint.newBuilder().serviceName("trace-producer-one").ip("127.0.0.1").build();
        Endpoint onePort3001 = one.toBuilder().port(3001).build();
        Endpoint two = Endpoint.newBuilder().serviceName("trace-producer-two").ip("127.0.0.2").build();
        Endpoint twoPort3002 = two.toBuilder().port(3002).build();
        Endpoint three = Endpoint.newBuilder().serviceName("trace-producer-three").ip("127.0.0.3").build();
        List<Span> trace = Arrays.asList(Span.newBuilder().traceId("10").id("10").name("get").kind(Span.Kind.SERVER).timestamp(TestObjects.TODAY * 1000L).duration(350000L).localEndpoint(one).build(), Span.newBuilder().traceId("10").parentId("10").id("20").name("get").kind(Span.Kind.CLIENT).timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).localEndpoint(onePort3001).build(), Span.newBuilder().traceId("10").parentId("10").id("20").name("get").shared(true).kind(Span.Kind.SERVER).timestamp((TestObjects.TODAY + 100L) * 1000L).duration(150000L).localEndpoint(two).build(), Span.newBuilder().traceId("10").parentId("20").id("30").name("query").kind(Span.Kind.CLIENT).timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).localEndpoint(twoPort3002).build(), Span.newBuilder().traceId("10").parentId("20").id("30").name("query").shared(true).kind(Span.Kind.SERVER).timestamp((TestObjects.TODAY + 160L) * 1000L).duration(20000L).localEndpoint(three).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("trace-producer-one").child("trace-producer-two").callCount(1L).build(), DependencyLink.newBuilder().parent("trace-producer-two").child("trace-producer-three").callCount(1L).build()});
    }

    @Test
    void dependencies_loopback() throws Exception {
        List<Span> traceWithLoopback = Arrays.asList(TestObjects.TRACE.get(0), TestObjects.TRACE.get(1).toBuilder().remoteEndpoint(TestObjects.TRACE.get(0).localEndpoint()).build());
        this.processDependencies(traceWithLoopback);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.TRACE_DURATION).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("frontend").child("frontend").callCount(1L).build()});
    }

    @Test
    void dependencies_headlessTrace() throws Exception {
        ArrayList<Span> trace = new ArrayList<Span>(TestObjects.TRACE);
        trace.remove(0);
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.DAY).execute())).containsOnlyElementsOf(LINKS);
    }

    @Test
    void looksBackIndefinitely() throws Exception {
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.TRACE_ENDTS).execute())).containsOnlyElementsOf(LINKS);
    }

    @Test
    void endTsInsideTheTrace() throws Exception {
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_STARTTS + 100L, 200L).execute())).containsOnlyElementsOf(LINKS);
    }

    @Test
    void endTimeBeforeData() throws Exception {
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_STARTTS - 1000L, 1000L).execute())).isEmpty();
    }

    @Test
    void lookbackAfterData() throws Exception {
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TODAY + 2L * TestObjects.DAY, TestObjects.DAY).execute())).isEmpty();
    }

    @Test
    void notInstrumentedClientAndServer() throws Exception {
        Endpoint someClient = Endpoint.newBuilder().serviceName("some-client").ip("172.17.0.4").build();
        List<Span> trace = Arrays.asList(Span.newBuilder().traceId("20").id("20").name("get").timestamp(TestObjects.TODAY * 1000L).duration(350000L).kind(Span.Kind.SERVER).localEndpoint(TestObjects.FRONTEND).remoteEndpoint(someClient).build(), Span.newBuilder().traceId("20").parentId("20").id("21").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).kind(Span.Kind.CLIENT).localEndpoint(TestObjects.FRONTEND).build(), Span.newBuilder().traceId("20").parentId("20").id("21").name("get").shared(true).timestamp((TestObjects.TODAY + 250L) * 1000L).duration(50000L).kind(Span.Kind.SERVER).localEndpoint(TestObjects.BACKEND).build(), Span.newBuilder().traceId("20").parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).kind(Span.Kind.CLIENT).localEndpoint(TestObjects.BACKEND).remoteEndpoint(TestObjects.DB).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("some-client").child("frontend").callCount(1L).build(), DependencyLink.newBuilder().parent("frontend").child("backend").callCount(1L).build(), DependencyLink.newBuilder().parent("backend").child("db").callCount(1L).build()});
    }

    @Test
    void endTsAndLookbackMustBePositive() throws IOException {
        try {
            this.store().getDependencies(0L, TestObjects.DAY).execute();
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("endTs <= 0");
        }
        try {
            this.store().getDependencies(TestObjects.TRACE_ENDTS, 0L).execute();
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("lookback <= 0");
        }
    }

    @Test
    void instrumentedClientAndServer() throws Exception {
        List<Span> trace = Arrays.asList(Span.newBuilder().traceId("10").id("10").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).kind(Span.Kind.CLIENT).localEndpoint(TestObjects.FRONTEND).build(), Span.newBuilder().traceId("10").id("10").name("get").shared(true).timestamp((TestObjects.TODAY + 100L) * 1000L).duration(150000L).kind(Span.Kind.SERVER).localEndpoint(TestObjects.BACKEND).build(), Span.newBuilder().traceId("10").parentId("10").id("11").name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).kind(Span.Kind.CLIENT).localEndpoint(TestObjects.BACKEND).remoteEndpoint(TestObjects.DB).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("frontend").child("backend").callCount(1L).build(), DependencyLink.newBuilder().parent("backend").child("db").callCount(1L).build()});
    }

    @Test
    void instrumentedProducerAndConsumer() throws Exception {
        List<Span> trace = Arrays.asList(Span.newBuilder().traceId("10").id("10").name("send").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(1L).kind(Span.Kind.PRODUCER).localEndpoint(TestObjects.FRONTEND).remoteEndpoint(KAFKA).build(), Span.newBuilder().traceId("10").parentId("10").id("11").name("receive").timestamp((TestObjects.TODAY + 100L) * 1000L).duration(1L).kind(Span.Kind.CONSUMER).remoteEndpoint(KAFKA).localEndpoint(TestObjects.BACKEND).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("frontend").child("kafka").callCount(1L).build(), DependencyLink.newBuilder().parent("kafka").child("backend").callCount(1L).build()});
    }

    @Test
    void manyLinks() throws Exception {
        int count = 1000;
        ArrayList<Span> spans = new ArrayList<Span>(count);
        for (int i = 1; i <= count; ++i) {
            Endpoint web = TestObjects.FRONTEND.toBuilder().serviceName("web-" + i).build();
            Endpoint app = TestObjects.BACKEND.toBuilder().serviceName("app-" + i).build();
            Endpoint db = TestObjects.DB.toBuilder().serviceName("db-" + i).build();
            spans.add(Span.newBuilder().traceId(Integer.toHexString(i)).id("10").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).kind(Span.Kind.CLIENT).localEndpoint(web).build());
            spans.add(Span.newBuilder().traceId(Integer.toHexString(i)).id("10").name("get").shared(true).timestamp((TestObjects.TODAY + 100L) * 1000L).duration(150000L).kind(Span.Kind.SERVER).localEndpoint(app).build());
            spans.add(Span.newBuilder().traceId(Integer.toHexString(i)).parentId("10").id("11").name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).kind(Span.Kind.CLIENT).localEndpoint(app).remoteEndpoint(db).build());
        }
        this.processDependencies(spans);
        List links = (List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.DAY).execute();
        Assertions.assertThat((List)links).hasSize(count * 2);
        Assertions.assertThat((List)links).extracting(DependencyLink::callCount).allSatisfy(callCount -> Assertions.assertThat((Long)callCount).isEqualTo(1L));
    }

    @Test
    void missingIntermediateSpan() throws Exception {
        List<Span> trace = Arrays.asList(Span.newBuilder().traceId("20").id("20").name("get").timestamp(TestObjects.TODAY * 1000L).duration(350000L).kind(Span.Kind.SERVER).localEndpoint(TestObjects.FRONTEND).build(), Span.newBuilder().traceId("20").parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).kind(Span.Kind.CLIENT).localEndpoint(TestObjects.BACKEND).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("frontend").child("backend").callCount(1L).build()});
    }

    @Test
    void canSearchForIntervalsBesidesToday() throws Exception {
        this.processDependencies(this.subtractDay(TestObjects.TRACE));
        this.processDependencies(TestObjects.TRACE);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.TRACE_DURATION).execute())).containsOnlyElementsOf(LINKS);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS - TestObjects.DAY, TestObjects.DAY).execute())).containsOnlyElementsOf(LINKS);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.TRACE_ENDTS).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("frontend").child("backend").callCount(2L).build(), DependencyLink.newBuilder().parent("backend").child("db").callCount(2L).errorCount(2L).build()});
    }

    @Test
    void spanKindIsNotRequiredWhenEndpointsArePresent() throws Exception {
        Endpoint someClient = Endpoint.newBuilder().serviceName("some-client").ip("172.17.0.4").build();
        List<Span> trace = Arrays.asList(Span.newBuilder().traceId("20").id("20").name("get").timestamp(TestObjects.TODAY * 1000L).duration(350000L).localEndpoint(someClient).remoteEndpoint(TestObjects.FRONTEND).build(), Span.newBuilder().traceId("20").parentId("20").id("21").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).localEndpoint(TestObjects.FRONTEND).remoteEndpoint(TestObjects.BACKEND).build(), Span.newBuilder().traceId("20").parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).localEndpoint(TestObjects.BACKEND).remoteEndpoint(TestObjects.DB).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TODAY + 1000L, 1000L).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("some-client").child("frontend").callCount(1L).build(), DependencyLink.newBuilder().parent("frontend").child("backend").callCount(1L).build(), DependencyLink.newBuilder().parent("backend").child("db").callCount(1L).build()});
    }

    @Test
    void unnamedEndpointsAreSkipped() throws Exception {
        List<Span> trace = Arrays.asList(Span.newBuilder().traceId("20").id("20").name("get").timestamp(TestObjects.TODAY * 1000L).duration(350000L).localEndpoint(Endpoint.newBuilder().ip("172.17.0.4").build()).remoteEndpoint(TestObjects.FRONTEND).build(), Span.newBuilder().traceId("20").parentId("20").id("21").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).localEndpoint(TestObjects.FRONTEND).remoteEndpoint(TestObjects.BACKEND).build(), Span.newBuilder().traceId("20").parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).localEndpoint(TestObjects.BACKEND).remoteEndpoint(TestObjects.DB).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TODAY + 1000L, 1000L).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("frontend").child("backend").callCount(1L).build(), DependencyLink.newBuilder().parent("backend").child("db").callCount(1L).build()});
    }

    @Test
    void intermediateSpans() throws Exception {
        List<Span> trace = Arrays.asList(Span.newBuilder().traceId("20").id("20").name("get").timestamp(TestObjects.TODAY * 1000L).duration(350000L).kind(Span.Kind.SERVER).localEndpoint(TestObjects.FRONTEND).build(), Span.newBuilder().traceId("20").parentId("20").id("21").name("call").timestamp((TestObjects.TODAY + 25L) * 1000L).duration(325000L).localEndpoint(TestObjects.FRONTEND).build(), Span.newBuilder().traceId("20").parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).kind(Span.Kind.CLIENT).localEndpoint(TestObjects.FRONTEND).build(), Span.newBuilder().traceId("20").parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 100L) * 1000L).duration(150000L).shared(true).kind(Span.Kind.SERVER).localEndpoint(TestObjects.BACKEND).build(), Span.newBuilder().traceId("20").parentId("22").id(23L).name("call").timestamp((TestObjects.TODAY + 110L) * 1000L).duration(130000L).name("depth4").localEndpoint(TestObjects.BACKEND).build(), Span.newBuilder().traceId("20").parentId(23L).id(24L).name("call").timestamp((TestObjects.TODAY + 125L) * 1000L).duration(105000L).name("depth5").localEndpoint(TestObjects.BACKEND).build(), Span.newBuilder().traceId("20").parentId(24L).id(25L).name("get").timestamp((TestObjects.TODAY + 150L) * 1000L).duration(50000L).kind(Span.Kind.CLIENT).localEndpoint(TestObjects.BACKEND).remoteEndpoint(TestObjects.DB).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TODAY + 1000L, 1000L).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("frontend").child("backend").callCount(1L).build(), DependencyLink.newBuilder().parent("backend").child("db").callCount(1L).build()});
    }

    @Test
    void duplicateAddress() throws Exception {
        V1SpanConverter converter = V1SpanConverter.create();
        ArrayList<Span> trace = new ArrayList<Span>();
        converter.convert(V1Span.newBuilder().traceId("20").id("20").name("get").timestamp(TestObjects.TODAY * 1000L).duration(350000L).addAnnotation(TestObjects.TODAY * 1000L, "sr", TestObjects.FRONTEND).addAnnotation((TestObjects.TODAY + 350L) * 1000L, "ss", TestObjects.FRONTEND).addBinaryAnnotation("ca", TestObjects.FRONTEND).addBinaryAnnotation("sa", TestObjects.FRONTEND).build(), trace);
        converter.convert(V1Span.newBuilder().traceId("20").parentId("21").id("22").name("get").timestamp((TestObjects.TODAY + 50L) * 1000L).duration(250000L).addAnnotation((TestObjects.TODAY + 50L) * 1000L, "cs", TestObjects.FRONTEND).addAnnotation((TestObjects.TODAY + 300L) * 1000L, "cr", TestObjects.FRONTEND).addBinaryAnnotation("ca", TestObjects.BACKEND).addBinaryAnnotation("sa", TestObjects.BACKEND).build(), trace);
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TODAY + 1000L, 1000L).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("frontend").child("backend").callCount(1L).build()});
    }

    @Test
    void oneway() throws Exception {
        List<Span> trace = Arrays.asList(Span.newBuilder().traceId("10").id("10").timestamp((TestObjects.TODAY + 50L) * 1000L).kind(Span.Kind.CLIENT).localEndpoint(TestObjects.FRONTEND).build(), Span.newBuilder().traceId("10").id("10").shared(true).timestamp((TestObjects.TODAY + 100L) * 1000L).kind(Span.Kind.SERVER).localEndpoint(TestObjects.BACKEND).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.TRACE_DURATION).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("frontend").child("backend").callCount(1L).build()});
    }

    @Test
    void annotationNamedErrorIsntError() throws Exception {
        List<Span> trace = Arrays.asList(Span.newBuilder().traceId("10").id("10").timestamp((TestObjects.TODAY + 50L) * 1000L).kind(Span.Kind.CLIENT).localEndpoint(TestObjects.FRONTEND).build(), Span.newBuilder().traceId("10").id("10").shared(true).timestamp((TestObjects.TODAY + 100L) * 1000L).kind(Span.Kind.SERVER).localEndpoint(TestObjects.BACKEND).addAnnotation((TestObjects.TODAY + 72L) * 1000L, "error").build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.TRACE_DURATION).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("frontend").child("backend").callCount(1L).build()});
    }

    @Test
    void oneway_noClient() throws Exception {
        Endpoint kafka = Endpoint.newBuilder().serviceName("kafka").ip("172.17.0.4").build();
        List<Span> trace = Arrays.asList(Span.newBuilder().traceId("10").id("10").name("receive").timestamp(TestObjects.TODAY * 1000L).kind(Span.Kind.SERVER).localEndpoint(TestObjects.BACKEND).remoteEndpoint(kafka).build(), Span.newBuilder().traceId("10").parentId("10").id("11").name("process").timestamp((TestObjects.TODAY + 25L) * 1000L).duration(325000L).localEndpoint(TestObjects.BACKEND).build());
        this.processDependencies(trace);
        Assertions.assertThat((List)((List)this.store().getDependencies(TestObjects.TRACE_ENDTS, TestObjects.DAY).execute())).containsOnly((Object[])new DependencyLink[]{DependencyLink.newBuilder().parent("kafka").child("backend").callCount(1L).build()});
    }

    List<Span> subtractDay(List<Span> trace) {
        long random = new Random().nextLong();
        return trace.stream().map(s -> {
            Span.Builder b = s.toBuilder().traceId(Long.toHexString(random));
            if (s.timestampAsLong() != 0L) {
                b.timestamp(s.timestampAsLong() - TestObjects.DAY * 1000L);
            }
            s.annotations().forEach(a -> b.addAnnotation(a.timestamp() - TestObjects.DAY * 1000L, a.value()));
            return b.build();
        }).collect(Collectors.toList());
    }

    protected Map<Long, List<DependencyLink>> aggregateLinks(List<Span> spans) {
        LinkedHashMap<Long, DependencyLinker> midnightToLinker = new LinkedHashMap<Long, DependencyLinker>();
        for (List trace : (List)GroupByTraceId.create((boolean)false).map(spans)) {
            long midnightOfTrace = ITDependencies.flooredTraceTimestamp(trace);
            DependencyLinker linker2 = (DependencyLinker)midnightToLinker.get(midnightOfTrace);
            if (linker2 == null) {
                linker2 = new DependencyLinker();
                midnightToLinker.put(midnightOfTrace, linker2);
            }
            linker2.putTrace(trace);
        }
        LinkedHashMap<Long, List<DependencyLink>> result = new LinkedHashMap<Long, List<DependencyLink>>();
        midnightToLinker.forEach((midnight, linker) -> result.put((Long)midnight, linker.link()));
        return result;
    }

    static long flooredTraceTimestamp(List<Span> trace) {
        long midnightOfTrace = Long.MAX_VALUE;
        for (Span span : trace) {
            long currentTs = ITDependencies.guessTimestamp(span);
            if (currentTs == 0L || currentTs >= midnightOfTrace) continue;
            midnightOfTrace = TestObjects.midnightUTC(currentTs / 1000L);
        }
        Assertions.assertThat((long)midnightOfTrace).isNotEqualTo(Long.MAX_VALUE);
        return midnightOfTrace;
    }

    static long guessTimestamp(Span span) {
        if (span.timestampAsLong() != 0L) {
            return span.timestampAsLong();
        }
        for (Annotation annotation : span.annotations()) {
            if (0L >= annotation.timestamp()) continue;
            return annotation.timestamp();
        }
        return 0L;
    }
}

