/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestInstance;
import zipkin2.CheckResult;
import zipkin2.storage.ServiceAndSpanNames;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class ITStorage<T extends StorageComponent> {
    protected T storage;

    @BeforeAll
    void initializeStorage(TestInfo testInfo) {
        if (this.initializeStoragePerTest()) {
            return;
        }
        this.doInitializeStorage(testInfo);
    }

    @BeforeEach
    void initializeStorageForTest(TestInfo testInfo) {
        if (!this.initializeStoragePerTest()) {
            return;
        }
        this.doInitializeStorage(testInfo);
    }

    void doInitializeStorage(TestInfo testInfo) {
        StorageComponent.Builder builder = this.newStorageBuilder(testInfo);
        this.configureStorageForTest(builder);
        StorageComponent storage = builder.build();
        this.storage = storage;
        CheckResult check = storage.check();
        Assumptions.assumeTrue((boolean)check.ok(), () -> "Could not connect to storage, skipping test: " + check.error().getMessage());
    }

    @AfterAll
    void closeStorage() throws Exception {
        if (this.initializeStoragePerTest()) {
            return;
        }
        this.storage.close();
    }

    @AfterEach
    void closeStorageForTest() throws Exception {
        if (!this.initializeStoragePerTest()) {
            return;
        }
        this.storage.close();
    }

    @AfterEach
    void clearStorage() throws Exception {
        this.clear();
    }

    protected boolean initializeStoragePerTest() {
        return false;
    }

    protected abstract StorageComponent.Builder newStorageBuilder(TestInfo var1);

    protected abstract void configureStorageForTest(StorageComponent.Builder var1);

    protected SpanStore store() {
        return this.storage.spanStore();
    }

    protected ServiceAndSpanNames names() {
        return this.storage.serviceAndSpanNames();
    }

    protected abstract void clear() throws Exception;
}

