/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITSpanStore;
import zipkin2.storage.ITStorage;
import zipkin2.storage.StorageComponent;

public abstract class ITSearchEnabledFalse<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
        storage.searchEnabled(false);
    }

    @Test
    void getTraces_indexDataReturnsNothing() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.CLIENT_SPAN.localServiceName()).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().spanName(TestObjects.CLIENT_SPAN.name()).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().annotationQuery(TestObjects.CLIENT_SPAN.tags()).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().minDuration(TestObjects.CLIENT_SPAN.duration()).build()).execute())).isEmpty();
    }

    @Test
    void getServiceNames_isEmpty() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.names().getServiceNames().execute())).isEmpty();
    }

    @Test
    void getRemoteServiceNames_isEmpty() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames(TestObjects.CLIENT_SPAN.localServiceName()).execute())).isEmpty();
    }

    @Test
    void getSpanNames_isEmpty() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.names().getSpanNames(TestObjects.CLIENT_SPAN.localServiceName()).execute())).isEmpty();
    }

    protected void accept(Span ... spans) throws IOException {
        this.storage.spanConsumer().accept(Arrays.asList(spans)).execute();
    }
}

