/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITStorage;
import zipkin2.storage.StorageComponent;

public abstract class ITAutocompleteTags<T extends StorageComponent>
extends ITStorage<T> {
    @Override
    protected final void configureStorageForTest(StorageComponent.Builder storage) {
        storage.autocompleteKeys(Arrays.asList("http.host"));
    }

    @Test
    void Should_not_store_when_key_not_in_autocompleteTags() throws IOException {
        this.accept(TestObjects.LOTS_OF_SPANS[0].toBuilder().timestamp(Instant.now().toEpochMilli()).putTag("http.method", "GET").build());
        Assertions.assertThat((List)((List)this.storage.autocompleteTags().getKeys().execute())).doesNotContain((Object[])new String[]{"http.method"});
        Assertions.assertThat((List)((List)this.storage.autocompleteTags().getValues("http.method").execute())).isEmpty();
    }

    @Test
    void getTagsAndValues() throws IOException {
        for (int i = 0; i < 2; ++i) {
            this.accept(TestObjects.LOTS_OF_SPANS[i].toBuilder().putTag("http.method", "GET").putTag("http.host", "host1").build());
        }
        Assertions.assertThat((List)((List)this.storage.autocompleteTags().getKeys().execute())).containsOnlyOnce((Object[])new String[]{"http.host"});
        Assertions.assertThat((List)((List)this.storage.autocompleteTags().getValues("http.host").execute())).containsOnlyOnce((Object[])new String[]{"host1"});
    }

    protected void accept(Span ... spans) throws IOException {
        this.storage.spanConsumer().accept(Arrays.asList(spans)).execute();
    }
}

