/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ITSpanStore;
import zipkin2.storage.ServiceAndSpanNames;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;

public abstract class ITSearchEnabledFalse {
    protected abstract StorageComponent storage();

    protected SpanStore store() {
        return this.storage().spanStore();
    }

    protected ServiceAndSpanNames names() {
        return this.storage().serviceAndSpanNames();
    }

    @Before
    public abstract void clear() throws Exception;

    @Test
    public void getTraces_indexDataReturnsNothing() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().serviceName(TestObjects.CLIENT_SPAN.localServiceName()).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().spanName(TestObjects.CLIENT_SPAN.name()).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().annotationQuery(TestObjects.CLIENT_SPAN.tags()).build()).execute())).isEmpty();
        Assertions.assertThat((List)((List)this.store().getTraces(ITSpanStore.requestBuilder().minDuration(TestObjects.CLIENT_SPAN.duration()).build()).execute())).isEmpty();
    }

    @Test
    public void getServiceNames_isEmpty() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.names().getServiceNames().execute())).isEmpty();
    }

    @Test
    public void getRemoteServiceNames_isEmpty() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.names().getRemoteServiceNames(TestObjects.CLIENT_SPAN.localServiceName()).execute())).isEmpty();
    }

    @Test
    public void getSpanNames_isEmpty() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.names().getSpanNames(TestObjects.CLIENT_SPAN.localServiceName()).execute())).isEmpty();
    }

    protected void accept(Span ... spans) throws IOException {
        this.storage().spanConsumer().accept(Arrays.asList(spans)).execute();
    }
}

